/*
 * Decompiled with CFR 0.152.
 */
package ch.bluecare.commons.data;

import ch.bluecare.commons.data.PList;
import ch.bluecare.commons.data.Pair;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;

public final class NonEmptyList<A>
implements Iterable<A>,
IntFunction<A> {
    private final A head;
    private final PList<A> tail;
    private final PList<A> all;

    public NonEmptyList(A head, PList<A> tail) {
        this.head = head;
        this.tail = tail;
        this.all = tail.cons(head);
    }

    public static <A> NonEmptyList<A> of(A first, A ... other) {
        return new NonEmptyList<A>(first, PList.fromArray(other));
    }

    public static <A> NonEmptyList<A> single(A el) {
        return new NonEmptyList<A>(el, PList.nil());
    }

    public static <A> Optional<NonEmptyList<A>> fromIter(Iterable<A> iter) {
        PList<A> list = PList.fromIter(iter);
        return list.nonEmpty() ? Optional.of(new NonEmptyList<A>(list.head(), list.tail())) : Optional.empty();
    }

    public A head() {
        return this.head;
    }

    public PList<A> tail() {
        return this.tail;
    }

    public NonEmptyList<A> concat(Iterable<A> next) {
        return new NonEmptyList<A>(this.head, this.tail.concat(PList.fromIter(next)));
    }

    public NonEmptyList<A> cons(A el) {
        return new NonEmptyList<A>(el, this.toPList());
    }

    public NonEmptyList<A> add(A element) {
        return new NonEmptyList<A>(this.head, this.tail.add(element));
    }

    public <B> NonEmptyList<B> map(Function<A, B> f) {
        return new NonEmptyList<B>(f.apply(this.head), this.tail.map(f));
    }

    public <B> NonEmptyList<B> flatMap(Function<A, NonEmptyList<B>> f) {
        PList pl = this.toPList().flatMap((E e) -> ((NonEmptyList)f.apply(e)).toPList());
        return new NonEmptyList(pl.head(), pl.tail());
    }

    public A reduce(BinaryOperator<A> f) {
        return this.tail.foldLeft(this.head, f);
    }

    public NonEmptyList<A> reverse() {
        PList<A> pl = this.toPList().reverse();
        return new NonEmptyList<A>(pl.head(), pl.tail());
    }

    public NonEmptyList<A> sort(Comparator<A> comparator) {
        PList<A> pl = this.toPList().sort(comparator);
        return new NonEmptyList<A>(pl.head(), pl.tail());
    }

    public int size() {
        return this.tail.size() + 1;
    }

    public PList<A> toPList() {
        return this.all;
    }

    public NonEmptyList<Pair<A, Integer>> zipWithIndex() {
        PList<Pair<A, Integer>> pl = this.toPList().zipWithIndex();
        return new NonEmptyList<Pair<A, Integer>>(pl.head(), pl.tail());
    }

    @Override
    public A apply(int value) {
        return value == 0 ? this.head : this.tail.apply(value - 1);
    }

    @Override
    public Iterator<A> iterator() {
        return this.toPList().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonEmptyList that = (NonEmptyList)o;
        return Objects.equals(this.head, that.head) && Objects.equals(this.tail, that.tail);
    }

    public int hashCode() {
        return Objects.hash(this.head, this.tail);
    }

    public String toString() {
        return this.toPList().toString();
    }
}

