/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.annotations.PojoBuilder;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.OptionalFieldRelation;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import java.util.Optional;

@PojoBuilder
public final class Constructor {
    private final Name name;
    private final PList<Argument> arguments;

    public Optional<PList<FieldArgument>> matchFields(PList<PojoField> fields) {
        if (fields.size() != this.arguments.size()) {
            return Optional.empty();
        }
        PList fieldArguments = fields.zip(this.arguments).flatMapOptional(p -> {
            Argument argument = (Argument)p.second();
            PojoField field = (PojoField)p.first();
            Optional<OptionalFieldRelation> optionalFieldRelation = argument.getRelationFromField(field);
            return optionalFieldRelation.map(relation -> new FieldArgument(field, argument, (OptionalFieldRelation)((Object)((Object)relation))));
        });
        return Optional.of(fieldArguments).filter(f -> f.size() == this.arguments.size());
    }

    public Constructor(Name name, PList<Argument> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public Name getName() {
        return this.name;
    }

    public PList<Argument> getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Constructor)) {
            return false;
        }
        Constructor other = (Constructor)o;
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        PList<Argument> this$arguments = this.getArguments();
        PList<Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        PList<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "Constructor(name=" + this.getName() + ", arguments=" + this.getArguments() + ")";
    }
}

