/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import java.util.Optional;

public final class PojoBuilder {
    private PojoBuilder() {
    }

    public static Builder0 create() {
        return new Builder0(new Builder());
    }

    public static Builder0 pojoBuilder() {
        return PojoBuilder.create();
    }

    public static final class Builder0 {
        private final Builder builder;

        private Builder0(Builder builder) {
            this.builder = builder;
        }

        public Builder1 name(Name name) {
            return new Builder1(this.builder.name(name));
        }
    }

    public static final class Builder {
        private Name name;
        private PackageName pkg;
        private PList<PojoField> fields;
        private PList<Constructor> constructors;
        private PList<Generic> generics;
        private PList<FieldBuilder> fieldBuilders;
        private BuildMethod buildMethod;

        private Builder() {
        }

        private Builder name(Name name) {
            this.name = name;
            return this;
        }

        private Builder pkg(PackageName pkg) {
            this.pkg = pkg;
            return this;
        }

        private Builder fields(PList<PojoField> fields) {
            this.fields = fields;
            return this;
        }

        private Builder constructors(PList<Constructor> constructors) {
            this.constructors = constructors;
            return this;
        }

        private Builder generics(PList<Generic> generics) {
            this.generics = generics;
            return this;
        }

        private Builder fieldBuilders(PList<FieldBuilder> fieldBuilders) {
            this.fieldBuilders = fieldBuilders;
            return this;
        }

        public Builder buildMethod(BuildMethod buildMethod) {
            this.buildMethod = buildMethod;
            return this;
        }

        public Builder buildMethod(Optional<BuildMethod> buildMethod) {
            this.buildMethod = buildMethod.orElse(null);
            return this;
        }

        public Pojo build() {
            Pojo instance = new Pojo(this.name, this.pkg, this.fields, this.constructors, this.generics, this.fieldBuilders, Optional.ofNullable(this.buildMethod));
            return instance;
        }
    }

    public static final class OptBuilder1 {
        private final Builder builder;

        private OptBuilder1(Builder builder) {
            this.builder = builder;
        }

        public Pojo build() {
            return this.builder.build();
        }
    }

    public static final class OptBuilder0 {
        private final Builder builder;

        private OptBuilder0(Builder builder) {
            this.builder = builder;
        }

        public OptBuilder1 buildMethod(BuildMethod buildMethod) {
            return new OptBuilder1(this.builder.buildMethod(buildMethod));
        }

        public OptBuilder1 buildMethod(Optional<BuildMethod> buildMethod) {
            return new OptBuilder1(this.builder.buildMethod(buildMethod));
        }
    }

    public static final class Builder6 {
        private final Builder builder;

        private Builder6(Builder builder) {
            this.builder = builder;
        }

        public OptBuilder0 andAllOptionals() {
            return new OptBuilder0(this.builder);
        }

        public Builder andOptionals() {
            return this.builder;
        }

        public Pojo build() {
            return this.builder.build();
        }
    }

    public static final class Builder5 {
        private final Builder builder;

        private Builder5(Builder builder) {
            this.builder = builder;
        }

        public Builder6 fieldBuilders(PList<FieldBuilder> fieldBuilders) {
            return new Builder6(this.builder.fieldBuilders(fieldBuilders));
        }
    }

    public static final class Builder4 {
        private final Builder builder;

        private Builder4(Builder builder) {
            this.builder = builder;
        }

        public Builder5 generics(PList<Generic> generics) {
            return new Builder5(this.builder.generics(generics));
        }
    }

    public static final class Builder3 {
        private final Builder builder;

        private Builder3(Builder builder) {
            this.builder = builder;
        }

        public Builder4 constructors(PList<Constructor> constructors) {
            return new Builder4(this.builder.constructors(constructors));
        }
    }

    public static final class Builder2 {
        private final Builder builder;

        private Builder2(Builder builder) {
            this.builder = builder;
        }

        public Builder3 fields(PList<PojoField> fields) {
            return new Builder3(this.builder.fields(fields));
        }
    }

    public static final class Builder1 {
        private final Builder builder;

        private Builder1(Builder builder) {
            this.builder = builder;
        }

        public Builder2 pkg(PackageName pkg) {
            return new Builder2(this.builder.pkg(pkg));
        }
    }
}

