/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.NonEmptyList;
import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.Functions;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilderMethod;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilderMethodBuilder;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.generator.model.type.Types;
import io.github.muehmar.pojobuilder.processor.ArgumentMapper;
import io.github.muehmar.pojobuilder.processor.TypeMirrorMapper;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class FieldBuilderProcessor {
    private FieldBuilderProcessor() {
    }

    public static PList<FieldBuilder> process(TypeElement element) {
        Map<String, NonEmptyList<ElementAndAnnotation>> elementAndAnnotationByFieldName = PList.fromIter(element.getEnclosedElements()).flatMapOptional(FieldBuilderProcessor::getAnnotatedElements).groupBy(elementAndAnnotation -> elementAndAnnotation.getFieldBuilder().fieldName());
        return elementAndAnnotationByFieldName.values().stream().collect(PList.collector()).flatMapOptional(FieldBuilderProcessor::processElementsForSameField);
    }

    public static Optional<FieldBuilder> processElementsForSameField(NonEmptyList<ElementAndAnnotation> elementAndAnnotations) {
        PList singleMethodMethods = elementAndAnnotations.toPList().flatMapOptional(FieldBuilderProcessor::processMethod);
        PList classMethods = elementAndAnnotations.toPList().flatMap(FieldBuilderProcessor::processClass);
        return NonEmptyList.fromIter(singleMethodMethods.concat(classMethods)).map(methods -> {
            boolean disableDefaultMethods = FieldBuilderProcessor.extractDisableDefaultMethods(elementAndAnnotations);
            return new FieldBuilder(disableDefaultMethods, (NonEmptyList<FieldBuilderMethod>)methods);
        });
    }

    public static boolean extractDisableDefaultMethods(NonEmptyList<ElementAndAnnotation> elementAndAnnotations) {
        boolean allFlagsReducedWithOr;
        boolean allFlagsReducedWithAnd = elementAndAnnotations.map(ElementAndAnnotation::isDisableDefaultMethods).reduce(Boolean::logicalAnd);
        if (allFlagsReducedWithAnd == (allFlagsReducedWithOr = elementAndAnnotations.map(ElementAndAnnotation::isDisableDefaultMethods).reduce(Boolean::logicalOr).booleanValue())) {
            return allFlagsReducedWithAnd;
        }
        return (Boolean)FieldBuilderProcessor.throwDisableDefaultMethodsMismatch(elementAndAnnotations.head().getFieldBuilder().fieldName());
    }

    private static PList<FieldBuilderMethod> processClass(ElementAndAnnotation elementAndAnnotation) {
        Element element = elementAndAnnotation.getElement();
        if (Booleans.not(element.getKind().isClass())) {
            return PList.empty();
        }
        Name innerClassName = Name.fromString(element.getSimpleName().toString());
        return PList.fromIter(elementAndAnnotation.element.getEnclosedElements()).filter(e -> e.getKind().equals((Object)ElementKind.METHOD)).map(ExecutableElement.class::cast).map(method -> FieldBuilderProcessor.fromMethod(method, elementAndAnnotation.fieldBuilder, innerClassName));
    }

    private static Optional<FieldBuilderMethod> processMethod(ElementAndAnnotation elementAndAnnotation) {
        return Optional.of(elementAndAnnotation.getElement()).filter(e -> e.getKind().equals((Object)ElementKind.METHOD)).map(ExecutableElement.class::cast).map(method -> FieldBuilderProcessor.fromMethod(method, elementAndAnnotation.getFieldBuilder()));
    }

    private static FieldBuilderMethod fromMethod(ExecutableElement method, io.github.muehmar.pojobuilder.annotations.FieldBuilder fieldBuilder) {
        return FieldBuilderProcessor.fromMethod(method, fieldBuilder, Optional.empty());
    }

    private static FieldBuilderMethod fromMethod(ExecutableElement method, io.github.muehmar.pojobuilder.annotations.FieldBuilder fieldBuilder, Name innerClassName) {
        return FieldBuilderProcessor.fromMethod(method, fieldBuilder, Optional.of(innerClassName));
    }

    private static FieldBuilderMethod fromMethod(ExecutableElement method, io.github.muehmar.pojobuilder.annotations.FieldBuilder fieldBuilder, Optional<Name> innerClassName) {
        if (Booleans.not(method.getModifiers().contains((Object)Modifier.STATIC))) {
            FieldBuilderProcessor.throwMethodNotStaticException(method);
        }
        Type returnType = TypeMirrorMapper.map(method.getReturnType());
        PList<Argument> arguments = FieldBuilderProcessor.extractArgumentsFromMethod(method);
        return FieldBuilderMethodBuilder.create().fieldName(Name.fromString(fieldBuilder.fieldName())).methodName(Name.fromString(method.getSimpleName().toString())).returnType(returnType).arguments(arguments).andAllOptionals().innerClassName(innerClassName).build();
    }

    private static PList<Argument> extractArgumentsFromMethod(ExecutableElement method) {
        PList<Argument> arguments = PList.fromIter(method.getParameters()).map(ArgumentMapper::toArgument);
        if (method.isVarArgs()) {
            UnaryOperator mapToVarargs = arg -> arg.getType().onArrayType(arrayType -> arg.withType(Types.varargs(arrayType.getItemType()))).orElse((Argument)arg);
            return arguments.reverse().zipWithIndex().map(Functions.mapFirst(mapToVarargs));
        }
        return arguments;
    }

    private static void throwMethodNotStaticException(ExecutableElement method) {
        String message = String.format("Method %s is not static but is annotated with @FieldBuilder. A method annotated with @FieldBuilder must be static.", method.getSimpleName());
        throw new IllegalArgumentException(message);
    }

    private static <T> T throwDisableDefaultMethodsMismatch(String fieldName) {
        String message = String.format("Multiple @FieldBuilder annotations found for the field %s, but the flag 'disableDefaultMethods' is enable and disabled at the same time. Consider using a static class for declaring multiple methods or disable or enable the flags in all annotations for the same field.", fieldName);
        throw new IllegalArgumentException(message);
    }

    private static PojoBuilderException noMethodsFoundException(String fieldName) {
        String message = String.format("", fieldName);
        throw new IllegalArgumentException(message);
    }

    private static Optional<ElementAndAnnotation> getAnnotatedElements(Element element) {
        return Optional.ofNullable(element.getAnnotation(io.github.muehmar.pojobuilder.annotations.FieldBuilder.class)).map(annotation -> new ElementAndAnnotation(element, (io.github.muehmar.pojobuilder.annotations.FieldBuilder)annotation));
    }

    private static class ElementAndAnnotation {
        private final Element element;
        private final io.github.muehmar.pojobuilder.annotations.FieldBuilder fieldBuilder;

        public ElementAndAnnotation(Element element, io.github.muehmar.pojobuilder.annotations.FieldBuilder fieldBuilder) {
            this.element = element;
            this.fieldBuilder = fieldBuilder;
        }

        public Element getElement() {
            return this.element;
        }

        public io.github.muehmar.pojobuilder.annotations.FieldBuilder getFieldBuilder() {
            return this.fieldBuilder;
        }

        public boolean isDisableDefaultMethods() {
            return this.fieldBuilder.disableDefaultMethods();
        }
    }
}

