/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.ClassnameParser;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.generator.model.type.Types;
import io.github.muehmar.pojobuilder.generator.model.type.WildcardType;
import java.util.function.Function;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class TypeMirrorMapper {
    private static final PList<Mapper> MAPPER_MAP = TypeMirrorMapper.createMapperMap();

    private TypeMirrorMapper() {
    }

    public static Type map(TypeMirror typeMirror) {
        return MAPPER_MAP.find(mapper -> mapper.getTypeKind().equals((Object)typeMirror.getKind())).map(mapper -> mapper.apply(typeMirror)).orElseThrow(() -> new PojoBuilderException("TypeKind " + (Object)((Object)typeMirror.getKind()) + " not supported for TypeMirror " + typeMirror));
    }

    private static PList<Mapper> createMapperMap() {
        return PList.of(TypeMirrorMapper.declaredTypeMapper(), TypeMirrorMapper.arrayTypeMapper(), TypeMirrorMapper.typeVariableMapper(), Mapper.forFixMapping(TypeKind.BOOLEAN, Types.primitiveBoolean()), Mapper.forFixMapping(TypeKind.CHAR, Types.primitiveChar()), Mapper.forFixMapping(TypeKind.INT, Types.primitiveInt()), Mapper.forFixMapping(TypeKind.FLOAT, Types.primitiveFloat()), Mapper.forFixMapping(TypeKind.DOUBLE, Types.primitiveDouble()), Mapper.forFixMapping(TypeKind.LONG, Types.primitiveLong()), Mapper.forFixMapping(TypeKind.SHORT, Types.primitiveShort()), Mapper.forFixMapping(TypeKind.BYTE, Types.primitiveByte()), Mapper.forFixMapping(TypeKind.VOID, Types.voidType()), Mapper.forFixMapping(TypeKind.WILDCARD, Type.fromSpecificType(WildcardType.create())));
    }

    private static Mapper declaredTypeMapper() {
        return Mapper.forKindAndClass(TypeKind.DECLARED, DeclaredType.class, declaredType -> {
            ClassnameParser.NameAndPackage nameAndPackage = ClassnameParser.parseThrowing(declaredType.toString());
            PList<Type> typeParameters = PList.fromIter(declaredType.getTypeArguments()).map(TypeMirrorMapper::map);
            return Types.declaredType(nameAndPackage.getClassname(), nameAndPackage.getPkg(), typeParameters);
        });
    }

    private static Mapper arrayTypeMapper() {
        return Mapper.forKindAndClass(TypeKind.ARRAY, ArrayType.class, arrayType -> Types.array(TypeMirrorMapper.map(arrayType.getComponentType())));
    }

    private static Mapper typeVariableMapper() {
        return Mapper.forKindAndClass(TypeKind.TYPEVAR, TypeVariable.class, typeVariable -> Types.typeVariable(Name.fromString(typeVariable.toString())));
    }

    private static class Mapper {
        private final TypeKind typeKind;
        private final Function<TypeMirror, Type> f;

        public Mapper(TypeKind typeKind, Function<TypeMirror, Type> f) {
            this.typeKind = typeKind;
            this.f = f;
        }

        public static Mapper forFixMapping(TypeKind typeKind, Type type) {
            return new Mapper(typeKind, ignore -> type);
        }

        public static <T extends TypeMirror> Mapper forKindAndClass(TypeKind typeKind, Class<T> clazz, Function<T, Type> f) {
            return new Mapper(typeKind, typeMirror -> {
                try {
                    TypeMirror casted = (TypeMirror)clazz.cast(typeMirror);
                    return (Type)f.apply(casted);
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("TypeMirror of kind " + (Object)((Object)typeKind) + " expected to be in instance of " + clazz.getName() + "but is " + typeMirror.getClass().getName());
                }
            });
        }

        public TypeKind getTypeKind() {
            return this.typeKind;
        }

        public Type apply(TypeMirror typeMirror) {
            return this.f.apply(typeMirror);
        }
    }
}

