/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.instantiation;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.generator.model.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.MatchingConstructor;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;

public class ConstructorCallGenerator {
    private ConstructorCallGenerator() {
    }

    public static Generator<Pojo, PojoSettings> constructorCallGenerator() {
        return Generator.emptyGen().append(ConstructorCallGenerator.constructorCallForFields(), pojo -> {
            MatchingConstructor matchingConstructor = pojo.getMatchingConstructorOrThrow();
            PList<FieldArgument> fieldArguments = matchingConstructor.getFieldArguments();
            return new ConstructorCall((Pojo)pojo, fieldArguments, matchingConstructor);
        }).filter(pojo -> Booleans.not(pojo.getFactoryMethod().isPresent()));
    }

    private static Generator<ConstructorCall, PojoSettings> constructorCallForFields() {
        return Generator.emptyGen().append((cc, s, w) -> w.print("new %s(", new Object[]{cc.getPojo().getPojoNameWithTypeVariables()})).appendList(ConstructorCallGenerator.singleFieldSameType().append(ConstructorCallGenerator.singleFieldWrapIntoOptional()), ConstructorCall::getFields, (a, s, w) -> w.print(", ")).append((cc, s, w) -> w.println(");"));
    }

    private static Generator<FieldArgument, PojoSettings> singleFieldSameType() {
        return Generator.emptyGen().append((f, s, w) -> w.print("%s", new Object[]{f.getField().getName()})).filter(fieldArgument -> fieldArgument.getRelation().isSameType());
    }

    private static Generator<FieldArgument, PojoSettings> singleFieldWrapIntoOptional() {
        return Generator.emptyGen().append((f, s, w) -> w.print("Optional.ofNullable(%s)", new Object[]{f.getField().getName()})).append(w -> w.ref("java.util.Optional")).filter(fieldArgument -> fieldArgument.getRelation().isWrapIntoOptional());
    }

    private static final class ConstructorCall {
        private final Pojo pojo;
        private final PList<FieldArgument> fields;
        private final MatchingConstructor constructor;

        public ConstructorCall(Pojo pojo, PList<FieldArgument> fields, MatchingConstructor constructor) {
            this.pojo = pojo;
            this.fields = fields;
            this.constructor = constructor;
        }

        public Pojo getPojo() {
            return this.pojo;
        }

        public PList<FieldArgument> getFields() {
            return this.fields;
        }

        public MatchingConstructor getConstructor() {
            return this.constructor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstructorCall)) {
                return false;
            }
            ConstructorCall other = (ConstructorCall)o;
            Pojo this$pojo = this.getPojo();
            Pojo other$pojo = other.getPojo();
            if (this$pojo == null ? other$pojo != null : !((Object)this$pojo).equals(other$pojo)) {
                return false;
            }
            PList<FieldArgument> this$fields = this.getFields();
            PList<FieldArgument> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            MatchingConstructor this$constructor = this.getConstructor();
            MatchingConstructor other$constructor = other.getConstructor();
            return !(this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pojo $pojo = this.getPojo();
            result = result * 59 + ($pojo == null ? 43 : ((Object)$pojo).hashCode());
            PList<FieldArgument> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            MatchingConstructor $constructor = this.getConstructor();
            result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
            return result;
        }

        public String toString() {
            return "ConstructorCallGenerator.ConstructorCall(pojo=" + this.getPojo() + ", fields=" + this.getFields() + ", constructor=" + this.getConstructor() + ")";
        }
    }
}

