/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.instantiation;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.pojobuilder.generator.model.FactoryMethod;
import io.github.muehmar.pojobuilder.generator.model.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import java.util.Optional;

public class FactoryMethodCallGenerator {
    private FactoryMethodCallGenerator() {
    }

    public static Generator<Pojo, PojoSettings> factoryMethodCallGenerator() {
        return Generator.emptyGen().appendOptional(FactoryMethodCallGenerator.factoryCallForFields(), FactoryMethodCallGenerator::createFactoryMethodCall);
    }

    private static Optional<FactoryMethodCall> createFactoryMethodCall(Pojo pojo) {
        return pojo.getFactoryMethod().flatMap(factoryMethod -> pojo.matchArguments(factoryMethod.getArguments()).map(fieldArguments -> new FactoryMethodCall(pojo, (FactoryMethod)factoryMethod, (PList<FieldArgument>)fieldArguments)));
    }

    private static Generator<FactoryMethodCall, PojoSettings> factoryCallForFields() {
        return Generator.emptyGen().append((fmc, s, w) -> w.print("%s(", new Object[]{fmc.scopedMethodName()})).appendList(FactoryMethodCallGenerator.singleFieldSameType().append(FactoryMethodCallGenerator.singleFieldWrapIntoOptional()), FactoryMethodCall::getFields, (a, s, w) -> w.print(", ")).append(Generator.constant((String)");", (Object[])new Object[0]));
    }

    private static Generator<FieldArgument, PojoSettings> singleFieldSameType() {
        return Generator.emptyGen().append((f, s, w) -> w.print("%s", new Object[]{f.getField().getName()})).filter(fieldArgument -> fieldArgument.getRelation().isSameType());
    }

    private static Generator<FieldArgument, PojoSettings> singleFieldWrapIntoOptional() {
        return Generator.emptyGen().append((f, s, w) -> w.print("Optional.ofNullable(%s)", new Object[]{f.getField().getName()})).append(w -> w.ref("java.util.Optional")).filter(fieldArgument -> fieldArgument.getRelation().isWrapIntoOptional());
    }

    private static final class FactoryMethodCall {
        private final Pojo pojo;
        private final FactoryMethod factoryMethod;
        private final PList<FieldArgument> fields;

        public String scopedMethodName() {
            return String.format("%s.%s", this.factoryMethod.getOwnerClassname().asName(), this.factoryMethod.getMethodName());
        }

        public FactoryMethodCall(Pojo pojo, FactoryMethod factoryMethod, PList<FieldArgument> fields) {
            this.pojo = pojo;
            this.factoryMethod = factoryMethod;
            this.fields = fields;
        }

        public Pojo getPojo() {
            return this.pojo;
        }

        public FactoryMethod getFactoryMethod() {
            return this.factoryMethod;
        }

        public PList<FieldArgument> getFields() {
            return this.fields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FactoryMethodCall)) {
                return false;
            }
            FactoryMethodCall other = (FactoryMethodCall)o;
            Pojo this$pojo = this.getPojo();
            Pojo other$pojo = other.getPojo();
            if (this$pojo == null ? other$pojo != null : !((Object)this$pojo).equals(other$pojo)) {
                return false;
            }
            FactoryMethod this$factoryMethod = this.getFactoryMethod();
            FactoryMethod other$factoryMethod = other.getFactoryMethod();
            if (this$factoryMethod == null ? other$factoryMethod != null : !((Object)this$factoryMethod).equals(other$factoryMethod)) {
                return false;
            }
            PList<FieldArgument> this$fields = this.getFields();
            PList<FieldArgument> other$fields = other.getFields();
            return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pojo $pojo = this.getPojo();
            result = result * 59 + ($pojo == null ? 43 : ((Object)$pojo).hashCode());
            FactoryMethod $factoryMethod = this.getFactoryMethod();
            result = result * 59 + ($factoryMethod == null ? 43 : ((Object)$factoryMethod).hashCode());
            PList<FieldArgument> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            return result;
        }

        public String toString() {
            return "FactoryMethodCallGenerator.FactoryMethodCall(pojo=" + this.getPojo() + ", factoryMethod=" + this.getFactoryMethod() + ", fields=" + this.getFields() + ")";
        }
    }
}

