/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import java.util.function.UnaryOperator;

public class Name {
    private final String value;

    private Name(String val) {
        if (val == null || val.trim().isEmpty()) {
            throw new IllegalArgumentException("A name must not be null or empty");
        }
        this.value = val;
    }

    public static Name fromString(String val) {
        return new Name(val);
    }

    public static Name concat(Name n1, Name n2) {
        return n1.append(n2);
    }

    public String asString() {
        return this.value;
    }

    public Name map(UnaryOperator<String> f) {
        return Name.fromString((String)f.apply(this.value));
    }

    public Name append(String append) {
        return new Name(this.value + append);
    }

    public Name append(Name append) {
        return new Name(this.value + append.value);
    }

    public Name prefix(String prefix) {
        return new Name(prefix + this.value);
    }

    public boolean equalsIgnoreCase(Name other) {
        return this.value.equalsIgnoreCase(other.value);
    }

    public Name toPascalCase() {
        return this.map(n -> n.substring(0, 1).toUpperCase() + n.substring(1));
    }

    public Name startLowerCase() {
        return this.map(n -> n.substring(0, 1).toLowerCase() + n.substring(1));
    }

    public Name startUpperCase() {
        return this.map(n -> n.substring(0, 1).toUpperCase() + n.substring(1));
    }

    public Name javaBeansName() {
        if (this.value.length() >= 2 && this.value.substring(1, 2).toUpperCase().equals(this.value.substring(1, 2))) {
            return this;
        }
        return this.toPascalCase();
    }

    public boolean startsWith(String str) {
        return this.value.startsWith(str);
    }

    public Name replace(Name oldName, Name newName) {
        return this.map(s -> s.replace(oldName.asString(), newName.asString()));
    }

    public int length() {
        return this.value.length();
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name other = (Name)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Name;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

