/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Strings;
import io.github.muehmar.pojobuilder.annotations.PojoBuilder;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.FactoryMethod;
import io.github.muehmar.pojobuilder.generator.model.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.MatchingConstructor;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.PojoAndField;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.type.QualifiedClassname;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import java.util.Optional;

@PojoBuilder
public final class Pojo {
    private final QualifiedClassname pojoClassname;
    private final Name pojoNameWithTypeVariables;
    private final PackageName pkg;
    private final PList<PojoField> fields;
    private final PList<Constructor> constructors;
    private final Optional<FactoryMethod> factoryMethod;
    private final PList<Generic> generics;
    private final PList<FieldBuilder> fieldBuilders;
    private final Optional<BuildMethod> buildMethod;

    public PackageName getPackage() {
        return this.pkg;
    }

    public PList<PojoAndField> getPojoAndFields() {
        return this.fields.map(f -> new PojoAndField(this, (PojoField)f));
    }

    public PList<Name> getGenericImports() {
        return this.generics.flatMap(Generic::getUpperBounds).flatMap(Type::getImports);
    }

    public String getDiamond() {
        return this.generics.nonEmpty() ? "<>" : "";
    }

    public String getBoundedTypeVariablesFormatted() {
        String typeVariableDeclaration = this.generics.map(Generic::getTypeDeclaration).map(Name::asString).mkString(", ");
        return Strings.surroundIfNotEmpty("<", typeVariableDeclaration, ">");
    }

    public String getTypeVariablesFormatted() {
        return Strings.surroundIfNotEmpty("<", this.generics.map(Generic::getTypeVariable).mkString(", "), ">");
    }

    public Name getPojoNameWithTypeVariables() {
        return this.pojoNameWithTypeVariables;
    }

    public Optional<MatchingConstructor> findMatchingConstructor() {
        return this.constructors.flatMapOptional(c -> this.matchArguments(c.getArguments()).map(f -> new MatchingConstructor((Constructor)c, (PList<FieldArgument>)f))).headOption();
    }

    public MatchingConstructor getMatchingConstructorOrThrow() {
        return this.findMatchingConstructor().orElseThrow(() -> new PojoBuilderException(this.noMatchingConstructorMessage()));
    }

    public Optional<PList<FieldArgument>> matchArguments(PList<Argument> arguments) {
        if (this.fields.size() != arguments.size()) {
            return Optional.empty();
        }
        PList fieldArguments = this.fields.zip(arguments).flatMapOptional(p -> FieldArgument.fromFieldAndArgument((PojoField)p.first(), (Argument)p.second()));
        return Optional.of(fieldArguments).filter(f -> f.size() == arguments.size());
    }

    private String noMatchingConstructorMessage() {
        return String.format("No matching constructor found for class/record %s. A constructor should have all the fields as arguments in the order of declaration and matching type, where the actual type of a non-required field can be wrapped into an java.util.Optional. Furthermoreit should be accessible from within the same package, i.e. at least package-private. If a field isinstantiated in the constructor and not part of the arguments, you can annotate it with @Ignore.", this.getPojoClassname());
    }

    public Pojo(QualifiedClassname pojoClassname, Name pojoNameWithTypeVariables, PackageName pkg, PList<PojoField> fields, PList<Constructor> constructors, Optional<FactoryMethod> factoryMethod, PList<Generic> generics, PList<FieldBuilder> fieldBuilders, Optional<BuildMethod> buildMethod) {
        this.pojoClassname = pojoClassname;
        this.pojoNameWithTypeVariables = pojoNameWithTypeVariables;
        this.pkg = pkg;
        this.fields = fields;
        this.constructors = constructors;
        this.factoryMethod = factoryMethod;
        this.generics = generics;
        this.fieldBuilders = fieldBuilders;
        this.buildMethod = buildMethod;
    }

    public QualifiedClassname getPojoClassname() {
        return this.pojoClassname;
    }

    public PackageName getPkg() {
        return this.pkg;
    }

    public PList<PojoField> getFields() {
        return this.fields;
    }

    public PList<Constructor> getConstructors() {
        return this.constructors;
    }

    public Optional<FactoryMethod> getFactoryMethod() {
        return this.factoryMethod;
    }

    public PList<Generic> getGenerics() {
        return this.generics;
    }

    public PList<FieldBuilder> getFieldBuilders() {
        return this.fieldBuilders;
    }

    public Optional<BuildMethod> getBuildMethod() {
        return this.buildMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pojo)) {
            return false;
        }
        Pojo other = (Pojo)o;
        QualifiedClassname this$pojoClassname = this.getPojoClassname();
        QualifiedClassname other$pojoClassname = other.getPojoClassname();
        if (this$pojoClassname == null ? other$pojoClassname != null : !((Object)this$pojoClassname).equals(other$pojoClassname)) {
            return false;
        }
        Name this$pojoNameWithTypeVariables = this.getPojoNameWithTypeVariables();
        Name other$pojoNameWithTypeVariables = other.getPojoNameWithTypeVariables();
        if (this$pojoNameWithTypeVariables == null ? other$pojoNameWithTypeVariables != null : !((Object)this$pojoNameWithTypeVariables).equals(other$pojoNameWithTypeVariables)) {
            return false;
        }
        PackageName this$pkg = this.getPkg();
        PackageName other$pkg = other.getPkg();
        if (this$pkg == null ? other$pkg != null : !((Object)this$pkg).equals(other$pkg)) {
            return false;
        }
        PList<PojoField> this$fields = this.getFields();
        PList<PojoField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        PList<Constructor> this$constructors = this.getConstructors();
        PList<Constructor> other$constructors = other.getConstructors();
        if (this$constructors == null ? other$constructors != null : !((Object)this$constructors).equals(other$constructors)) {
            return false;
        }
        Optional<FactoryMethod> this$factoryMethod = this.getFactoryMethod();
        Optional<FactoryMethod> other$factoryMethod = other.getFactoryMethod();
        if (this$factoryMethod == null ? other$factoryMethod != null : !((Object)this$factoryMethod).equals(other$factoryMethod)) {
            return false;
        }
        PList<Generic> this$generics = this.getGenerics();
        PList<Generic> other$generics = other.getGenerics();
        if (this$generics == null ? other$generics != null : !((Object)this$generics).equals(other$generics)) {
            return false;
        }
        PList<FieldBuilder> this$fieldBuilders = this.getFieldBuilders();
        PList<FieldBuilder> other$fieldBuilders = other.getFieldBuilders();
        if (this$fieldBuilders == null ? other$fieldBuilders != null : !((Object)this$fieldBuilders).equals(other$fieldBuilders)) {
            return false;
        }
        Optional<BuildMethod> this$buildMethod = this.getBuildMethod();
        Optional<BuildMethod> other$buildMethod = other.getBuildMethod();
        return !(this$buildMethod == null ? other$buildMethod != null : !((Object)this$buildMethod).equals(other$buildMethod));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QualifiedClassname $pojoClassname = this.getPojoClassname();
        result = result * 59 + ($pojoClassname == null ? 43 : ((Object)$pojoClassname).hashCode());
        Name $pojoNameWithTypeVariables = this.getPojoNameWithTypeVariables();
        result = result * 59 + ($pojoNameWithTypeVariables == null ? 43 : ((Object)$pojoNameWithTypeVariables).hashCode());
        PackageName $pkg = this.getPkg();
        result = result * 59 + ($pkg == null ? 43 : ((Object)$pkg).hashCode());
        PList<PojoField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        PList<Constructor> $constructors = this.getConstructors();
        result = result * 59 + ($constructors == null ? 43 : ((Object)$constructors).hashCode());
        Optional<FactoryMethod> $factoryMethod = this.getFactoryMethod();
        result = result * 59 + ($factoryMethod == null ? 43 : ((Object)$factoryMethod).hashCode());
        PList<Generic> $generics = this.getGenerics();
        result = result * 59 + ($generics == null ? 43 : ((Object)$generics).hashCode());
        PList<FieldBuilder> $fieldBuilders = this.getFieldBuilders();
        result = result * 59 + ($fieldBuilders == null ? 43 : ((Object)$fieldBuilders).hashCode());
        Optional<BuildMethod> $buildMethod = this.getBuildMethod();
        result = result * 59 + ($buildMethod == null ? 43 : ((Object)$buildMethod).hashCode());
        return result;
    }

    public String toString() {
        return "Pojo(pojoClassname=" + this.getPojoClassname() + ", pojoNameWithTypeVariables=" + this.getPojoNameWithTypeVariables() + ", pkg=" + this.getPkg() + ", fields=" + this.getFields() + ", constructors=" + this.getConstructors() + ", factoryMethod=" + this.getFactoryMethod() + ", generics=" + this.getGenerics() + ", fieldBuilders=" + this.getFieldBuilders() + ", buildMethod=" + this.getBuildMethod() + ")";
    }

    public Pojo withPojoClassname(QualifiedClassname pojoClassname) {
        return this.pojoClassname == pojoClassname ? this : new Pojo(pojoClassname, this.pojoNameWithTypeVariables, this.pkg, this.fields, this.constructors, this.factoryMethod, this.generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withPojoNameWithTypeVariables(Name pojoNameWithTypeVariables) {
        return this.pojoNameWithTypeVariables == pojoNameWithTypeVariables ? this : new Pojo(this.pojoClassname, pojoNameWithTypeVariables, this.pkg, this.fields, this.constructors, this.factoryMethod, this.generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withPkg(PackageName pkg) {
        return this.pkg == pkg ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, pkg, this.fields, this.constructors, this.factoryMethod, this.generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withFields(PList<PojoField> fields) {
        return this.fields == fields ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, this.pkg, fields, this.constructors, this.factoryMethod, this.generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withConstructors(PList<Constructor> constructors) {
        return this.constructors == constructors ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, this.pkg, this.fields, constructors, this.factoryMethod, this.generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withFactoryMethod(Optional<FactoryMethod> factoryMethod) {
        return this.factoryMethod == factoryMethod ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, this.pkg, this.fields, this.constructors, factoryMethod, this.generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withGenerics(PList<Generic> generics) {
        return this.generics == generics ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, this.pkg, this.fields, this.constructors, this.factoryMethod, generics, this.fieldBuilders, this.buildMethod);
    }

    public Pojo withFieldBuilders(PList<FieldBuilder> fieldBuilders) {
        return this.fieldBuilders == fieldBuilders ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, this.pkg, this.fields, this.constructors, this.factoryMethod, this.generics, fieldBuilders, this.buildMethod);
    }

    public Pojo withBuildMethod(Optional<BuildMethod> buildMethod) {
        return this.buildMethod == buildMethod ? this : new Pojo(this.pojoClassname, this.pojoNameWithTypeVariables, this.pkg, this.fields, this.constructors, this.factoryMethod, this.generics, this.fieldBuilders, buildMethod);
    }
}

