/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.settings;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.annotations.FullBuilderFieldOrder;
import io.github.muehmar.pojobuilder.annotations.OptionalDetection;
import io.github.muehmar.pojobuilder.annotations.PojoBuilder;
import io.github.muehmar.pojobuilder.generator.model.ClassAccessLevelModifier;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettingsBuilder;
import java.util.Optional;

@PojoBuilder
public final class PojoSettings {
    private static final Name CLASS_NAME_PLACEHOLDER = Name.fromString("{CLASSNAME}");
    public static final Name BUILDER_CLASS_POSTFIX = Name.fromString("Builder");
    private final PList<OptionalDetection> optionalDetections;
    private final Optional<Name> builderName;
    private final Optional<Name> builderSetMethodPrefix;
    private final ClassAccessLevelModifier builderAccessLevel;
    private final boolean standardBuilderEnabled;
    private final boolean fullBuilderEnabled;
    private final FullBuilderFieldOrder fullBuilderFieldOrder;
    private final boolean includeOuterClassName;

    public static PojoSettings defaultSettings() {
        return PojoSettingsBuilder.create().optionalDetections(PList.of(OptionalDetection.OPTIONAL_CLASS, OptionalDetection.NULLABLE_ANNOTATION)).builderAccessLevel(ClassAccessLevelModifier.PUBLIC).standardBuilderEnabled(true).fullBuilderEnabled(true).fullBuilderFieldOrder(FullBuilderFieldOrder.REQUIRED_FIELDS_FIRST).includeOuterClassName(true).andAllOptionals().builderName(Optional.of(CLASS_NAME_PLACEHOLDER.append(BUILDER_CLASS_POSTFIX))).builderSetMethodPrefix(Optional.empty()).build();
    }

    public Name qualifiedBuilderName(Pojo pojo) {
        return pojo.getPackage().qualifiedName(this.builderName(pojo));
    }

    public Name builderName(Pojo pojo) {
        return this.getNameOrAppend(this.builderName, BUILDER_CLASS_POSTFIX, pojo);
    }

    private Name getNameOrAppend(Optional<Name> name, Name postfix, Pojo pojo) {
        return name.map(n -> n.replace(CLASS_NAME_PLACEHOLDER, this.getClassName(pojo))).orElseGet(() -> this.getClassName(pojo).append(postfix));
    }

    private Name getClassName(Pojo pojo) {
        if (this.includeOuterClassName) {
            return pojo.getPojoClassname().getName().map(n -> n.replace(".", ""));
        }
        return pojo.getPojoClassname().getSimpleName();
    }

    public PojoSettings withBuilderNameOpt(Name builderName) {
        return this.withBuilderName(Optional.of(builderName));
    }

    public PojoSettings withBuilderSetMethodPrefixOpt(Name builderSetMethodPrefix) {
        return this.withBuilderSetMethodPrefix(Optional.of(builderSetMethodPrefix));
    }

    public PojoSettings overrideOptionalDetection(Optional<PList<OptionalDetection>> optionalDetections) {
        return optionalDetections.map(this::withOptionalDetections).orElse(this);
    }

    public PojoSettings overrideBuilderName(Optional<Name> builderName) {
        return builderName.map(this::withBuilderNameOpt).orElse(this);
    }

    public PojoSettings overrideBuilderSetMethodPrefix(Optional<Name> builderSetMethodPrefix) {
        return builderSetMethodPrefix.map(ignore -> this.withBuilderSetMethodPrefix(builderSetMethodPrefix)).orElse(this);
    }

    public PojoSettings overrideBuilderAccessLevel(Optional<ClassAccessLevelModifier> classAccessLevelModifier) {
        return classAccessLevelModifier.map(this::withBuilderAccessLevel).orElse(this);
    }

    public PojoSettings overrideEnableStandardBuilder(Optional<Boolean> enableStandardBuilder) {
        return enableStandardBuilder.map(this::withStandardBuilderEnabled).orElse(this);
    }

    public PojoSettings overrideEnableFullBuilder(Optional<Boolean> enableFullBuilder) {
        return enableFullBuilder.map(this::withFullBuilderEnabled).orElse(this);
    }

    public PojoSettings overrideFullBuilderFieldOrder(Optional<FullBuilderFieldOrder> fullBuilderFieldOrder) {
        return fullBuilderFieldOrder.map(this::withFullBuilderFieldOrder).orElse(this);
    }

    public PojoSettings overrideIncludeOuterClassName(Optional<Boolean> includeOuterClassName) {
        return includeOuterClassName.map(this::withIncludeOuterClassName).orElse(this);
    }

    public PojoSettings(PList<OptionalDetection> optionalDetections, Optional<Name> builderName, Optional<Name> builderSetMethodPrefix, ClassAccessLevelModifier builderAccessLevel, boolean standardBuilderEnabled, boolean fullBuilderEnabled, FullBuilderFieldOrder fullBuilderFieldOrder, boolean includeOuterClassName) {
        this.optionalDetections = optionalDetections;
        this.builderName = builderName;
        this.builderSetMethodPrefix = builderSetMethodPrefix;
        this.builderAccessLevel = builderAccessLevel;
        this.standardBuilderEnabled = standardBuilderEnabled;
        this.fullBuilderEnabled = fullBuilderEnabled;
        this.fullBuilderFieldOrder = fullBuilderFieldOrder;
        this.includeOuterClassName = includeOuterClassName;
    }

    public PList<OptionalDetection> getOptionalDetections() {
        return this.optionalDetections;
    }

    public Optional<Name> getBuilderName() {
        return this.builderName;
    }

    public Optional<Name> getBuilderSetMethodPrefix() {
        return this.builderSetMethodPrefix;
    }

    public ClassAccessLevelModifier getBuilderAccessLevel() {
        return this.builderAccessLevel;
    }

    public boolean isStandardBuilderEnabled() {
        return this.standardBuilderEnabled;
    }

    public boolean isFullBuilderEnabled() {
        return this.fullBuilderEnabled;
    }

    public FullBuilderFieldOrder getFullBuilderFieldOrder() {
        return this.fullBuilderFieldOrder;
    }

    public boolean isIncludeOuterClassName() {
        return this.includeOuterClassName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PojoSettings)) {
            return false;
        }
        PojoSettings other = (PojoSettings)o;
        if (this.isStandardBuilderEnabled() != other.isStandardBuilderEnabled()) {
            return false;
        }
        if (this.isFullBuilderEnabled() != other.isFullBuilderEnabled()) {
            return false;
        }
        if (this.isIncludeOuterClassName() != other.isIncludeOuterClassName()) {
            return false;
        }
        PList<OptionalDetection> this$optionalDetections = this.getOptionalDetections();
        PList<OptionalDetection> other$optionalDetections = other.getOptionalDetections();
        if (this$optionalDetections == null ? other$optionalDetections != null : !((Object)this$optionalDetections).equals(other$optionalDetections)) {
            return false;
        }
        Optional<Name> this$builderName = this.getBuilderName();
        Optional<Name> other$builderName = other.getBuilderName();
        if (this$builderName == null ? other$builderName != null : !((Object)this$builderName).equals(other$builderName)) {
            return false;
        }
        Optional<Name> this$builderSetMethodPrefix = this.getBuilderSetMethodPrefix();
        Optional<Name> other$builderSetMethodPrefix = other.getBuilderSetMethodPrefix();
        if (this$builderSetMethodPrefix == null ? other$builderSetMethodPrefix != null : !((Object)this$builderSetMethodPrefix).equals(other$builderSetMethodPrefix)) {
            return false;
        }
        ClassAccessLevelModifier this$builderAccessLevel = this.getBuilderAccessLevel();
        ClassAccessLevelModifier other$builderAccessLevel = other.getBuilderAccessLevel();
        if (this$builderAccessLevel == null ? other$builderAccessLevel != null : !((Object)((Object)this$builderAccessLevel)).equals((Object)other$builderAccessLevel)) {
            return false;
        }
        FullBuilderFieldOrder this$fullBuilderFieldOrder = this.getFullBuilderFieldOrder();
        FullBuilderFieldOrder other$fullBuilderFieldOrder = other.getFullBuilderFieldOrder();
        return !(this$fullBuilderFieldOrder == null ? other$fullBuilderFieldOrder != null : !this$fullBuilderFieldOrder.equals(other$fullBuilderFieldOrder));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStandardBuilderEnabled() ? 79 : 97);
        result = result * 59 + (this.isFullBuilderEnabled() ? 79 : 97);
        result = result * 59 + (this.isIncludeOuterClassName() ? 79 : 97);
        PList<OptionalDetection> $optionalDetections = this.getOptionalDetections();
        result = result * 59 + ($optionalDetections == null ? 43 : ((Object)$optionalDetections).hashCode());
        Optional<Name> $builderName = this.getBuilderName();
        result = result * 59 + ($builderName == null ? 43 : ((Object)$builderName).hashCode());
        Optional<Name> $builderSetMethodPrefix = this.getBuilderSetMethodPrefix();
        result = result * 59 + ($builderSetMethodPrefix == null ? 43 : ((Object)$builderSetMethodPrefix).hashCode());
        ClassAccessLevelModifier $builderAccessLevel = this.getBuilderAccessLevel();
        result = result * 59 + ($builderAccessLevel == null ? 43 : ((Object)((Object)$builderAccessLevel)).hashCode());
        FullBuilderFieldOrder $fullBuilderFieldOrder = this.getFullBuilderFieldOrder();
        result = result * 59 + ($fullBuilderFieldOrder == null ? 43 : $fullBuilderFieldOrder.hashCode());
        return result;
    }

    public String toString() {
        return "PojoSettings(optionalDetections=" + this.getOptionalDetections() + ", builderName=" + this.getBuilderName() + ", builderSetMethodPrefix=" + this.getBuilderSetMethodPrefix() + ", builderAccessLevel=" + (Object)((Object)this.getBuilderAccessLevel()) + ", standardBuilderEnabled=" + this.isStandardBuilderEnabled() + ", fullBuilderEnabled=" + this.isFullBuilderEnabled() + ", fullBuilderFieldOrder=" + this.getFullBuilderFieldOrder() + ", includeOuterClassName=" + this.isIncludeOuterClassName() + ")";
    }

    public PojoSettings withOptionalDetections(PList<OptionalDetection> optionalDetections) {
        return this.optionalDetections == optionalDetections ? this : new PojoSettings(optionalDetections, this.builderName, this.builderSetMethodPrefix, this.builderAccessLevel, this.standardBuilderEnabled, this.fullBuilderEnabled, this.fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withBuilderName(Optional<Name> builderName) {
        return this.builderName == builderName ? this : new PojoSettings(this.optionalDetections, builderName, this.builderSetMethodPrefix, this.builderAccessLevel, this.standardBuilderEnabled, this.fullBuilderEnabled, this.fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withBuilderSetMethodPrefix(Optional<Name> builderSetMethodPrefix) {
        return this.builderSetMethodPrefix == builderSetMethodPrefix ? this : new PojoSettings(this.optionalDetections, this.builderName, builderSetMethodPrefix, this.builderAccessLevel, this.standardBuilderEnabled, this.fullBuilderEnabled, this.fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withBuilderAccessLevel(ClassAccessLevelModifier builderAccessLevel) {
        return this.builderAccessLevel == builderAccessLevel ? this : new PojoSettings(this.optionalDetections, this.builderName, this.builderSetMethodPrefix, builderAccessLevel, this.standardBuilderEnabled, this.fullBuilderEnabled, this.fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withStandardBuilderEnabled(boolean standardBuilderEnabled) {
        return this.standardBuilderEnabled == standardBuilderEnabled ? this : new PojoSettings(this.optionalDetections, this.builderName, this.builderSetMethodPrefix, this.builderAccessLevel, standardBuilderEnabled, this.fullBuilderEnabled, this.fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withFullBuilderEnabled(boolean fullBuilderEnabled) {
        return this.fullBuilderEnabled == fullBuilderEnabled ? this : new PojoSettings(this.optionalDetections, this.builderName, this.builderSetMethodPrefix, this.builderAccessLevel, this.standardBuilderEnabled, fullBuilderEnabled, this.fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withFullBuilderFieldOrder(FullBuilderFieldOrder fullBuilderFieldOrder) {
        return this.fullBuilderFieldOrder == fullBuilderFieldOrder ? this : new PojoSettings(this.optionalDetections, this.builderName, this.builderSetMethodPrefix, this.builderAccessLevel, this.standardBuilderEnabled, this.fullBuilderEnabled, fullBuilderFieldOrder, this.includeOuterClassName);
    }

    public PojoSettings withIncludeOuterClassName(boolean includeOuterClassName) {
        return this.includeOuterClassName == includeOuterClassName ? this : new PojoSettings(this.optionalDetections, this.builderName, this.builderSetMethodPrefix, this.builderAccessLevel, this.standardBuilderEnabled, this.fullBuilderEnabled, this.fullBuilderFieldOrder, includeOuterClassName);
    }
}

