/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.type;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.Name;

public class Classname {
    private final PList<Name> outerClassNames;
    private final Name simpleName;

    private Classname(PList<Name> outerClassNames, Name simpleName) {
        this.outerClassNames = outerClassNames;
        this.simpleName = simpleName;
    }

    public static Classname fromString(String fullClassName) {
        PList<Name> classesReversed = PList.fromArray(fullClassName.split("\\.")).map(Name::fromString).reverse();
        if (classesReversed.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + fullClassName);
        }
        Name className = classesReversed.head();
        return new Classname(classesReversed.drop(1).reverse(), className);
    }

    public Name getTopLevelClass() {
        return this.outerClassNames.headOption().orElse(this.simpleName);
    }

    public Name getSimpleName() {
        return this.simpleName;
    }

    public Name asName() {
        return Name.fromString(this.asString());
    }

    public String asString() {
        return this.outerClassNames.add(this.simpleName).mkString(".");
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Classname)) {
            return false;
        }
        Classname other = (Classname)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PList<Name> this$outerClassNames = this.outerClassNames;
        PList<Name> other$outerClassNames = other.outerClassNames;
        if (this$outerClassNames == null ? other$outerClassNames != null : !((Object)this$outerClassNames).equals(other$outerClassNames)) {
            return false;
        }
        Name this$simpleName = this.getSimpleName();
        Name other$simpleName = other.getSimpleName();
        return !(this$simpleName == null ? other$simpleName != null : !((Object)this$simpleName).equals(other$simpleName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Classname;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PList<Name> $outerClassNames = this.outerClassNames;
        result = result * 59 + ($outerClassNames == null ? 43 : ((Object)$outerClassNames).hashCode());
        Name $simpleName = this.getSimpleName();
        result = result * 59 + ($simpleName == null ? 43 : ((Object)$simpleName).hashCode());
        return result;
    }
}

