/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.NonEmptyList;
import ch.bluecare.commons.data.PList;
import com.google.auto.service.AutoService;
import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.codegenerator.writer.Writer;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.Optionals;
import io.github.muehmar.pojobuilder.Strings;
import io.github.muehmar.pojobuilder.annotations.Ignore;
import io.github.muehmar.pojobuilder.annotations.Nullable;
import io.github.muehmar.pojobuilder.annotations.OptionalDetection;
import io.github.muehmar.pojobuilder.annotations.PojoBuilder;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.PojoBuilderGenerator;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.ClassAccessLevelModifier;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.FactoryMethod;
import io.github.muehmar.pojobuilder.generator.model.FactoryMethodBuilder;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Necessity;
import io.github.muehmar.pojobuilder.generator.model.PackageName;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import io.github.muehmar.pojobuilder.generator.model.type.ClassnameParser;
import io.github.muehmar.pojobuilder.generator.model.type.DeclaredType;
import io.github.muehmar.pojobuilder.generator.model.type.QualifiedClassname;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.processor.AnnotationMemberExtractor;
import io.github.muehmar.pojobuilder.processor.ArgumentMapper;
import io.github.muehmar.pojobuilder.processor.BuildMethodProcessor;
import io.github.muehmar.pojobuilder.processor.ConstructorProcessor;
import io.github.muehmar.pojobuilder.processor.DetectionSettings;
import io.github.muehmar.pojobuilder.processor.FieldBuilderProcessor;
import io.github.muehmar.pojobuilder.processor.TypeMirrorMapper;
import io.github.muehmar.pojobuilder.processor.TypeParameterProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
@AutoService(value={Processor.class})
public class PojoBuilderProcessor
extends AbstractProcessor {
    private static final int MAX_ANNOTATION_PATH_DEPTH = 50;
    private final Optional<BiConsumer<Pojo, PojoSettings>> redirectPojo;

    private PojoBuilderProcessor(Optional<BiConsumer<Pojo, PojoSettings>> redirectPojo) {
        this.redirectPojo = redirectPojo;
    }

    public PojoBuilderProcessor() {
        this(Optional.empty());
    }

    public PojoBuilderProcessor(BiConsumer<Pojo, PojoSettings> redirectPojo) {
        this(Optional.of(redirectPojo));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        PList annotatedElements = PList.fromIter(annotations).flatMap(roundEnv::getElementsAnnotatedWith);
        this.processClassOrRecord(annotatedElements);
        this.processStaticMethod(annotatedElements);
        return false;
    }

    private void processClassOrRecord(PList<? extends Element> annotatedElements) {
        annotatedElements.filter(this::isClassOrRecord).filter(TypeElement.class::isInstance).map(TypeElement.class::cast).distinct(Object::toString).flatMapOptional(this::findAnnotationPath).forEach(this::processTypeElementAndPath);
    }

    private void processStaticMethod(PList<? extends Element> annotatedElements) {
        annotatedElements.filter(this::isMethod).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(this::isStaticMethod).distinct(Object::toString).flatMapOptional(this::findAnnotationPath).forEach(this::processExecutableElementAndPath);
    }

    private boolean isClassOrRecord(Element e) {
        return e.getKind().equals((Object)ElementKind.CLASS) || e.getKind().name().equalsIgnoreCase("Record");
    }

    private boolean isMethod(Element element) {
        return element.getKind().equals((Object)ElementKind.METHOD);
    }

    private boolean isStaticMethod(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private void processExecutableElementAndPath(ElementAndAnnotationPath<ExecutableElement> elementAndPath) {
        PojoSettings pojoSettings = this.extractSettingsFromAnnotationPath(elementAndPath.getPath());
        ExecutableElement executableElement = elementAndPath.getElement();
        if (Booleans.not(executableElement.getThrownTypes().isEmpty())) {
            throw new PojoBuilderException("Annotating a throwing factory method is currently not supported, method '" + executableElement.getEnclosingElement() + "." + executableElement.getSimpleName() + "'");
        }
        QualifiedClassname factoryMethodOwner = ClassnameParser.parseThrowing(executableElement.getEnclosingElement().toString());
        DetectionSettings detectionSettings = new DetectionSettings(pojoSettings.getOptionalDetections());
        Type factoryMethodReturnType = TypeMirrorMapper.map(executableElement.getReturnType());
        QualifiedClassname pojoClassName = ClassnameParser.parseThrowing(executableElement.getReturnType().toString());
        PackageName pojoPackage = factoryMethodOwner.getPkg();
        Pojo pojo = this.extractPojoFromFactoryMethod(pojoClassName, executableElement, detectionSettings, factoryMethodOwner, pojoPackage, factoryMethodReturnType);
        this.outputPojo(pojo, pojoSettings);
    }

    private Pojo extractPojoFromFactoryMethod(QualifiedClassname pojoClassName, ExecutableElement executableElement, DetectionSettings detectionSettings, QualifiedClassname factoryMethodOwner, PackageName pojoPackage, Type returnType) {
        PList<PojoField> fields = PList.fromIter(executableElement.getParameters()).map(e -> this.convertToPojoField((Element)e, detectionSettings));
        PList<Argument> factoryMethodArguments = PList.fromIter(executableElement.getParameters()).map(ArgumentMapper::toArgument);
        PList<Generic> buildGenerics = TypeParameterProcessor.processTypeParameters(executableElement.getTypeParameters());
        FactoryMethod factoryMethod = FactoryMethodBuilder.factoryMethodBuilder().ownerClassname(factoryMethodOwner.getClassname()).pkg(pojoPackage).methodName(Name.fromString(executableElement.getSimpleName().toString())).arguments(factoryMethodArguments).build();
        return io.github.muehmar.pojobuilder.generator.model.PojoBuilder.pojoBuilder().pojoClassname(pojoClassName).pojoNameWithTypeVariables(returnType.getTypeDeclaration()).pkg(pojoPackage).fields(fields).constructors(PList.empty()).generics(buildGenerics).fieldBuilders(PList.empty()).andAllOptionals().factoryMethod(factoryMethod).buildMethod(Optional.empty()).build();
    }

    private void processTypeElementAndPath(ElementAndAnnotationPath<TypeElement> elementAndPath) {
        PojoSettings pojoSettings = this.extractSettingsFromAnnotationPath(elementAndPath.getPath());
        TypeElement classElement = elementAndPath.getElement();
        String fullClassName = classElement.toString();
        QualifiedClassname pojoClassname = ClassnameParser.parseThrowing(fullClassName);
        Pojo pojo = this.extractPojo(classElement, pojoSettings, pojoClassname);
        this.outputPojo(pojo, pojoSettings);
    }

    private Pojo extractPojo(TypeElement element, PojoSettings settings, QualifiedClassname pojoClassname) {
        DetectionSettings detectionSettings = new DetectionSettings(settings.getOptionalDetections());
        PList<Constructor> constructors = ConstructorProcessor.process(element);
        PList<Generic> generics = TypeParameterProcessor.processTypeParameters(element.getTypeParameters());
        PList<FieldBuilder> fieldBuilders = FieldBuilderProcessor.process(element);
        Optional<BuildMethod> buildMethod = BuildMethodProcessor.process(element);
        PList<PojoField> fields = PList.fromIter(element.getEnclosedElements()).filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).filter(this::isNonConstantField).filter(this::isNotIgnoredField).map(e -> this.convertToPojoField((Element)e, detectionSettings));
        return io.github.muehmar.pojobuilder.generator.model.PojoBuilder.pojoBuilder().pojoClassname(pojoClassname).pojoNameWithTypeVariables(pojoClassname.getName()).pkg(pojoClassname.getPkg()).fields(fields).constructors(constructors).generics(generics).fieldBuilders(fieldBuilders).andAllOptionals().factoryMethod(Optional.empty()).buildMethod(buildMethod).build();
    }

    private <T extends Element> Optional<ElementAndAnnotationPath<T>> findAnnotationPath(T element) {
        return NonEmptyList.fromIter(this.findAnnotationPath(element, PList.empty())).map(path -> new ElementAndAnnotationPath<Element>(element, (NonEmptyList<AnnotationMirror>)path));
    }

    private <T extends Element> PList<AnnotationMirror> findAnnotationPath(T currentElement, PList<AnnotationMirror> currentPath) {
        if (currentPath.size() >= 50) {
            return PList.empty();
        }
        PList<AnnotationMirror> annotationMirrors = PList.fromIter(currentElement.getAnnotationMirrors()).map(a -> a);
        Optional<AnnotationMirror> safeBuilder = annotationMirrors.find(a -> a.getAnnotationType().asElement().asType().toString().equals(PojoBuilder.class.getName()));
        return safeBuilder.map(currentPath::cons).orElseGet(() -> annotationMirrors.filter(a -> Booleans.not(currentPath.exists(a::equals))).map(a -> this.findAnnotationPath(a.getAnnotationType().asElement(), currentPath.cons((AnnotationMirror)a))).find(PList::nonEmpty).orElse(PList.empty()));
    }

    private PojoSettings extractSettingsFromAnnotationPath(NonEmptyList<AnnotationMirror> annotations) {
        return this.extractSettingsFromAnnotationPath(annotations.toPList(), PojoSettings.defaultSettings());
    }

    private PojoSettings extractSettingsFromAnnotationPath(PList<AnnotationMirror> annotations, PojoSettings currentSettings) {
        return annotations.headOption().map(a -> this.extractSettingsFromAnnotationPath(annotations.tail(), this.overrideWithAnnotationValues((AnnotationMirror)a, currentSettings))).orElse(currentSettings);
    }

    private PojoSettings overrideWithAnnotationValues(AnnotationMirror annotation, PojoSettings currentSettings) {
        return currentSettings.overrideOptionalDetection(AnnotationMemberExtractor.getOptionalDetection(annotation)).overrideBuilderName(AnnotationMemberExtractor.getBuilderName(annotation).map(String::trim).filter(Strings::nonEmpty).map(Name::fromString)).overrideBuilderSetMethodPrefix(AnnotationMemberExtractor.getBuilderSetMethodPrefix(annotation).map(String::trim).filter(Strings::nonEmpty).map(Name::fromString)).overrideBuilderAccessLevel(AnnotationMemberExtractor.getPackagePrivateBuilder(annotation).map(this::classAccessLevelModifierFromIsPackagePrivateFlag)).overrideEnableStandardBuilder(AnnotationMemberExtractor.getEnableStandardBuilder(annotation)).overrideEnableFullBuilder(AnnotationMemberExtractor.getEnableFullBuilder(annotation)).overrideFullBuilderFieldOrder(AnnotationMemberExtractor.getFullBuilderFieldOrder(annotation)).overrideIncludeOuterClassName(AnnotationMemberExtractor.getIncludeOuterClassName(annotation));
    }

    private ClassAccessLevelModifier classAccessLevelModifierFromIsPackagePrivateFlag(boolean isPackagePrivate) {
        return isPackagePrivate ? ClassAccessLevelModifier.PACKAGE_PRIVATE : ClassAccessLevelModifier.PUBLIC;
    }

    private void outputPojo(Pojo pojo, PojoSettings pojoSettings) {
        Optionals.ifPresentOrElse(this.redirectPojo, output -> output.accept(pojo, pojoSettings), () -> this.writeBuilder(pojo, pojoSettings));
    }

    private void writeBuilder(Pojo pojo, PojoSettings settings) {
        this.writeJavaFile(settings.qualifiedBuilderName(pojo), PojoBuilderGenerator.pojoBuilderGenerator(), pojo, settings);
    }

    private void writeJavaFile(Name qualifiedClassName, Generator<Pojo, PojoSettings> gen, Pojo pojo, PojoSettings pojoSettings) {
        String javaContent = gen.generate((Object)pojo, (Object)pojoSettings, Writer.createDefault()).asString();
        try {
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(qualifiedClassName.asString(), new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.println(javaContent);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isNonConstantField(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        return !modifiers.contains((Object)Modifier.STATIC);
    }

    private boolean isNotIgnoredField(Element element) {
        Optional<Ignore> annotation = Optional.ofNullable(element.getAnnotation(Ignore.class));
        return Booleans.not(annotation.isPresent());
    }

    private PojoField convertToPojoField(Element element, DetectionSettings settings) {
        Name fieldName = Name.fromString(element.getSimpleName().toString());
        Type fieldType = TypeMirrorMapper.map(element.asType());
        return this.convertToPojoField(element, fieldName, fieldType, settings);
    }

    private PojoField convertToPojoField(Element element, Name name, Type type, DetectionSettings settings) {
        return PojoFieldMapper.initial().or(this::mapOptionalPojoField).or(this::mapNullablePojoField).mapWithDefault(element, name, type, settings, () -> new PojoField(name, type, Necessity.REQUIRED));
    }

    private Optional<PojoField> mapOptionalPojoField(Element element, Name name, Type type, DetectionSettings settings) {
        return Optional.of(type).filter(ignore -> settings.getOptionalDetections().exists(arg_0 -> OptionalDetection.OPTIONAL_CLASS.equals(arg_0))).flatMap(this::getOptionalValueType).map(typeParameter -> new PojoField(name, (Type)typeParameter, Necessity.OPTIONAL));
    }

    private Optional<Type> getOptionalValueType(Type type) {
        Function<DeclaredType, Optional> getOptionalType = classType -> Optional.of(classType).filter(DeclaredType::isOptional).flatMap(t -> t.getTypeParameters().headOption());
        return type.onDeclaredType(getOptionalType).flatMap(Function.identity());
    }

    private Optional<PojoField> mapNullablePojoField(Element element, Name name, Type type, DetectionSettings settings) {
        return Optional.ofNullable(element.getAnnotation(Nullable.class)).filter(ignore -> settings.getOptionalDetections().exists(arg_0 -> OptionalDetection.NULLABLE_ANNOTATION.equals(arg_0))).map(ignore -> new PojoField(name, type, Necessity.OPTIONAL));
    }

    private static final class ElementAndAnnotationPath<T extends Element> {
        private final T element;
        private final NonEmptyList<AnnotationMirror> path;

        public ElementAndAnnotationPath(T element, NonEmptyList<AnnotationMirror> path) {
            this.element = element;
            this.path = path;
        }

        public T getElement() {
            return this.element;
        }

        public NonEmptyList<AnnotationMirror> getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementAndAnnotationPath)) {
                return false;
            }
            ElementAndAnnotationPath other = (ElementAndAnnotationPath)o;
            T this$element = this.getElement();
            T other$element = other.getElement();
            if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
                return false;
            }
            NonEmptyList<AnnotationMirror> this$path = this.getPath();
            NonEmptyList<AnnotationMirror> other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $element = this.getElement();
            result = result * 59 + ($element == null ? 43 : $element.hashCode());
            NonEmptyList<AnnotationMirror> $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        public String toString() {
            return "PojoBuilderProcessor.ElementAndAnnotationPath(element=" + this.getElement() + ", path=" + this.getPath() + ")";
        }
    }

    @FunctionalInterface
    private static interface PojoFieldMapper {
        public Optional<PojoField> map(Element var1, Name var2, Type var3, DetectionSettings var4);

        default public PojoFieldMapper or(PojoFieldMapper next) {
            PojoFieldMapper self = this;
            return (element, name, type, settings) -> {
                Optional<PojoField> result = self.map(element, name, type, settings);
                return result.isPresent() ? result : next.map(element, name, type, settings);
            };
        }

        default public PojoField mapWithDefault(Element element, Name name, Type type, DetectionSettings settings, Supplier<PojoField> s) {
            return this.map(element, name, type, settings).orElseGet(s);
        }

        public static PojoFieldMapper initial() {
            return (element, name, type, settings) -> Optional.empty();
        }
    }
}

