/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.builder.model;

import ch.bluecare.commons.data.NonEmptyList;
import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.annotations.FullBuilderFieldOrder;
import io.github.muehmar.pojobuilder.annotations.PojoBuilder;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.model.BuilderFieldWithMethod;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.model.IndexedField;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilderMethod;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import java.util.Optional;
import java.util.function.Predicate;

@PojoBuilder
public final class BuilderField {
    private final IndexedField indexedField;
    private final Optional<FieldBuilder> fieldBuilder;

    public Pojo getPojo() {
        return this.indexedField.getPojo();
    }

    public PojoField getField() {
        return this.indexedField.getField();
    }

    public int getIndex() {
        return this.indexedField.getIndex();
    }

    public boolean hasFieldBuilder() {
        return this.fieldBuilder.isPresent();
    }

    public boolean isDisableDefaultMethods() {
        return this.fieldBuilder.map(FieldBuilder::isDisableDefaultMethods).orElse(false);
    }

    public boolean isEnableDefaultMethods() {
        return !this.isDisableDefaultMethods();
    }

    public boolean isFieldOptional() {
        return this.indexedField.getField().isOptional();
    }

    public static PList<BuilderField> allFromPojo(Pojo pojo, FullBuilderFieldOrder fieldOrder) {
        switch (fieldOrder) {
            case REQUIRED_FIELDS_FIRST: {
                PList<PojoField> fields = pojo.getFields();
                PList<PojoField> requiredFields = fields.filter(PojoField::isRequired);
                PList<PojoField> optionalFields = fields.filter(PojoField::isOptional);
                return BuilderField.fromPojoAndFields(pojo, requiredFields.concat(optionalFields), ignore -> true);
            }
        }
        return BuilderField.fromPojo(pojo, ignore -> true);
    }

    public static PList<BuilderField> requiredFromPojo(Pojo pojo) {
        return BuilderField.fromPojo(pojo, PojoField::isRequired);
    }

    public static PList<BuilderField> optionalFromPojo(Pojo pojo) {
        return BuilderField.fromPojo(pojo, PojoField::isOptional);
    }

    private static PList<BuilderField> fromPojo(Pojo pojo, Predicate<PojoField> filter) {
        return BuilderField.fromPojoAndFields(pojo, pojo.getFields(), filter);
    }

    private static PList<BuilderField> fromPojoAndFields(Pojo pojo, PList<PojoField> fields, Predicate<PojoField> filter) {
        return fields.filter(filter).zipWithIndex().map(p -> {
            PojoField field = (PojoField)p.first();
            Integer index = (Integer)p.second();
            IndexedField indexedField = new IndexedField(pojo, field, index);
            Optional<FieldBuilder> fieldBuilder = pojo.getFieldBuilders().find(builder -> field.isFieldBuilder(pojo.getPojoClassname().getName(), (FieldBuilder)builder));
            return new BuilderField(indexedField, fieldBuilder);
        });
    }

    public PList<BuilderFieldWithMethod> getBuilderFieldsWithMethod() {
        return this.fieldBuilder.map(FieldBuilder::getMethods).map(NonEmptyList::toPList).orElse(PList.empty()).map(fieldBuilderMethod -> new BuilderFieldWithMethod(this, (FieldBuilderMethod)fieldBuilderMethod));
    }

    public BuilderField(IndexedField indexedField, Optional<FieldBuilder> fieldBuilder) {
        this.indexedField = indexedField;
        this.fieldBuilder = fieldBuilder;
    }

    public IndexedField getIndexedField() {
        return this.indexedField;
    }

    public Optional<FieldBuilder> getFieldBuilder() {
        return this.fieldBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderField)) {
            return false;
        }
        BuilderField other = (BuilderField)o;
        IndexedField this$indexedField = this.getIndexedField();
        IndexedField other$indexedField = other.getIndexedField();
        if (this$indexedField == null ? other$indexedField != null : !((Object)this$indexedField).equals(other$indexedField)) {
            return false;
        }
        Optional<FieldBuilder> this$fieldBuilder = this.getFieldBuilder();
        Optional<FieldBuilder> other$fieldBuilder = other.getFieldBuilder();
        return !(this$fieldBuilder == null ? other$fieldBuilder != null : !((Object)this$fieldBuilder).equals(other$fieldBuilder));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexedField $indexedField = this.getIndexedField();
        result = result * 59 + ($indexedField == null ? 43 : ((Object)$indexedField).hashCode());
        Optional<FieldBuilder> $fieldBuilder = this.getFieldBuilder();
        result = result * 59 + ($fieldBuilder == null ? 43 : ((Object)$fieldBuilder).hashCode());
        return result;
    }

    public String toString() {
        return "BuilderField(indexedField=" + this.getIndexedField() + ", fieldBuilder=" + this.getFieldBuilder() + ")";
    }

    public BuilderField withIndexedField(IndexedField indexedField) {
        return this.indexedField == indexedField ? this : new BuilderField(indexedField, this.fieldBuilder);
    }

    public BuilderField withFieldBuilder(Optional<FieldBuilder> fieldBuilder) {
        return this.fieldBuilder == fieldBuilder ? this : new BuilderField(this.indexedField, fieldBuilder);
    }
}

