/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.builder.shared;

import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.codegenerator.java.JavaGenerators;
import io.github.muehmar.codegenerator.java.JavaModifier;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.model.IndexedField;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.shared.RawClassNameGenerator;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import java.util.function.ToIntFunction;

public class BuilderMethodConstructor {
    private BuilderMethodConstructor() {
    }

    public static Generator<Pojo, PojoSettings> builderMethodConstructor(RawClassNameGenerator rawClassNameGenerator, ToIntFunction<Pojo> builderNumber) {
        return Generator.emptyGen().append(BuilderMethodConstructor.builderMethodConstructorInternal(rawClassNameGenerator), pojo -> PojoAndBuilderNumber.fromPojoAndBuilderNumber(pojo, builderNumber));
    }

    public static Generator<IndexedField, PojoSettings> builderMethodConstructor(RawClassNameGenerator rawClassNameGenerator) {
        return Generator.emptyGen().append(BuilderMethodConstructor.builderMethodConstructorInternal(rawClassNameGenerator), PojoAndBuilderNumber::fromIndexField);
    }

    private static Generator<PojoAndBuilderNumber, PojoSettings> builderMethodConstructorInternal(RawClassNameGenerator rawClassNameGenerator) {
        return JavaGenerators.constructorGen().modifiers(JavaModifier.PRIVATE).className(p -> String.format("%s", rawClassNameGenerator.forFieldIndex(p.getBuilderNumber()))).singleArgument(p -> String.format("Builder%s builder", p.getPojo().getTypeVariablesFormatted())).content("this.builder = builder;").build();
    }

    private static final class PojoAndBuilderNumber {
        private final Pojo pojo;
        private final int builderNumber;

        static PojoAndBuilderNumber fromIndexField(IndexedField indexedField) {
            return new PojoAndBuilderNumber(indexedField.getPojo(), indexedField.getIndex());
        }

        static PojoAndBuilderNumber fromPojoAndBuilderNumber(Pojo pojo, ToIntFunction<Pojo> builderNumber) {
            return new PojoAndBuilderNumber(pojo, builderNumber.applyAsInt(pojo));
        }

        public PojoAndBuilderNumber(Pojo pojo, int builderNumber) {
            this.pojo = pojo;
            this.builderNumber = builderNumber;
        }

        public Pojo getPojo() {
            return this.pojo;
        }

        public int getBuilderNumber() {
            return this.builderNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PojoAndBuilderNumber)) {
                return false;
            }
            PojoAndBuilderNumber other = (PojoAndBuilderNumber)o;
            if (this.getBuilderNumber() != other.getBuilderNumber()) {
                return false;
            }
            Pojo this$pojo = this.getPojo();
            Pojo other$pojo = other.getPojo();
            return !(this$pojo == null ? other$pojo != null : !((Object)this$pojo).equals(other$pojo));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBuilderNumber();
            Pojo $pojo = this.getPojo();
            result = result * 59 + ($pojo == null ? 43 : ((Object)$pojo).hashCode());
            return result;
        }

        public String toString() {
            return "BuilderMethodConstructor.PojoAndBuilderNumber(pojo=" + this.getPojo() + ", builderNumber=" + this.getBuilderNumber() + ")";
        }
    }
}

