/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.builder;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.codegenerator.java.ConstructorGen;
import io.github.muehmar.codegenerator.java.JavaGenerators;
import io.github.muehmar.codegenerator.java.JavaModifier;
import io.github.muehmar.pojobuilder.generator.impl.gen.Filters;
import io.github.muehmar.pojobuilder.generator.impl.gen.PackageGen;
import io.github.muehmar.pojobuilder.generator.impl.gen.RefsGen;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.full.FullBuilderGenerator;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.standard.StandardBuilderGenerator;
import io.github.muehmar.pojobuilder.generator.impl.gen.builder.unsafe.UnsafeBuilderGenerator;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PojoBuilderGenerator {
    private PojoBuilderGenerator() {
    }

    public static Generator<Pojo, PojoSettings> pojoBuilderGenerator() {
        return JavaGenerators.classGen().clazz().topLevel().packageGen((Generator)new PackageGen()).noJavaDoc().noAnnotations().modifierList((pojo, settings) -> PojoBuilderGenerator.createClassModifiers(settings)).className((p, s) -> s.builderName((Pojo)p).asString()).noSuperClass().noInterfaces().content(PojoBuilderGenerator.pojoBuilderContent()).build();
    }

    private static PList<JavaModifier> createClassModifiers(PojoSettings settings) {
        return PList.fromOptional(settings.getBuilderAccessLevel().asJavaModifier()).cons(JavaModifier.FINAL);
    }

    private static Generator<Pojo, PojoSettings> pojoBuilderContent() {
        ConstructorGen constructor = JavaGenerators.constructorGen().modifiers(JavaModifier.PRIVATE).className((p, s) -> s.builderName((Pojo)p).asString()).noArguments().noContent().build();
        return Generator.emptyGen().appendSingleBlankLine().append((Generator)constructor).appendSingleBlankLine().append(PojoBuilderGenerator.standardBuilderFactoryMethod((pojo, settings) -> "create")).appendSingleBlankLine().append(PojoBuilderGenerator.standardBuilderFactoryMethod((pojo, settings) -> String.format("%s", settings.builderName((Pojo)pojo).startLowerCase()))).appendSingleBlankLine().append(PojoBuilderGenerator.fullBuilderFactoryMethod((pojo, settings) -> "createFull")).appendSingleBlankLine().append(PojoBuilderGenerator.fullBuilderFactoryMethod((pojo, settings) -> String.format("full%s", settings.builderName((Pojo)pojo).startUpperCase()))).appendSingleBlankLine().append(UnsafeBuilderGenerator.unsafeBuilderGenerator()).appendSingleBlankLine().append(StandardBuilderGenerator.standardBuilderGenerator()).appendSingleBlankLine().append(FullBuilderGenerator.fullBuilderGenerator());
    }

    private static Generator<Pojo, PojoSettings> standardBuilderFactoryMethod(BiFunction<Pojo, PojoSettings, String> methodName) {
        Function<Pojo, Object> returnType = p -> "Builder0" + p.getTypeVariablesFormatted();
        Function<Pojo, String> content = p -> String.format("return new Builder0%s(new Builder%s());", p.getDiamond(), p.getTypeVariablesFormatted());
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC, JavaModifier.STATIC).genericTypes(p -> p.getGenerics().asList().map(Generic::getTypeDeclaration).map(Name::asString)).returnType(returnType).methodName(methodName).noArguments().doesNotThrow().content(content).build().append(RefsGen.genericRefs()).filter(Filters.isStandardBuilderEnabled());
    }

    private static Generator<Pojo, PojoSettings> fullBuilderFactoryMethod(BiFunction<Pojo, PojoSettings, String> methodName) {
        Function<Pojo, Object> returnType = p -> "FullBuilder0" + p.getTypeVariablesFormatted();
        Function<Pojo, String> content = p -> String.format("return new FullBuilder0%s(new Builder%s());", p.getDiamond(), p.getTypeVariablesFormatted());
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC, JavaModifier.STATIC).genericTypes(p -> p.getGenerics().asList().map(Generic::getTypeDeclaration).map(Name::asString)).returnType(returnType).methodName(methodName).noArguments().doesNotThrow().content(content).build().append(RefsGen.genericRefs()).filter(Filters.isFullBuilderEnabled());
    }
}

