/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Strings;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.Type;

public class Generics {
    PList<Generic> list;

    private Generics(PList<Generic> list) {
        this.list = list;
    }

    public static Generics of(PList<Generic> generics) {
        return new Generics(generics);
    }

    public static Generics of(Generic ... generics) {
        return new Generics(PList.fromArray(generics));
    }

    public static Generics empty() {
        return new Generics(PList.empty());
    }

    public String getTypeVariablesFormatted() {
        String typeVariables = this.list.map(Generic::getTypeVariable).mkString(", ");
        return Strings.surroundIfNotEmpty("<", typeVariables, ">");
    }

    public String getBoundedTypeVariablesFormatted() {
        String typeVariables = this.list.map(Generic::getTypeDeclaration).mkString(", ");
        return Strings.surroundIfNotEmpty("<", typeVariables, ">");
    }

    public PList<Name> getImports() {
        return this.list.flatMap(Generic::getUpperBounds).flatMap(Type::getImports);
    }

    public PList<Generic> asList() {
        return this.list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Generics)) {
            return false;
        }
        Generics other = (Generics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PList<Generic> this$list = this.list;
        PList<Generic> other$list = other.list;
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Generics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PList<Generic> $list = this.list;
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "Generics(list=" + this.list + ")";
    }
}

