/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import java.util.function.Function;
import java.util.function.Supplier;

public enum Necessity {
    REQUIRED(true),
    OPTIONAL(false);

    private final boolean required;

    private Necessity(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isOptional() {
        return !this.isRequired();
    }

    public <T> FoldOnOptional<T> onRequired(Supplier<T> s) {
        return new FoldOnOptional<Object>(onOptional -> this.required ? s.get() : onOptional.get());
    }

    public static class FoldOnOptional<T> {
        private final Function<Supplier<T>, T> f;

        public FoldOnOptional(Function<Supplier<T>, T> f) {
            this.f = f;
        }

        public T onOptional(Supplier<T> s) {
            return this.f.apply(s);
        }
    }
}

