/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model;

import io.github.muehmar.pojobuilder.generator.model.Name;

public final class PackageName {
    private final String pkg;

    private PackageName(String pkg) {
        this.pkg = pkg;
    }

    public static PackageName fromString(String pkg) {
        return new PackageName(pkg);
    }

    public static PackageName javaLang() {
        return PackageName.fromString("java.lang");
    }

    public static PackageName javaUtil() {
        return PackageName.fromString("java.util");
    }

    public Name qualifiedName(Name className) {
        return className.prefix(".").prefix(this.pkg);
    }

    public String asString() {
        return this.pkg;
    }

    public String toString() {
        return this.asString();
    }

    public String getPkg() {
        return this.pkg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PackageName)) {
            return false;
        }
        PackageName other = (PackageName)o;
        String this$pkg = this.getPkg();
        String other$pkg = other.getPkg();
        return !(this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pkg = this.getPkg();
        result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
        return result;
    }
}

