/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.impl.gen.builder.builderfactory;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.codegenerator.Generator;
import io.github.muehmar.codegenerator.java.JavaGenerators;
import io.github.muehmar.codegenerator.java.JavaModifier;
import io.github.muehmar.codegenerator.java.MethodGen;
import io.github.muehmar.pojobuilder.generator.impl.gen.Filters;
import io.github.muehmar.pojobuilder.generator.impl.gen.RefsGen;
import io.github.muehmar.pojobuilder.generator.model.Generic;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class BuilderFactoryMethods {
    private BuilderFactoryMethods() {
    }

    public static Generator<Pojo, PojoSettings> builderFactoryMethods() {
        return Generator.emptyGen().append(BuilderFactoryMethods.method(BuilderType.STANDARD, NameOption.SHORT, GenericsOption.NO_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.STANDARD, NameOption.INCLUDE_CLASS_NAME, GenericsOption.NO_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.STANDARD, NameOption.SHORT, GenericsOption.WITH_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.STANDARD, NameOption.INCLUDE_CLASS_NAME, GenericsOption.WITH_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.FULL, NameOption.SHORT, GenericsOption.NO_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.FULL, NameOption.INCLUDE_CLASS_NAME, GenericsOption.NO_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.FULL, NameOption.SHORT, GenericsOption.WITH_GENERICS)).appendSingleBlankLine().append(BuilderFactoryMethods.method(BuilderType.FULL, NameOption.INCLUDE_CLASS_NAME, GenericsOption.WITH_GENERICS));
    }

    private static Generator<Pojo, PojoSettings> method(BuilderType builderType, NameOption nameOption, GenericsOption genericsOption) {
        Function<Pojo, Object> returnType = p -> builderType.typeUppercase + "Builder0" + p.getTypeVariablesFormatted();
        Function<Pojo, String> content = p -> String.format("return new %sBuilder0%s(new Builder%s());", builderType.typeUppercase, p.getDiamond(), p.getTypeVariablesFormatted());
        return JavaGenerators.methodGen().modifiers(JavaModifier.PUBLIC, JavaModifier.STATIC).genericTypes(p -> p.getGenerics().asList().map(Generic::getTypeDeclaration).map(Name::asString)).returnType(returnType).methodName((pojo, settings) -> nameOption.getMethodName((Pojo)pojo, (PojoSettings)settings, builderType)).arguments(genericsOption::createArguments).doesNotThrow().content(content).build().append(RefsGen.genericRefs()).filter(builderType.isEnabled().and(genericsOption.isEnabled()));
    }

    private static enum BuilderType {
        STANDARD("", ""){

            @Override
            BiPredicate<Pojo, PojoSettings> isEnabled() {
                return Filters.isStandardBuilderEnabled();
            }
        }
        ,
        FULL("full", "Full"){

            @Override
            BiPredicate<Pojo, PojoSettings> isEnabled() {
                return Filters.isFullBuilderEnabled();
            }
        };

        private final String typeLowercase;
        private final String typeUppercase;

        private BuilderType(String typeLowercase, String typeUppercase) {
            this.typeLowercase = typeLowercase;
            this.typeUppercase = typeUppercase;
        }

        abstract BiPredicate<Pojo, PojoSettings> isEnabled();
    }

    private static enum NameOption {
        SHORT{

            @Override
            String getMethodName(Pojo pojo, PojoSettings settings, BuilderType builderType) {
                return String.format("create%s", builderType.typeUppercase);
            }
        }
        ,
        INCLUDE_CLASS_NAME{

            @Override
            String getMethodName(Pojo pojo, PojoSettings settings, BuilderType builderType) {
                return settings.builderName(pojo).startUpperCase().prefix(builderType.typeLowercase).startLowerCase().asString();
            }
        };


        abstract String getMethodName(Pojo var1, PojoSettings var2, BuilderType var3);
    }

    private static enum GenericsOption {
        NO_GENERICS{

            @Override
            PList<MethodGen.Argument> createArguments(Pojo pojo, PojoSettings settings) {
                return PList.empty();
            }

            @Override
            BiPredicate<Pojo, PojoSettings> isEnabled() {
                return (pojo, settings) -> true;
            }
        }
        ,
        WITH_GENERICS{

            @Override
            PList<MethodGen.Argument> createArguments(Pojo pojo, PojoSettings settings) {
                return pojo.getGenerics().asList().map(generic -> new MethodGen.Argument(String.format("Class<%s>", generic.getTypeVariable()), String.format("classOf%s", generic.getTypeVariable())));
            }

            @Override
            BiPredicate<Pojo, PojoSettings> isEnabled() {
                return (pojo, settings) -> pojo.getGenerics().asList().nonEmpty();
            }
        };


        abstract PList<MethodGen.Argument> createArguments(Pojo var1, PojoSettings var2);

        abstract BiPredicate<Pojo, PojoSettings> isEnabled();
    }
}

