/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.matching;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.matching.FieldArgument;
import io.github.muehmar.pojobuilder.generator.model.matching.MismatchReason;
import io.github.muehmar.pojobuilder.generator.model.matching.SingleArgumentMatchingResult;
import java.util.Optional;
import java.util.function.Function;

public final class ArgumentsMatchingResult {
    private final PList<SingleArgumentMatchingResult> matchingResults;

    public static ArgumentsMatchingResult fromSingleArgumentMatchingResult(SingleArgumentMatchingResult matchingResult) {
        return new ArgumentsMatchingResult(PList.single(matchingResult));
    }

    public Optional<PList<FieldArgument>> getFieldArguments() {
        PList fieldArguments = this.matchingResults.flatMapOptional(SingleArgumentMatchingResult::getFieldArgument);
        if (fieldArguments.size() == this.matchingResults.size()) {
            return Optional.of(fieldArguments);
        }
        return Optional.empty();
    }

    public <T> T fold(Function<PList<FieldArgument>, T> onFieldArguments, Function<PList<MismatchReason>, T> onMismatchReasons) {
        return (T)this.getFieldArguments().map(onFieldArguments).orElseGet(() -> {
            PList mismatchReasons = this.matchingResults.flatMapOptional(SingleArgumentMatchingResult::getMismatchReason);
            return onMismatchReasons.apply(mismatchReasons);
        });
    }

    public ArgumentsMatchingResult(PList<SingleArgumentMatchingResult> matchingResults) {
        this.matchingResults = matchingResults;
    }

    public PList<SingleArgumentMatchingResult> getMatchingResults() {
        return this.matchingResults;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentsMatchingResult)) {
            return false;
        }
        ArgumentsMatchingResult other = (ArgumentsMatchingResult)o;
        PList<SingleArgumentMatchingResult> this$matchingResults = this.getMatchingResults();
        PList<SingleArgumentMatchingResult> other$matchingResults = other.getMatchingResults();
        return !(this$matchingResults == null ? other$matchingResults != null : !((Object)this$matchingResults).equals(other$matchingResults));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PList<SingleArgumentMatchingResult> $matchingResults = this.getMatchingResults();
        result = result * 59 + ($matchingResults == null ? 43 : ((Object)$matchingResults).hashCode());
        return result;
    }

    public String toString() {
        return "ArgumentsMatchingResult(matchingResults=" + this.getMatchingResults() + ")";
    }
}

