/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.matching;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.matching.MatchingConstructor;
import io.github.muehmar.pojobuilder.generator.model.matching.MismatchReason;
import io.github.muehmar.pojobuilder.generator.model.matching.SingleConstructorMatchingResult;
import io.github.muehmar.pojobuilder.generator.model.settings.FieldMatching;
import java.util.Optional;

public final class ConstructorMatchingResults {
    private final PList<SingleConstructorMatchingResult> results;

    public Optional<MatchingConstructor> getFirstMatchingConstructor() {
        return this.results.flatMapOptional(SingleConstructorMatchingResult::getMatchingConstructor).headOption();
    }

    public MatchingConstructor getFirstMatchingConstructorOrThrow(Pojo pojo, FieldMatching fieldMatching) {
        return this.getFirstMatchingConstructor().orElseThrow(() -> this.createNoMatchFoundException(pojo, fieldMatching));
    }

    private PojoBuilderException createNoMatchFoundException(Pojo pojo, FieldMatching fieldMatching) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("No matching constructor found for class/record %s.\n", pojo.getPojoClassname()));
        stringBuilder.append(String.format("The class/record %s needs a constructor which is:\n", pojo.getPojoClassname()));
        stringBuilder.append("  * Accessible from within the same package, i.e. at least package-private\n");
        stringBuilder.append(String.format("  * Has the following %d arguments in the same order:\n", pojo.getFields().size()));
        pojo.getFields().forEach(field -> stringBuilder.append(ConstructorMatchingResults.formatExpectedArgument(field, fieldMatching).concat("\n")));
        stringBuilder.append("\nThe following accessible constructors are found but do not match:");
        this.results.forEach(result -> result.getMismatchReasons().ifPresent(mismatchReasons -> stringBuilder.append("\n").append(ConstructorMatchingResults.formatConstructorMismatch(result.getConstructor(), mismatchReasons))));
        return new PojoBuilderException(stringBuilder.toString());
    }

    private static String formatExpectedArgument(PojoField pojoField, FieldMatching fieldMatching) {
        String additionalPossibleType = pojoField.isRequired() ? "" : String.format("or Optional<%s>", pojoField.getType().getName());
        String nameCondition = fieldMatching.equals((Object)FieldMatching.TYPE_AND_NAME) ? String.format(" named %s", pojoField.getName()) : "";
        return "    " + String.format("* Argument%s with type %s %s", nameCondition, pojoField.getType().getName(), additionalPossibleType).trim();
    }

    private static String formatConstructorMismatch(Constructor constructor, PList<MismatchReason> mismatchReasons) {
        StringBuilder stringBuilder = new StringBuilder();
        String argumentsFormatted = constructor.getArguments().map(arg -> String.format("%s %s", arg.getType().getTypeDeclaration(), arg.getName())).mkString(", ");
        stringBuilder.append(String.format("  * %s(%s)", constructor.getName(), argumentsFormatted));
        mismatchReasons.forEach(mismatchReason -> stringBuilder.append("\n").append(String.format("    * Mismatch reason: %s", mismatchReason.getReason())));
        return stringBuilder.toString();
    }

    public ConstructorMatchingResults(PList<SingleConstructorMatchingResult> results) {
        this.results = results;
    }

    public PList<SingleConstructorMatchingResult> getResults() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorMatchingResults)) {
            return false;
        }
        ConstructorMatchingResults other = (ConstructorMatchingResults)o;
        PList<SingleConstructorMatchingResult> this$results = this.getResults();
        PList<SingleConstructorMatchingResult> other$results = other.getResults();
        return !(this$results == null ? other$results != null : !((Object)this$results).equals(other$results));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PList<SingleConstructorMatchingResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        return result;
    }

    public String toString() {
        return "ConstructorMatchingResults(results=" + this.getResults() + ")";
    }
}

