/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.generator.model.matching;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoField;

public final class MismatchReason {
    private final String reason;

    public static MismatchReason nonMatchingArgumentType(PojoField field, Argument argument) {
        String reason = String.format("The type '%s' of argument '%s' does not match the type '%s' of field '%s'.", argument.getType().getName(), argument.getName(), field.getType().getName(), field.getName());
        return new MismatchReason(reason);
    }

    public static MismatchReason nonMatchingName(PojoField field, Argument argument) {
        String reason = String.format("Field '%s' does not match the name of argument '%s'.", field.getName(), argument.getName());
        return new MismatchReason(reason);
    }

    public static MismatchReason nonMatchingArgumentCount(Pojo pojo, PList<Argument> arguments) {
        return new MismatchReason(String.format("The number of arguments (%d) does not match the number of fields (%d).", arguments.size(), pojo.getFields().size()));
    }

    public MismatchReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MismatchReason)) {
            return false;
        }
        MismatchReason other = (MismatchReason)o;
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    public String toString() {
        return "MismatchReason(reason=" + this.getReason() + ")";
    }
}

