/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.BuildMethod;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.FieldBuilder;
import io.github.muehmar.pojobuilder.generator.model.Generics;
import io.github.muehmar.pojobuilder.generator.model.Pojo;
import io.github.muehmar.pojobuilder.generator.model.PojoBuilder;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import io.github.muehmar.pojobuilder.generator.model.type.ClassnameParser;
import io.github.muehmar.pojobuilder.generator.model.type.QualifiedClassname;
import io.github.muehmar.pojobuilder.processor.BuildMethodProcessor;
import io.github.muehmar.pojobuilder.processor.ConstructorProcessor;
import io.github.muehmar.pojobuilder.processor.FieldBuilderProcessor;
import io.github.muehmar.pojobuilder.processor.PojoBuilderProcessor;
import io.github.muehmar.pojobuilder.processor.TypeParameterProcessor;
import io.github.muehmar.pojobuilder.processor.mapper.PojoFieldMapper;
import io.github.muehmar.pojobuilder.processor.mapper.PojoSettingsMapper;
import io.github.muehmar.pojobuilder.processor.model.DetectionSettings;
import io.github.muehmar.pojobuilder.processor.writer.PojoWriter;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class AnnotatedConstructorProcessor {
    private AnnotatedConstructorProcessor() {
    }

    public static void processConstructor(PojoBuilderProcessor.ElementAndAnnotationPath<ExecutableElement> elementAndPath, PojoWriter pojoWriter, Filer filer) {
        PojoSettings pojoSettings = PojoSettingsMapper.extractSettingsFromAnnotationPath(elementAndPath.getPath());
        ExecutableElement constructorElement = elementAndPath.getElement();
        Element maybeClassElement = constructorElement.getEnclosingElement();
        if (!(maybeClassElement instanceof TypeElement)) {
            throw new PojoBuilderException(String.format("Cannot process constructor %s because enclosing element is not a class or record!", constructorElement.getSimpleName()));
        }
        TypeElement classElement = (TypeElement)maybeClassElement;
        Pojo pojo = AnnotatedConstructorProcessor.extractPojo(pojoSettings, classElement, constructorElement);
        pojoWriter.writePojo(pojo, pojoSettings, filer);
    }

    private static Pojo extractPojo(PojoSettings pojoSettings, TypeElement classElement, ExecutableElement constructorElement) {
        DetectionSettings detectionSettings = new DetectionSettings(pojoSettings.getOptionalDetections());
        String fullClassName = classElement.toString();
        QualifiedClassname pojoClassname = ClassnameParser.parseThrowing(fullClassName);
        Constructor constructor = ConstructorProcessor.processConstructor(pojoClassname.getSimpleName(), constructorElement);
        Generics generics = TypeParameterProcessor.processTypeParameters(classElement.getTypeParameters());
        PList<FieldBuilder> fieldBuilders = FieldBuilderProcessor.process(classElement);
        Optional<BuildMethod> buildMethod = BuildMethodProcessor.process(classElement);
        PList<PojoField> fields = PList.fromIter(constructorElement.getParameters()).map(e -> PojoFieldMapper.mapToPojoField(e, detectionSettings));
        return PojoBuilder.pojoBuilder().pojoClassname(pojoClassname).pojoNameWithTypeVariables(pojoClassname.getName().append(generics.getTypeVariablesFormatted())).pkg(pojoClassname.getPkg()).fields(fields).constructors(PList.single(constructor)).generics(generics).fieldBuilders(fieldBuilders).andAllOptionals().factoryMethod(Optional.empty()).buildMethod(buildMethod).build();
    }
}

