/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.annotations.BuildMethod;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.QualifiedClassname;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.processor.ExceptionProcessor;
import io.github.muehmar.pojobuilder.processor.mapper.TypeMirrorMapper;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class BuildMethodProcessor {
    private BuildMethodProcessor() {
    }

    public static Optional<io.github.muehmar.pojobuilder.generator.model.BuildMethod> process(Element pojo) {
        PList<io.github.muehmar.pojobuilder.generator.model.BuildMethod> buildMethods = PList.fromIter(pojo.getEnclosedElements()).filter(e -> e.getAnnotation(BuildMethod.class) != null).map(e -> BuildMethodProcessor.convertToBuildMethod(pojo, e));
        if (buildMethods.size() >= 2) {
            String message = String.format("There is only one custom build method allowed (annotated with @%s) in class %s", BuildMethod.class.getSimpleName(), pojo.getSimpleName());
            throw new PojoBuilderException(message);
        }
        return buildMethods.headOption();
    }

    private static io.github.muehmar.pojobuilder.generator.model.BuildMethod convertToBuildMethod(Element pojo, Element element) {
        ExecutableElement annotatedMethod = BuildMethodProcessor.assertCorrectMethodSignature(pojo, element);
        Name methodName = Name.fromString(annotatedMethod.getSimpleName().toString());
        Type returnType = TypeMirrorMapper.map(annotatedMethod.getReturnType());
        PList<QualifiedClassname> exceptions = ExceptionProcessor.process(annotatedMethod);
        return new io.github.muehmar.pojobuilder.generator.model.BuildMethod(methodName, returnType, exceptions);
    }

    private static ExecutableElement assertCorrectMethodSignature(Element pojo, Element annotatedMethod) {
        BuildMethodProcessor.assertMethodKind(pojo, annotatedMethod);
        BuildMethodProcessor.assertNotPrivateMethod(pojo, annotatedMethod);
        BuildMethodProcessor.assertStaticMethod(pojo, annotatedMethod);
        return BuildMethodProcessor.assertSinglePojoArgument(pojo, annotatedMethod);
    }

    private static void assertMethodKind(Element pojo, Element annotatedMethod) {
        if (Booleans.not(annotatedMethod.getKind().equals((Object)ElementKind.METHOD))) {
            String message = String.format("'%s' in class '%s' annotated with @%s is not a method", annotatedMethod.getSimpleName(), pojo.getSimpleName(), BuildMethod.class.getSimpleName());
            throw new PojoBuilderException(message);
        }
    }

    private static void assertNotPrivateMethod(Element pojo, Element annotatedMethod) {
        if (annotatedMethod.getModifiers().contains((Object)Modifier.PRIVATE)) {
            String message = String.format("The modifier 'private' is not allowed for methods annotated with @%s. Method '%s' in class '%s'.", BuildMethod.class.getSimpleName(), annotatedMethod.getSimpleName(), pojo.getSimpleName());
            throw new PojoBuilderException(message);
        }
    }

    private static void assertStaticMethod(Element pojo, Element annotatedMethod) {
        if (Booleans.not(annotatedMethod.getModifiers().contains((Object)Modifier.STATIC))) {
            String message = String.format("Method '%s' in class '%s' annotated with @%s must be static.", annotatedMethod.getSimpleName(), pojo.getSimpleName(), BuildMethod.class.getSimpleName());
            throw new PojoBuilderException(message);
        }
    }

    private static ExecutableElement assertSinglePojoArgument(Element pojo, Element annotatedMethod) {
        ExecutableElement annotatedMethod1 = (ExecutableElement)annotatedMethod;
        List<? extends VariableElement> parameters = annotatedMethod1.getParameters();
        Type pojoType = TypeMirrorMapper.map(pojo.asType());
        if (parameters.size() != 1) {
            String message = String.format("Method '%s' in class '%s' annotated with @%s must have exactly one argument accepting the built instance of %s.", annotatedMethod.getSimpleName(), pojo.getSimpleName(), BuildMethod.class.getSimpleName(), pojo.getSimpleName());
            throw new PojoBuilderException(message);
        }
        Type argumentType = TypeMirrorMapper.map(parameters.get(0).asType());
        if (Booleans.not(pojoType.equals(argumentType))) {
            String message = String.format("Wrong argument type in method '%s' in class '%s' annotated with @%s. It must accept the built instance of %s.", annotatedMethod.getSimpleName(), pojo.getSimpleName(), BuildMethod.class.getSimpleName(), pojo.getSimpleName());
            throw new PojoBuilderException(message);
        }
        return annotatedMethod1;
    }
}

