/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.exception.PojoBuilderException;
import io.github.muehmar.pojobuilder.generator.model.Argument;
import io.github.muehmar.pojobuilder.generator.model.Constructor;
import io.github.muehmar.pojobuilder.generator.model.ConstructorBuilder;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.type.QualifiedClassname;
import io.github.muehmar.pojobuilder.processor.ExceptionProcessor;
import io.github.muehmar.pojobuilder.processor.mapper.ArgumentMapper;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public class ConstructorProcessor {
    private ConstructorProcessor() {
    }

    public static PList<Constructor> process(Element pojo) {
        return PList.fromIter(pojo.getEnclosedElements()).filter(e -> e.getKind().equals((Object)ElementKind.CONSTRUCTOR) && e instanceof ExecutableElement).map(ExecutableElement.class::cast).filter(e -> Booleans.not(e.getModifiers().contains((Object)Modifier.PRIVATE))).map(e -> ConstructorProcessor.processConstructor(Name.fromString(pojo.getSimpleName().toString()), e));
    }

    public static Constructor processConstructor(Name constructorName, ExecutableElement constructor) {
        if (Booleans.not(constructor.getKind().equals((Object)ElementKind.CONSTRUCTOR))) {
            String message = String.format("Element %s is not a constructor and cannot be processed. This is likely a programming error, please report an issue with some sample code.", constructor.getSimpleName());
            throw new PojoBuilderException(message);
        }
        PList<Argument> arguments = PList.fromIter(constructor.getParameters()).map(ArgumentMapper::toArgument);
        PList<QualifiedClassname> exceptions = ExceptionProcessor.process(constructor);
        return ConstructorBuilder.fullConstructorBuilder().name(constructorName).arguments(arguments).exceptions(exceptions).build();
    }
}

