/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor;

import ch.bluecare.commons.data.NonEmptyList;
import ch.bluecare.commons.data.PList;
import com.google.auto.service.AutoService;
import io.github.muehmar.pojobuilder.Booleans;
import io.github.muehmar.pojobuilder.annotations.PojoBuilder;
import io.github.muehmar.pojobuilder.processor.AnnotatedClassProcessor;
import io.github.muehmar.pojobuilder.processor.AnnotatedConstructorProcessor;
import io.github.muehmar.pojobuilder.processor.AnnotatedFactoryMethodProcessor;
import io.github.muehmar.pojobuilder.processor.writer.PojoWriter;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"*"})
@AutoService(value={Processor.class})
public class PojoBuilderProcessor
extends AbstractProcessor {
    private static final int MAX_ANNOTATION_PATH_DEPTH = 50;
    private final PojoWriter pojoWriter;

    public PojoBuilderProcessor(PojoWriter pojoWriter) {
        this.pojoWriter = pojoWriter;
    }

    public PojoBuilderProcessor() {
        this(PojoWriter.defaultWriter());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        PList annotatedElements = PList.fromIter(annotations).flatMap(roundEnv::getElementsAnnotatedWith);
        this.processClassOrRecord(annotatedElements);
        this.processStaticMethod(annotatedElements);
        this.processConstructor(annotatedElements);
        return false;
    }

    private void processClassOrRecord(PList<? extends Element> annotatedElements) {
        annotatedElements.filter(this::isClassOrRecord).filter(TypeElement.class::isInstance).map(TypeElement.class::cast).distinct(Object::toString).flatMapOptional(this::findAnnotationPath).forEach(elementAndPath -> AnnotatedClassProcessor.processClassOrRecord(elementAndPath, this.pojoWriter, this.processingEnv.getFiler()));
    }

    private void processStaticMethod(PList<? extends Element> annotatedElements) {
        annotatedElements.filter(this::isMethod).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(this::isStaticMethod).distinct(Object::toString).flatMapOptional(this::findAnnotationPath).forEach(elementAndPath -> AnnotatedFactoryMethodProcessor.processFactoryMethod(elementAndPath, this.pojoWriter, this.processingEnv.getFiler()));
    }

    private void processConstructor(PList<? extends Element> annotatedElements) {
        annotatedElements.filter(this::isConstructor).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).distinct(Object::toString).flatMapOptional(this::findAnnotationPath).forEach(elementAndPath -> AnnotatedConstructorProcessor.processConstructor(elementAndPath, this.pojoWriter, this.processingEnv.getFiler()));
    }

    private boolean isClassOrRecord(Element e) {
        return e.getKind().equals((Object)ElementKind.CLASS) || e.getKind().name().equalsIgnoreCase("Record");
    }

    private boolean isMethod(Element element) {
        return element.getKind().equals((Object)ElementKind.METHOD);
    }

    private boolean isConstructor(Element element) {
        return element.getKind().equals((Object)ElementKind.CONSTRUCTOR);
    }

    private boolean isStaticMethod(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    private <T extends Element> Optional<ElementAndAnnotationPath<T>> findAnnotationPath(T element) {
        return NonEmptyList.fromIter(this.findAnnotationPath(element, PList.empty())).map(path -> new ElementAndAnnotationPath<Element>(element, (NonEmptyList<AnnotationMirror>)path));
    }

    private <T extends Element> PList<AnnotationMirror> findAnnotationPath(T currentElement, PList<AnnotationMirror> currentPath) {
        if (currentPath.size() >= 50) {
            return PList.empty();
        }
        PList<AnnotationMirror> annotationMirrors = PList.fromIter(currentElement.getAnnotationMirrors()).map(a -> a);
        Optional<AnnotationMirror> safeBuilder = annotationMirrors.find(a -> a.getAnnotationType().asElement().asType().toString().equals(PojoBuilder.class.getName()));
        return safeBuilder.map(currentPath::cons).orElseGet(() -> annotationMirrors.filter(a -> Booleans.not(currentPath.exists(a::equals))).map(a -> this.findAnnotationPath(a.getAnnotationType().asElement(), currentPath.cons((AnnotationMirror)a))).find(PList::nonEmpty).orElse(PList.empty()));
    }

    public static final class ElementAndAnnotationPath<T extends Element> {
        private final T element;
        private final NonEmptyList<AnnotationMirror> path;

        public ElementAndAnnotationPath(T element, NonEmptyList<AnnotationMirror> path) {
            this.element = element;
            this.path = path;
        }

        public T getElement() {
            return this.element;
        }

        public NonEmptyList<AnnotationMirror> getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementAndAnnotationPath)) {
                return false;
            }
            ElementAndAnnotationPath other = (ElementAndAnnotationPath)o;
            T this$element = this.getElement();
            T other$element = other.getElement();
            if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
                return false;
            }
            NonEmptyList<AnnotationMirror> this$path = this.getPath();
            NonEmptyList<AnnotationMirror> other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $element = this.getElement();
            result = result * 59 + ($element == null ? 43 : $element.hashCode());
            NonEmptyList<AnnotationMirror> $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        public String toString() {
            return "PojoBuilderProcessor.ElementAndAnnotationPath(element=" + this.getElement() + ", path=" + this.getPath() + ")";
        }
    }
}

