/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor.mapper;

import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.annotations.Nullable;
import io.github.muehmar.pojobuilder.annotations.OptionalDetection;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.Necessity;
import io.github.muehmar.pojobuilder.generator.model.PojoField;
import io.github.muehmar.pojobuilder.generator.model.type.Type;
import io.github.muehmar.pojobuilder.processor.mapper.TypeMirrorMapper;
import io.github.muehmar.pojobuilder.processor.model.DetectionSettings;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class PojoFieldMapper {
    private PojoFieldMapper() {
    }

    public static PojoField mapToPojoField(Element element, DetectionSettings settings) {
        Name fieldName = Name.fromString(element.getSimpleName().toString());
        Type fieldType = TypeMirrorMapper.map(element.asType());
        return PojoFieldMapper.mapToPojoField(element, fieldName, fieldType, settings);
    }

    private static PojoField mapToPojoField(Element element, Name name, Type type, DetectionSettings settings) {
        return Mapper.initial().or(PojoFieldMapper::mapOptionalPojoField).or(PojoFieldMapper::mapNullablePojoField).mapWithDefault(element, name, type, settings, () -> new PojoField(name, type, Necessity.REQUIRED));
    }

    private static Optional<PojoField> mapOptionalPojoField(Element element, Name name, Type type, DetectionSettings settings) {
        return Optional.of(type).filter(ignore -> settings.getOptionalDetections().exists(arg_0 -> OptionalDetection.OPTIONAL_CLASS.equals(arg_0))).flatMap(PojoFieldMapper::getOptionalValueType).map(typeParameter -> new PojoField(name, (Type)typeParameter, Necessity.OPTIONAL));
    }

    private static Optional<Type> getOptionalValueType(Type type) {
        Function<io.github.muehmar.pojobuilder.generator.model.type.DeclaredType, Optional> getOptionalType = classType -> Optional.of(classType).filter(io.github.muehmar.pojobuilder.generator.model.type.DeclaredType::isOptional).flatMap(t -> t.getTypeParameters().headOption());
        return type.onDeclaredType(getOptionalType).flatMap(Function.identity());
    }

    private static Optional<PojoField> mapNullablePojoField(Element element, Name name, Type type, DetectionSettings settings) {
        PList<String> nullableAnnotationClasses = PList.of(Nullable.class.getName(), "javax.annotation.Nullable", "jakarta.annotation.Nullable");
        return PList.fromIter(element.getAnnotationMirrors()).map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).map(Element::asType).map(TypeMirror::toString).find(annotationClassName -> nullableAnnotationClasses.exists(annotationClassName::equals)).filter(ignore -> settings.getOptionalDetections().exists(arg_0 -> OptionalDetection.NULLABLE_ANNOTATION.equals(arg_0))).map(ignore -> new PojoField(name, type, Necessity.OPTIONAL));
    }

    @FunctionalInterface
    private static interface Mapper {
        public Optional<PojoField> map(Element var1, Name var2, Type var3, DetectionSettings var4);

        default public Mapper or(Mapper next) {
            Mapper self = this;
            return (element, name, type, settings) -> {
                Optional<PojoField> result = self.map(element, name, type, settings);
                return result.isPresent() ? result : next.map(element, name, type, settings);
            };
        }

        default public PojoField mapWithDefault(Element element, Name name, Type type, DetectionSettings settings, Supplier<PojoField> s) {
            return this.map(element, name, type, settings).orElseGet(s);
        }

        public static Mapper initial() {
            return (element, name, type, settings) -> Optional.empty();
        }
    }
}

