/*
 * Decompiled with CFR 0.152.
 */
package io.github.muehmar.pojobuilder.processor.mapper;

import ch.bluecare.commons.data.NonEmptyList;
import ch.bluecare.commons.data.PList;
import io.github.muehmar.pojobuilder.Strings;
import io.github.muehmar.pojobuilder.generator.model.ClassAccessLevelModifier;
import io.github.muehmar.pojobuilder.generator.model.Name;
import io.github.muehmar.pojobuilder.generator.model.settings.FieldMatching;
import io.github.muehmar.pojobuilder.generator.model.settings.PojoSettings;
import io.github.muehmar.pojobuilder.processor.mapper.AnnotationMemberMapper;
import javax.lang.model.element.AnnotationMirror;

public class PojoSettingsMapper {
    private PojoSettingsMapper() {
    }

    public static PojoSettings extractSettingsFromAnnotationPath(NonEmptyList<AnnotationMirror> annotations) {
        return PojoSettingsMapper.extractSettingsFromAnnotationPath(annotations.toPList(), PojoSettings.defaultSettings());
    }

    private static PojoSettings extractSettingsFromAnnotationPath(PList<AnnotationMirror> annotations, PojoSettings currentSettings) {
        return annotations.headOption().map(a -> PojoSettingsMapper.extractSettingsFromAnnotationPath(annotations.tail(), PojoSettingsMapper.overrideWithAnnotationValues(a, currentSettings))).orElse(currentSettings);
    }

    private static PojoSettings overrideWithAnnotationValues(AnnotationMirror annotation, PojoSettings currentSettings) {
        return currentSettings.overrideOptionalDetection(AnnotationMemberMapper.getOptionalDetection(annotation)).overrideFieldMatching(AnnotationMemberMapper.getConstructorMatching(annotation).map(FieldMatching::fromConstructorMatching)).overrideBuilderName(AnnotationMemberMapper.getBuilderName(annotation).map(String::trim).filter(Strings::nonEmpty).map(Name::fromString)).overrideBuilderSetMethodPrefix(AnnotationMemberMapper.getBuilderSetMethodPrefix(annotation).map(String::trim).filter(Strings::nonEmpty).map(Name::fromString)).overrideBuilderAccessLevel(AnnotationMemberMapper.getPackagePrivateBuilder(annotation).map(PojoSettingsMapper::classAccessLevelModifierFromIsPackagePrivateFlag)).overrideEnableStandardBuilder(AnnotationMemberMapper.getEnableStandardBuilder(annotation)).overrideEnableFullBuilder(AnnotationMemberMapper.getEnableFullBuilder(annotation)).overrideFullBuilderFieldOrder(AnnotationMemberMapper.getFullBuilderFieldOrder(annotation)).overrideIncludeOuterClassName(AnnotationMemberMapper.getIncludeOuterClassName(annotation));
    }

    private static ClassAccessLevelModifier classAccessLevelModifierFromIsPackagePrivateFlag(boolean isPackagePrivate) {
        return isPackagePrivate ? ClassAccessLevelModifier.PACKAGE_PRIVATE : ClassAccessLevelModifier.PUBLIC;
    }
}

