/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.config;

import dev.langchain4j.model.chat.ChatLanguageModel;
import java.util.concurrent.TimeUnit;
import org.mule.extension.mulechain.internal.llm.ConfigTypeProvider;
import org.mule.extension.mulechain.internal.llm.LangchainLLMModelNameProvider;
import org.mule.extension.mulechain.internal.llm.LangchainLLMTypeProvider;
import org.mule.extension.mulechain.internal.llm.config.ConfigExtractor;
import org.mule.extension.mulechain.internal.llm.config.ConfigType;
import org.mule.extension.mulechain.internal.llm.type.LangchainLLMType;
import org.mule.extension.mulechain.internal.operation.LangchainEmbeddingStoresOperations;
import org.mule.extension.mulechain.internal.operation.LangchainImageModelsOperations;
import org.mule.extension.mulechain.internal.operation.LangchainLLMOperations;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration(name="config")
@Operations(value={LangchainLLMOperations.class, LangchainEmbeddingStoresOperations.class, LangchainImageModelsOperations.class})
public class LangchainLLMConfiguration
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangchainLLMConfiguration.class);
    @Parameter
    @Placement(order=1, tab="General")
    @DisplayName(value="LLM type")
    @OfValues(value=LangchainLLMTypeProvider.class)
    private String llmType;
    @Parameter
    @Placement(order=2, tab="General")
    @OfValues(value=ConfigTypeProvider.class)
    private String configType;
    @Parameter
    @Placement(order=3, tab="General")
    private String filePath;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @OfValues(value=LangchainLLMModelNameProvider.class)
    @Placement(order=4, tab="General")
    private String modelName;
    @Parameter
    @Placement(order=5, tab="General")
    @Optional(defaultValue="0.7")
    private double temperature = 0.7;
    @Parameter
    @Placement(order=6, tab="General")
    @Optional(defaultValue="0.95")
    private double topP = 0.95;
    @Parameter
    @Placement(order=7, tab="General")
    @Optional(defaultValue="60")
    @DisplayName(value="LLM timeout")
    private int llmTimeout = 60;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(order=8, tab="General")
    @DisplayName(value="LLM timeout unit")
    @Summary(value="Time unit to be used in the LLM Timeout")
    private TimeUnit llmTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @Placement(order=9, tab="General")
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional(defaultValue="500")
    private int maxTokens = 500;
    private ConfigExtractor configExtractor;
    private ChatLanguageModel model;

    public String getLlmType() {
        return this.llmType;
    }

    public String getConfigType() {
        return this.configType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getModelName() {
        return this.modelName;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTopP() {
        return this.topP;
    }

    public int getLlmTimeout() {
        return this.llmTimeout;
    }

    public TimeUnit getLlmTimeoutUnit() {
        return this.llmTimeoutUnit;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public ConfigExtractor getConfigExtractor() {
        return this.configExtractor;
    }

    public ChatLanguageModel getModel() {
        return this.model;
    }

    private ChatLanguageModel createModel(ConfigExtractor configExtractor) {
        LangchainLLMType type = LangchainLLMType.fromValue(this.llmType);
        LOGGER.debug("Creating Model of LLMType: {}", (Object)this.llmType);
        return type.getConfigBiFunction().apply(configExtractor, this);
    }

    public void initialise() throws InitialisationException {
        if (this.configType != null) {
            ConfigType config = ConfigType.fromValue(this.configType);
            this.configExtractor = config.getConfigExtractorFunction().apply(this);
            this.model = this.createModel(this.configExtractor);
        } else {
            LOGGER.warn("Initialisation is called before the values are populated");
        }
    }
}

