/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.helpers;

import dev.langchain4j.model.output.Response;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.extension.mulechain.api.metadata.LLMResponseAttributes;
import org.mule.extension.mulechain.api.metadata.ScannedDocResponseAttributes;
import org.mule.extension.mulechain.api.metadata.TokenUsage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class ResponseHelper {
    private ResponseHelper() {
    }

    public static Result<InputStream, LLMResponseAttributes> createLLMResponse(String response, dev.langchain4j.service.Result<?> result, Map<String, String> responseAttributes) {
        TokenUsage tokenUsage = result.tokenUsage() != null ? new TokenUsage(result.tokenUsage().inputTokenCount(), result.tokenUsage().outputTokenCount(), result.tokenUsage().totalTokenCount()) : null;
        return ResponseHelper.createLLMResponse(response, tokenUsage, responseAttributes);
    }

    public static Result<InputStream, LLMResponseAttributes> createLLMResponse(String response, Response<?> result, Map<String, String> responseAttributes) {
        TokenUsage tokenUsage = result.tokenUsage() != null ? new TokenUsage(result.tokenUsage().inputTokenCount(), result.tokenUsage().outputTokenCount(), result.tokenUsage().totalTokenCount()) : null;
        return ResponseHelper.createLLMResponse(response, tokenUsage, responseAttributes);
    }

    public static Result<InputStream, LLMResponseAttributes> createLLMResponse(String response, TokenUsage tokenUsage, Map<String, String> responseAttributes) {
        return Result.builder().attributes((Object)new LLMResponseAttributes(tokenUsage, (HashMap)responseAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, ScannedDocResponseAttributes> createLLMResponse(String response, List<ScannedDocResponseAttributes.DocResponseAttribute> docResponseAttributes, Map<String, String> responseAttributes) {
        return Result.builder().attributes((Object)new ScannedDocResponseAttributes((ArrayList)docResponseAttributes, (HashMap)responseAttributes)).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }

    public static Result<InputStream, Map<String, Object>> createLLMResponse(String response, Map<String, Object> responseAttributes) {
        return Result.builder().attributes(responseAttributes).attributesMediaType(MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8)).mediaType(MediaType.APPLICATION_JSON).build();
    }
}

