/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.operation;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.document.loader.FileSystemDocumentLoader;
import dev.langchain4j.data.document.loader.UrlDocumentLoader;
import dev.langchain4j.data.document.parser.TextDocumentParser;
import dev.langchain4j.data.document.parser.apache.tika.ApacheTikaDocumentParser;
import dev.langchain4j.data.document.splitter.DocumentSplitters;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageDeserializer;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.onnx.allminilml6v2.AllMiniLmL6V2EmbeddingModel;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.content.retriever.EmbeddingStoreContentRetriever;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.EmbeddingStoreIngestor;
import dev.langchain4j.store.embedding.inmemory.InMemoryEmbeddingStore;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mule.extension.mulechain.api.metadata.LLMResponseAttributes;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.error.MuleChainErrorType;
import org.mule.extension.mulechain.internal.error.provider.EmbeddingErrorTypeProvider;
import org.mule.extension.mulechain.internal.helpers.FileType;
import org.mule.extension.mulechain.internal.helpers.FileTypeParameters;
import org.mule.extension.mulechain.internal.helpers.ResponseHelper;
import org.mule.extension.mulechain.internal.tools.GenericRestApiTool;
import org.mule.extension.mulechain.internal.util.ExcludeFromGeneratedCoverage;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangchainEmbeddingStoresOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangchainEmbeddingStoresOperations.class);
    @ExcludeFromGeneratedCoverage
    private final EmbeddingModel embeddingModel = new AllMiniLmL6V2EmbeddingModel();
    private InMemoryEmbeddingStore<TextSegment> deserializedStore;

    private InMemoryEmbeddingStore<TextSegment> getDeserializedStore(String storeName, boolean getLatest) {
        if (this.deserializedStore == null || getLatest) {
            this.deserializedStore = InMemoryEmbeddingStore.fromFile((String)storeName);
        }
        return this.deserializedStore;
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="RAG-load-document")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> loadDocumentFile(@Config LangchainLLMConfiguration configuration, @Content String data, String contextPath, @ParameterGroup(name="Context") FileTypeParameters fileType) {
        try {
            LOGGER.debug("RAG Load Document Operation called with data: {}, file: {} & fileType: {}", new Object[]{data, contextPath, fileType.getFileType()});
            InMemoryEmbeddingStore embeddingStore = new InMemoryEmbeddingStore();
            EmbeddingStoreIngestor ingestor = EmbeddingStoreIngestor.builder().documentSplitter(DocumentSplitters.recursive((int)1000, (int)200, (Tokenizer)new OpenAiTokenizer())).embeddingModel(this.embeddingModel).embeddingStore((EmbeddingStore)embeddingStore).build();
            this.ingestDocument(fileType, contextPath, ingestor);
            LOGGER.debug("File successfully embedded into the in-memory embedding store");
            ChatLanguageModel model = configuration.getModel();
            EmbeddingStoreContentRetriever contentRetriever = new EmbeddingStoreContentRetriever((EmbeddingStore)embeddingStore, this.embeddingModel);
            AssistantSources assistant = (AssistantSources)AiServices.builder(AssistantSources.class).chatLanguageModel(model).contentRetriever((ContentRetriever)contentRetriever).build();
            dev.langchain4j.service.Result<String> answer = assistant.chat(data);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", answer.content());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("filePath", contextPath);
            attributes.put("fileType", fileType.getFileType());
            attributes.put("question", data);
            LOGGER.debug("RAG Load Document Operation completed with response: {}", answer.content());
            return ResponseHelper.createLLMResponse(jsonObject.toString(), answer, attributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Error while loading and retrieving content from the document " + contextPath, (ErrorTypeDefinition)MuleChainErrorType.RAG_FAILURE, (Throwable)e);
        }
    }

    private void ingestDocument(FileTypeParameters fileType, String contextPath, EmbeddingStoreIngestor ingestor) {
        Document document = null;
        switch (FileType.fromValue(fileType.getFileType())) {
            case TEXT: {
                document = FileSystemDocumentLoader.loadDocument((String)contextPath, (DocumentParser)new TextDocumentParser());
                ingestor.ingest(document);
                break;
            }
            case ANY: {
                document = FileSystemDocumentLoader.loadDocument((String)contextPath, (DocumentParser)new ApacheTikaDocumentParser());
                ingestor.ingest(document);
                break;
            }
            case URL: {
                URL url = null;
                try {
                    url = new URL(contextPath);
                }
                catch (MalformedURLException e) {
                    throw new ModuleException("Error while loading the document: " + contextPath, (ErrorTypeDefinition)MuleChainErrorType.FILE_HANDLING_FAILURE, (Throwable)e);
                }
                document = UrlDocumentLoader.load((URL)url, (DocumentParser)new TextDocumentParser());
                document.metadata().add("url", contextPath);
                ingestor.ingest(document);
                break;
            }
            default: {
                throw new ModuleException("Unsupported File Type: " + fileType.getFileType(), (ErrorTypeDefinition)MuleChainErrorType.FILE_HANDLING_FAILURE);
            }
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="CHAT-answer-prompt-with-memory")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> chatWithPersistentMemory(@Config LangchainLLMConfiguration configuration, @Content String data, String memoryName, String dbFilePath, int maxMessages) {
        try {
            LOGGER.debug("Chat Answer Prompt With Memory Operation called with userPrompt: {}, memoryName: {}, dbFilePath: {} & maxMessages: {}", new Object[]{data, memoryName, dbFilePath, maxMessages});
            ChatLanguageModel model = configuration.getModel();
            PersistentChatMemoryStore store = new PersistentChatMemoryStore(dbFilePath);
            ChatMemoryProvider chatMemoryProvider = memoryId -> MessageWindowChatMemory.builder().id((Object)memoryName).maxMessages(Integer.valueOf(maxMessages)).chatMemoryStore((ChatMemoryStore)store).build();
            AssistantMemory assistant = (AssistantMemory)AiServices.builder(AssistantMemory.class).chatLanguageModel(model).chatMemoryProvider(chatMemoryProvider).build();
            dev.langchain4j.service.Result<String> response = assistant.chat(memoryName, data);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", response.content());
            LOGGER.debug("Chat Answer Prompt With Memory Operation completed with response: {}", response.content());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("memoryName", memoryName);
            attributes.put("dbFilePath", dbFilePath);
            attributes.put("maxMessages", String.valueOf(maxMessages));
            return ResponseHelper.createLLMResponse(jsonObject.toString(), response, attributes);
        }
        catch (Exception e) {
            throw new ModuleException("Error while responding with the chat provided", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    private static List<String> extractUrls(String input) {
        String urlPattern = "(https?://\\S+\\b)";
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> urls = new ArrayList<String>();
        while (matcher.find()) {
            urls.add(matcher.group());
        }
        return urls.isEmpty() ? null : urls;
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-new-store")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/StatusResponse.json")
    public Result<InputStream, Map<String, Object>> createEmbedding(String storeName) {
        try {
            LOGGER.debug("Embedding New Store Operation called with the storeName: {}", (Object)storeName);
            InMemoryEmbeddingStore embeddingStore = new InMemoryEmbeddingStore();
            embeddingStore.serializeToFile(storeName);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", (Object)"created");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("storeName", storeName);
            LOGGER.debug("Embedding New Store Operation completed with {} creation", (Object)storeName);
            return ResponseHelper.createLLMResponse(jsonObject.toString(), attributes);
        }
        catch (Exception e) {
            throw new ModuleException("Error while creating new Embedding store: " + storeName, (ErrorTypeDefinition)MuleChainErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-add-document-to-store")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/StatusResponse.json")
    public Result<InputStream, Map<String, Object>> addFileEmbedding(String storeName, String contextPath, int maxSegmentSizeInChars, int maxOverlapSizeInChars, @ParameterGroup(name="Context") FileTypeParameters fileType) {
        try {
            LOGGER.debug("Embedding Add Document To Store Operation called with the storeName: {}, filePath: {} & fileType: {}", new Object[]{storeName, contextPath, fileType.getFileType()});
            InMemoryEmbeddingStore store = InMemoryEmbeddingStore.fromFile((String)storeName);
            EmbeddingStoreIngestor ingestor = EmbeddingStoreIngestor.builder().documentSplitter(DocumentSplitters.recursive((int)maxSegmentSizeInChars, (int)maxOverlapSizeInChars)).embeddingModel(this.embeddingModel).embeddingStore((EmbeddingStore)store).build();
            this.ingestDocument(fileType, contextPath, ingestor);
            store.serializeToFile(storeName);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", (Object)"updated");
            LOGGER.debug("File ({}) successfully ingested into the store: {}", (Object)contextPath, (Object)storeName);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("fileType", fileType.getFileType());
            attributes.put("filePath", contextPath);
            attributes.put("storeName", storeName);
            return ResponseHelper.createLLMResponse(jsonObject.toString(), attributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while adding document %s to the Embedding store %s", contextPath, storeName), (ErrorTypeDefinition)MuleChainErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-query-from-store")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, Map<String, Object>> queryFromEmbedding(String storeName, @Content String question, int maxResults, double minScore, boolean getLatest) {
        try {
            LOGGER.debug("Embedding Query from Store Operation called with storeName: {}, latestFetchRequired:{}, query: {}, minScore: {}, maxResults: {}", new Object[]{storeName, getLatest, question, minScore, maxResults});
            if (minScore == 0.0) {
                minScore = 0.7;
            }
            InMemoryEmbeddingStore<TextSegment> store = this.getDeserializedStore(storeName, getLatest);
            Embedding questionEmbedding = (Embedding)this.embeddingModel.embed(question).content();
            List relevantEmbeddings = store.findRelevant(questionEmbedding, maxResults, minScore);
            String information = relevantEmbeddings.stream().map(match -> ((TextSegment)match.embedded()).text()).collect(Collectors.joining("\n\n"));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", (Object)information);
            LOGGER.debug("Embedding Query from Store Operation completed with the information: {}", (Object)information);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("maxResults", maxResults);
            attributes.put("minScore", minScore);
            attributes.put("question", question);
            attributes.put("storeName", storeName);
            JSONArray sources = new JSONArray();
            for (EmbeddingMatch match2 : relevantEmbeddings) {
                Metadata matchMetadata = ((TextSegment)match2.embedded()).metadata();
                String fileName = matchMetadata.getString("file_name");
                String url = matchMetadata.getString("url");
                String fullPath = matchMetadata.getString("full_path");
                String absoluteDirectoryPath = matchMetadata.getString("absolute_directory_path");
                JSONObject contentObject = new JSONObject();
                contentObject.put("absoluteDirectoryPath", (Object)absoluteDirectoryPath);
                contentObject.put("fullPath", (Object)fullPath);
                contentObject.put("fileName", (Object)fileName);
                contentObject.put("url", (Object)url);
                contentObject.put("individualScore", (Object)match2.score());
                contentObject.put("textSegment", (Object)((TextSegment)match2.embedded()).text());
                sources.put((Object)contentObject);
            }
            LOGGER.debug("Sources for the information: {}", (Object)sources);
            jsonObject.put("sources", (Object)sources);
            return ResponseHelper.createLLMResponse(jsonObject.toString(), attributes);
        }
        catch (Exception e) {
            throw new ModuleException("Error while querying from the embedding store " + storeName, (ErrorTypeDefinition)MuleChainErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-get-info-from-store")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> promptFromEmbedding(@Config LangchainLLMConfiguration configuration, @Content String data, String storeName, boolean getLatest) {
        try {
            LOGGER.debug("Embedding Get info from Store Operation called with storeName: {}, latestFetchRequired:{} & query: {}", new Object[]{storeName, getLatest, data});
            InMemoryEmbeddingStore<TextSegment> store = this.getDeserializedStore(storeName, getLatest);
            ChatLanguageModel model = configuration.getModel();
            EmbeddingStoreContentRetriever contentRetriever = new EmbeddingStoreContentRetriever(store, this.embeddingModel);
            AssistantSources assistantSources = (AssistantSources)AiServices.builder(AssistantSources.class).chatLanguageModel(model).contentRetriever((ContentRetriever)contentRetriever).build();
            dev.langchain4j.service.Result<String> results = assistantSources.chat(data);
            List contents = results.sources();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", results.content());
            LOGGER.debug("Embedding Get info from Store Operation completed with response: {}", results.content());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("storeName", storeName);
            attributes.put("question", data);
            attributes.put("getLatest", String.valueOf(getLatest));
            JSONArray sources = new JSONArray();
            for (dev.langchain4j.rag.content.Content content : contents) {
                Metadata metadata = content.textSegment().metadata();
                String absoluteDirectoryPath = metadata.getString("absolute_directory_path");
                String fileName = metadata.getString("file_name");
                String url = metadata.getString("url");
                JSONObject contentObject = new JSONObject();
                contentObject.put("absoluteDirectoryPath", (Object)absoluteDirectoryPath);
                contentObject.put("fileName", (Object)fileName);
                contentObject.put("url", (Object)url);
                contentObject.put("textSegment", (Object)content.textSegment().text());
                sources.put((Object)contentObject);
            }
            jsonObject.put("sources", (Object)sources);
            LOGGER.debug("Sources for this information: {}", (Object)sources);
            return ResponseHelper.createLLMResponse(jsonObject.toString(), results, attributes);
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while getting info from the store %s", storeName), (ErrorTypeDefinition)MuleChainErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="TOOLS-use-ai-service")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> useAIServiceTools(@Config LangchainLLMConfiguration configuration, @Content String data, String toolConfig) {
        try {
            LOGGER.debug("Tools Use Ai Service Operation called with userPrompt: {}", (Object)data);
            LOGGER.debug("Tools Config: {}", (Object)toolConfig);
            InMemoryEmbeddingStore embeddingStore = new InMemoryEmbeddingStore();
            EmbeddingStoreIngestor ingestor = EmbeddingStoreIngestor.builder().documentSplitter(DocumentSplitters.recursive((int)30000, (int)200)).embeddingModel(this.embeddingModel).embeddingStore((EmbeddingStore)embeddingStore).build();
            Document document = FileSystemDocumentLoader.loadDocument((String)toolConfig, (DocumentParser)new TextDocumentParser());
            ingestor.ingest(document);
            ChatLanguageModel model = configuration.getModel();
            EmbeddingStoreContentRetriever contentRetriever = new EmbeddingStoreContentRetriever((EmbeddingStore)embeddingStore, this.embeddingModel);
            AssistantEmbeddingR assistant = (AssistantEmbeddingR)AiServices.builder(AssistantEmbeddingR.class).chatLanguageModel(model).contentRetriever((ContentRetriever)contentRetriever).build();
            AssistantEmbeddingChat assistantChat = (AssistantEmbeddingChat)AiServices.builder(AssistantEmbeddingChat.class).chatLanguageModel(model).build();
            dev.langchain4j.service.Result<String> intermediateAnswer = assistant.chat(data);
            LOGGER.debug("Intermediate Answer containing the request URLs: {}", intermediateAnswer.content());
            dev.langchain4j.service.Result<String> response = assistantChat.chat(data);
            List<String> findURLs = LangchainEmbeddingStoresOperations.extractUrls((String)intermediateAnswer.content());
            boolean toolsUsed = false;
            if (findURLs != null) {
                toolsUsed = true;
                GenericRestApiTool restApiTool = new GenericRestApiTool(findURLs.get(0), "API Call", "Execute GET or POST Requests");
                AssistantR assistantC = (AssistantR)AiServices.builder(AssistantR.class).chatLanguageModel(model).tools(new Object[]{restApiTool}).build();
                response = assistantC.chat((String)intermediateAnswer.content());
                LOGGER.debug("Response after Tools Usage: {}", response.content());
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", response.content());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("toolsUsed", String.valueOf(toolsUsed));
            LOGGER.debug("Tools Use Ai Service Operation completed with response: {}, toolsUsed: {}", response, (Object)toolsUsed);
            return ResponseHelper.createLLMResponse(jsonObject.toString(), response, attributes);
        }
        catch (Exception e) {
            throw new ModuleException("Error occurred while executing AI Tools with the provided config", (ErrorTypeDefinition)MuleChainErrorType.TOOLS_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="TOOLS-use-ai-native")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/ResponseTools.json")
    public Result<InputStream, LLMResponseAttributes> useNativeAIServiceTools(@Config LangchainLLMConfiguration configuration, @Content String data, InputStream toolsArray) {
        try {
            LOGGER.debug("Tools Use Ai Service Operation called with userPrompt: {}", (Object)data);
            LOGGER.debug("Tools Config: {}", (Object)toolsArray);
            JSONArray tools = LangchainEmbeddingStoresOperations.getInputString(toolsArray);
            List<ToolSpecification> toolsSpecs = LangchainEmbeddingStoresOperations.getTools(tools, configuration);
            ChatLanguageModel model = configuration.getModel();
            UserMessage userMessage = UserMessage.from((String)data);
            Response result = model.generate(Arrays.asList(userMessage), toolsSpecs);
            JSONObject jsonObject = new JSONObject();
            JSONArray toolExecutionRequests = new JSONArray();
            if (((AiMessage)result.content()).hasToolExecutionRequests()) {
                for (ToolExecutionRequest request : ((AiMessage)result.content()).toolExecutionRequests()) {
                    JSONObject itemJson = new JSONObject();
                    String id = request.id();
                    String name = request.name();
                    String arguments = request.arguments();
                    JSONObject argumentsJson = new JSONObject(arguments);
                    itemJson.put("id", (Object)id);
                    itemJson.put("name", (Object)name);
                    itemJson.put("arguments", (Object)argumentsJson);
                    toolExecutionRequests.put((Object)itemJson);
                }
                jsonObject.put("response", (Object)"Tools were used");
                jsonObject.put("toolExecutionRequests", (Object)toolExecutionRequests);
            } else {
                JSONObject itemJson = new JSONObject();
                itemJson.put("id", (Object)"-");
                itemJson.put("name", (Object)"-");
                itemJson.put("arguments", (Object)"-");
                toolExecutionRequests.put((Object)itemJson);
                jsonObject.put("response", (Object)((AiMessage)result.content()).text());
                jsonObject.put("toolExecutionRequests", (Object)toolExecutionRequests);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("toolsUsed", String.valueOf(((AiMessage)result.content()).hasToolExecutionRequests()));
            return ResponseHelper.createLLMResponse(jsonObject.toString(), result, attributes);
        }
        catch (Exception e) {
            throw new ModuleException("Error occurred while executing native AI Tools with the provided config", (ErrorTypeDefinition)MuleChainErrorType.TOOLS_OPERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-add-folder-to-store")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/StatusResponse.json")
    public Result<InputStream, Map<String, Object>> addFilesFromFolderEmbedding(String storeName, String contextPath, int maxSegmentSizeInChars, int maxOverlapSizeInChars, @ParameterGroup(name="Context") FileTypeParameters fileType) {
        try {
            LOGGER.debug("Embedding Add Folder To Store Operation called with storeName: {}, filePath: {} & fileType: {}", new Object[]{storeName, contextPath, fileType.getFileType()});
            InMemoryEmbeddingStore store = InMemoryEmbeddingStore.fromFile((String)storeName);
            EmbeddingStoreIngestor ingestor = EmbeddingStoreIngestor.builder().documentSplitter(DocumentSplitters.recursive((int)maxSegmentSizeInChars, (int)maxOverlapSizeInChars)).embeddingModel(this.embeddingModel).embeddingStore((EmbeddingStore)store).build();
            long totalFiles = this.getTotalFilesCount(contextPath);
            this.ingestFolder(contextPath, fileType, ingestor);
            store.serializeToFile(storeName);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", (Object)"updated");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("filesCount", totalFiles);
            attributes.put("folderPath", contextPath);
            attributes.put("storeName", storeName);
            LOGGER.debug("Embedding Add Folder To Store Operation completed successfully");
            return ResponseHelper.createLLMResponse(jsonObject.toString(), attributes);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Error while adding folder %s into the store %s", contextPath, storeName), (ErrorTypeDefinition)MuleChainErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    private long getTotalFilesCount(String contextPath) {
        long totalFiles = 0L;
        try (Stream<Path> paths = Files.walk(Paths.get(contextPath, new String[0]), new FileVisitOption[0]);){
            totalFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).count();
        }
        catch (IOException e) {
            LOGGER.error("Unable to load files in the path: " + contextPath, (Throwable)e);
        }
        LOGGER.info("Total number of files to process: {}", (Object)totalFiles);
        return totalFiles;
    }

    private void ingestFolder(String contextPath, FileTypeParameters fileType, EmbeddingStoreIngestor ingestor) {
        AtomicInteger fileCounter = new AtomicInteger(0);
        try (Stream<Path> paths = Files.walk(Paths.get(contextPath, new String[0]), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                int currentFileCounter = fileCounter.incrementAndGet();
                LOGGER.info("Processing file {}: {}", (Object)currentFileCounter, (Object)file.getFileName());
                Document document = null;
                try {
                    switch (FileType.fromValue(fileType.getFileType())) {
                        case TEXT: {
                            document = FileSystemDocumentLoader.loadDocument((String)file.toString(), (DocumentParser)new TextDocumentParser());
                            ingestor.ingest(document);
                            break;
                        }
                        case ANY: {
                            document = FileSystemDocumentLoader.loadDocument((String)file.toString(), (DocumentParser)new ApacheTikaDocumentParser());
                            ingestor.ingest(document);
                            break;
                        }
                        case URL: {
                            break;
                        }
                        default: {
                            throw new ModuleException("Unsupported File Type: " + fileType.getFileType(), (ErrorTypeDefinition)MuleChainErrorType.FILE_HANDLING_FAILURE);
                        }
                    }
                }
                catch (BlankDocumentException e) {
                    LOGGER.warn("Skipping file due to BlankDocumentException: {}", (Object)file.getFileName());
                }
            });
        }
        catch (IOException e) {
            throw new ModuleException("Exception occurred while loading files: " + contextPath, (ErrorTypeDefinition)MuleChainErrorType.FILE_HANDLING_FAILURE, (Throwable)e);
        }
    }

    private static JSONArray getInputString(InputStream inputString) throws IOException {
        int c;
        InputStreamReader reader = new InputStreamReader(inputString);
        StringBuilder inputStringBuilder = new StringBuilder();
        while ((c = reader.read()) != -1) {
            inputStringBuilder.append((char)c);
        }
        return new JSONArray(inputStringBuilder.toString());
    }

    private static List<ToolSpecification> getToolsMistral(JSONArray tools, LangchainLLMConfiguration configuration) {
        ArrayList<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
        for (int i = 0; i < tools.length(); ++i) {
            JSONObject functionEntry = tools.getJSONObject(i);
            JSONObject function = functionEntry.getJSONObject("function");
            String functionName = function.getString("name");
            String functionDescription = function.getString("description");
            JSONObject parameters = function.getJSONObject("parameters");
            JSONObject properties = parameters.getJSONObject("properties");
            HashMap propertiesMap = new HashMap();
            List<Object> requiredProperties = new ArrayList();
            for (String propertyName : properties.keySet()) {
                JSONObject propertyDetails = properties.getJSONObject(propertyName);
                HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                propertyMap.put("type", propertyDetails.getString("type"));
                propertyMap.put("description", propertyDetails.getString("description"));
                if (propertyDetails.has("enum")) {
                    propertyMap.put("enum", propertyDetails.getJSONArray("enum").toList());
                }
                propertiesMap.put(propertyName, propertyMap);
            }
            if (parameters.has("required")) {
                JSONArray requiredArray = parameters.getJSONArray("required");
                requiredProperties = requiredArray.toList().stream().map(Object::toString).collect(Collectors.toList());
            }
            ToolParameters toolParams = ToolParameters.builder().type("object").properties(propertiesMap).required(requiredProperties).build();
            ToolSpecification toolSpecification = ToolSpecification.builder().name(functionName).description(functionDescription).parameters(toolParams).build();
            toolSpecifications.add(toolSpecification);
        }
        return toolSpecifications;
    }

    private static List<ToolSpecification> getTools(JSONArray tools, LangchainLLMConfiguration configuration) {
        List<ToolSpecification> toolSpecifications = "MISTRAL_AI".equals(configuration.getLlmType()) ? LangchainEmbeddingStoresOperations.getToolsMistral(tools, configuration) : LangchainEmbeddingStoresOperations.getToolsGeneral(tools, configuration);
        return toolSpecifications;
    }

    private static List<ToolSpecification> getToolsGeneral(JSONArray tools, LangchainLLMConfiguration configuration) {
        ArrayList<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
        for (int i = 0; i < tools.length(); ++i) {
            JSONObject functionEntry = tools.getJSONObject(i);
            JSONObject function = functionEntry.getJSONObject("function");
            String functionName = function.getString("name");
            String functionDescription = function.getString("description");
            JSONObject parameters = function.getJSONObject("parameters");
            JSONObject properties = parameters.getJSONObject("properties");
            HashMap propertiesMap = new HashMap();
            for (String propertyName : properties.keySet()) {
                JSONObject propertyDetails = properties.getJSONObject(propertyName);
                HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                propertyMap.put("type", propertyDetails.getString("type"));
                propertyMap.put("description", propertyDetails.getString("description"));
                if (propertyDetails.has("enum")) {
                    propertyMap.put("enum", propertyDetails.getJSONArray("enum").toList());
                }
                ArrayList<String> requiredProperties = new ArrayList<String>();
                if (parameters.has("required")) {
                    JSONArray requiredArray = parameters.getJSONArray("required");
                    for (int j = 0; j < requiredArray.length(); ++j) {
                        requiredProperties.add(requiredArray.getString(j));
                    }
                }
                boolean isRequired = requiredProperties.contains(propertyName);
                propertyMap.put("required", isRequired);
                propertiesMap.put(propertyName, propertyMap);
            }
            ToolParameters toolParams = ToolParameters.builder().properties(propertiesMap).build();
            ToolSpecification toolSpecification = ToolSpecification.builder().name(functionName).description(functionDescription).parameters(toolParams).build();
            toolSpecifications.add(toolSpecification);
        }
        return toolSpecifications;
    }

    static interface AssistantEmbeddingChat {
        public dev.langchain4j.service.Result<String> chat(String var1);
    }

    static interface AssistantEmbeddingR {
        public dev.langchain4j.service.Result<String> chat(String var1);
    }

    static interface AssistantSources {
        public dev.langchain4j.service.Result<String> chat(String var1);
    }

    static interface AssistantR {
        public dev.langchain4j.service.Result<String> chat(String var1);
    }

    static class PersistentChatMemoryStore
    implements ChatMemoryStore {
        private final DB db;
        private final Map<String, String> map;

        public PersistentChatMemoryStore(String dbMFilePath) {
            this.db = DBMaker.fileDB((String)dbMFilePath).transactionEnable().fileLockDisable().make();
            this.map = this.db.hashMap("messages", (Serializer)Serializer.STRING, (Serializer)Serializer.STRING).createOrOpen();
        }

        public List<ChatMessage> getMessages(Object memoryId) {
            String json = this.map.get((String)memoryId);
            return ChatMessageDeserializer.messagesFromJson((String)json);
        }

        public void updateMessages(Object memoryId, List<ChatMessage> messages) {
            String json = ChatMessageSerializer.messagesToJson(messages);
            this.map.put((String)memoryId, json);
            this.db.commit();
        }

        public void deleteMessages(Object memoryId) {
            this.map.remove((String)memoryId);
            this.db.commit();
        }
    }

    static interface AssistantMemory {
        public dev.langchain4j.service.Result<String> chat(@MemoryId String var1, @dev.langchain4j.service.UserMessage String var2);
    }
}

