/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.operation;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiImageModel;
import dev.langchain4j.model.output.Response;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.api.metadata.LLMResponseAttributes;
import org.mule.extension.mulechain.api.metadata.ScannedDocResponseAttributes;
import org.mule.extension.mulechain.api.metadata.TokenUsage;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.error.MuleChainErrorType;
import org.mule.extension.mulechain.internal.error.provider.ImageErrorTypeProvider;
import org.mule.extension.mulechain.internal.helpers.ResponseHelper;
import org.mule.extension.mulechain.internal.llm.config.ConfigExtractor;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangchainImageModelsOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangchainImageModelsOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="IMAGE-read")
    @Throws(value={ImageErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> readFromImage(@Config LangchainLLMConfiguration configuration, @org.mule.runtime.extension.api.annotation.param.Content String data, String contextURL) {
        try {
            UserMessage userMessage;
            LOGGER.debug("Image Read Operation called with the prompt: {} & the url: {}", (Object)data, (Object)contextURL);
            ChatLanguageModel model = configuration.getModel();
            if (this.isURL(contextURL)) {
                userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)data), ImageContent.from((String)contextURL)});
            } else {
                String imagePath = contextURL;
                String imageBase64 = LangchainImageModelsOperations.convertToBase64String(imagePath);
                userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)data), ImageContent.from((String)imageBase64, (String)"image/png")});
            }
            Response response = model.generate(new ChatMessage[]{userMessage});
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", (Object)((AiMessage)response.content()).text());
            LOGGER.debug("Image Read Operation completed with the response: {}", (Object)((AiMessage)response.content()).text());
            return ResponseHelper.createLLMResponse(jsonObject.toString(), response, new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Unable to analyze the provided image %s with the text: %s", contextURL, data), (ErrorTypeDefinition)MuleChainErrorType.IMAGE_ANALYSIS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="IMAGE-generate")
    @Throws(value={ImageErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, Void> drawImage(@Config LangchainLLMConfiguration configuration, @org.mule.runtime.extension.api.annotation.param.Content String data) {
        try {
            LOGGER.debug("Image Generate Operation called with the prompt: {}", (Object)data);
            ConfigExtractor configExtractor = configuration.getConfigExtractor();
            OpenAiImageModel model = OpenAiImageModel.builder().modelName(configuration.getModelName()).apiKey(configExtractor.extractValue("OPENAI_API_KEY")).build();
            Response response = model.generate(data);
            LOGGER.info("Generated Image: {}", (Object)((Image)response.content()).url());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", (Object)((Image)response.content()).url());
            LOGGER.debug("Image Generate Operation completed successfully with the image: {}", (Object)((Image)response.content()).url());
            return Result.builder().attributesMediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JAVA).output((Object)IOUtils.toInputStream((String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8)).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON).build();
        }
        catch (Exception e) {
            throw new ModuleException("Error while generating the required image: " + data, (ErrorTypeDefinition)MuleChainErrorType.IMAGE_GENERATION_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="IMAGE-read-scanned-documents")
    @Throws(value={ImageErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/ScannedResponse.json")
    public Result<InputStream, ScannedDocResponseAttributes> readScannedDocumentPDF(@Config LangchainLLMConfiguration configuration, @org.mule.runtime.extension.api.annotation.param.Content String data, String filePath) {
        int totalPages;
        LOGGER.debug("Image Read Scanned Documents Operation called with the prompt: {} & filePath: {}", (Object)data, (Object)filePath);
        ChatLanguageModel model = configuration.getModel();
        JSONObject jsonObject = new JSONObject();
        JSONArray docPages = new JSONArray();
        ArrayList<ScannedDocResponseAttributes.DocResponseAttribute> docResponseAttributes = new ArrayList<ScannedDocResponseAttributes.DocResponseAttribute>();
        try (InputStream inputStream = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
             PDDocument document = PDDocument.load((InputStream)inputStream);){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            totalPages = document.getNumberOfPages();
            LOGGER.info("Total files to be converted -> {}", (Object)totalPages);
            for (int pageNumber = 0; pageNumber < totalPages; ++pageNumber) {
                BufferedImage image = pdfRenderer.renderImageWithDPI(pageNumber, 300.0f);
                LOGGER.debug("Reading page -> {}", (Object)pageNumber);
                String imageBase64 = this.convertToBase64String(image);
                UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)data), ImageContent.from((String)imageBase64, (String)"image/png")});
                Response response = model.generate(new ChatMessage[]{userMessage});
                JSONObject docPage = new JSONObject();
                docPage.put("page", pageNumber + 1);
                docPage.put("response", (Object)((AiMessage)response.content()).text());
                LOGGER.debug("Image Read Scanned Documents Operation completed with the response: {}", (Object)((AiMessage)response.content()).text());
                docResponseAttributes.add(new ScannedDocResponseAttributes.DocResponseAttribute(pageNumber + 1, new TokenUsage(response.tokenUsage().inputTokenCount(), response.tokenUsage().outputTokenCount(), response.tokenUsage().totalTokenCount())));
                docPages.put((Object)docPage);
            }
        }
        catch (IOException e) {
            throw new ModuleException("Error occurred while processing the document file: " + filePath, (ErrorTypeDefinition)MuleChainErrorType.FILE_HANDLING_FAILURE, (Throwable)e);
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(String.format("Unable to analyze the provided document %s with the text: %s", filePath, data), (ErrorTypeDefinition)MuleChainErrorType.IMAGE_ANALYSIS_FAILURE, (Throwable)e);
        }
        jsonObject.put("pages", (Object)docPages);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("totalPages", String.valueOf(totalPages));
        return ResponseHelper.createLLMResponse(jsonObject.toString(), docResponseAttributes, attributes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertToBase64String(BufferedImage image) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String base64String;
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byte[] imageBytes = outputStream.toByteArray();
            String string = base64String = Base64.getEncoder().encodeToString(imageBytes);
            return string;
        }
        catch (IOException e) {
            throw new ModuleException("Error occurred while processing the image", (ErrorTypeDefinition)MuleChainErrorType.IMAGE_PROCESSING_FAILURE, (Throwable)e);
        }
    }

    private boolean isURL(String fileNameFilter) {
        String urlPattern = "^(https?|ftp)://[^\\s/$.?#].[^\\s]*$";
        return fileNameFilter.matches(urlPattern);
    }

    private static String convertToBase64String(String filePath) {
        try {
            byte[] fileContent = Files.readAllBytes(new File(filePath).toPath());
            return Base64.getEncoder().encodeToString(fileContent);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

