/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.operation;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.UserMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.json.JSONObject;
import org.mule.extension.mulechain.api.metadata.LLMResponseAttributes;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.error.MuleChainErrorType;
import org.mule.extension.mulechain.internal.error.provider.AiServiceErrorTypeProvider;
import org.mule.extension.mulechain.internal.helpers.ResponseHelper;
import org.mule.extension.mulechain.internal.llm.type.ModerationModelType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangchainLLMOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangchainLLMOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="CHAT-answer-prompt")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> answerPromptByModelName(@Config LangchainLLMConfiguration configuration, @Content String prompt) {
        try {
            LOGGER.debug("Chat Answer Prompt Operation called with prompt: {}", (Object)prompt);
            ChatLanguageModel model = configuration.getModel();
            Assistant assistant = (Assistant)AiServices.create(Assistant.class, (ChatLanguageModel)model);
            dev.langchain4j.service.Result<String> answer = assistant.chat(prompt);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", answer.content());
            LOGGER.debug("Chat Answer Prompt Operation completed with response: {}", answer.content());
            return ResponseHelper.createLLMResponse(jsonObject.toString(), answer, new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ModuleException("Unable to respond with the chat provided", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-define-prompt-template")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> definePromptTemplate(@Config LangchainLLMConfiguration configuration, @Content(primary=true) String dataset, @Content String template, @Content String instructions) {
        try {
            LOGGER.debug("Agent Define Prompt Template Operation called with prompt: {}, template: {} & instruction: {}", new Object[]{dataset, template, instructions});
            ChatLanguageModel model = configuration.getModel();
            PromptTemplate promptTemplate = PromptTemplate.from((String)(template + System.lineSeparator() + "Instructions: {{instructions}}" + System.lineSeparator() + "Dataset: {{dataset}}"));
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("instructions", instructions);
            variables.put("dataset", dataset);
            Prompt prompt = promptTemplate.apply(variables);
            Assistant assistant = (Assistant)AiServices.create(Assistant.class, (ChatLanguageModel)model);
            dev.langchain4j.service.Result<String> answer = assistant.chat(prompt.text());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", answer.content());
            LOGGER.debug("Agent Define Prompt Template Operation completed with response: {}", answer.content());
            return ResponseHelper.createLLMResponse(jsonObject.toString(), answer, new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ModuleException("Unable to reply with the correct prompt template", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="SENTIMENT-analyze")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> extractSentiments(@Config LangchainLLMConfiguration configuration, @Content String data, boolean generateResponse) {
        LOGGER.debug("Sentiment Analyze Operation initiated with input data: {}", (Object)data);
        try {
            String chatResponse;
            ChatLanguageModel model = configuration.getModel();
            SentimentAnalyzer sentimentAnalyzer = (SentimentAnalyzer)AiServices.create(SentimentAnalyzer.class, (ChatLanguageModel)model);
            dev.langchain4j.service.Result<Double> sentimentResult = sentimentAnalyzer.analyzeSentimentOf(data);
            double sentimentScore = (Double)sentimentResult.content();
            LOGGER.info("Sentiment analyzed with score: {}", (Object)sentimentScore);
            Sentiment sentimentCategory = Sentiment.fromScore(sentimentScore);
            LOGGER.info("Mapped sentiment category: {}", (Object)sentimentCategory);
            String jsonResponse = this.createSentimentResponse(sentimentScore, sentimentCategory);
            if (generateResponse) {
                String chatPrompt = "Respond to the following input briefly:" + data;
                Result<InputStream, LLMResponseAttributes> chatResponseResult = this.answerPromptByModelName(configuration, chatPrompt);
                InputStream chatResponseStream = (InputStream)chatResponseResult.getOutput();
                chatResponse = this.convertInputStreamToString(chatResponseStream);
            } else {
                chatResponse = "N/A";
            }
            JSONObject combinedResponse = new JSONObject(jsonResponse);
            combinedResponse.put("chatResponse", (Object)chatResponse);
            return ResponseHelper.createLLMResponse(combinedResponse.toString(), sentimentResult, new HashMap<String, String>());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Invalid input provided for sentiment analysis: {}", (Object)ex.getMessage());
            throw new ModuleException("Invalid input for sentiment analysis", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.error("Error during sentiment analysis: {}", (Object)ex.getMessage(), (Object)ex);
            throw new ModuleException("Failed to analyze sentiment", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)ex);
        }
    }

    private String convertInputStreamToString(InputStream inputStream) throws IOException {
        String line;
        StringBuilder resultStringBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            resultStringBuilder.append(line);
        }
        return resultStringBuilder.toString();
    }

    private String createSentimentResponse(double sentimentScore, Sentiment sentimentCategory) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("sentimentScore", sentimentScore);
        jsonResponse.put("sentimentCategory", (Object)sentimentCategory.name());
        return jsonResponse.toString();
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Toxicity-detection")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> moderateInput(@Config LangchainLLMConfiguration configuration, String input) {
        try {
            JSONObject resultObject = ModerationModelType.moderationType(input, configuration);
            String response = LangchainLLMOperations.executeREST(resultObject.getString("url"), resultObject.getString("apiKey"), resultObject.getJSONObject("payload").toString());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", (Object)new JSONObject(response));
            LOGGER.debug("Toxicity detection result {}", (Object)response);
            dev.langchain4j.service.Result answer = dev.langchain4j.service.Result.builder().content((Object)response).tokenUsage(null).build();
            return ResponseHelper.createLLMResponse(jsonObject.toString(), answer, new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ModuleException("Unable to perform toxicity detection", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    private static HttpURLConnection getConnectionObject(URL url, String apiKey) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Authorization", "Bearer " + apiKey);
        conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        return conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String executeREST(String urlString, String apiKey, String payload) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = LangchainLLMOperations.getConnectionObject(url, apiKey);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = payload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) return "Error: " + responseCode;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                String string = response.toString();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Exception occurred: " + e.getMessage();
        }
    }

    static interface SentimentAnalyzer {
        @UserMessage(value={"Analyze sentiment of {{it}}"})
        public dev.langchain4j.service.Result<Double> analyzeSentimentOf(String var1);
    }

    static enum Sentiment {
        VERY_POSITIVE(0.75, 1.0),
        POSITIVE(0.5, 0.75),
        SLIGHTLY_POSITIVE(0.1, 0.5),
        NEUTRAL(-0.1, 0.1),
        SLIGHTLY_NEGATIVE(-0.5, -0.1),
        NEGATIVE(-0.75, -0.5),
        VERY_NEGATIVE(-1.0, -0.75);

        private final double lowerBound;
        private final double upperBound;

        private Sentiment(double lowerBound, double upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public static Sentiment fromScore(double score) {
            for (Sentiment sentiment : Sentiment.values()) {
                if (!(score >= sentiment.lowerBound) || !(score <= sentiment.upperBound)) continue;
                return sentiment;
            }
            return NEUTRAL;
        }
    }

    static interface Assistant {
        public dev.langchain4j.service.Result<String> chat(String var1);
    }
}

