/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.tools;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRestApiTool
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRestApiTool.class);
    private final String apiEndpoint;
    private final String name;
    private final String description;

    public GenericRestApiTool(String apiEndpoint, String name, String description) {
        this.apiEndpoint = apiEndpoint;
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Tool(value={"Execute POST requests for API endpoints."})
    public String execute(@P(value="Input contains the URL for this request") String input, @P(value="The method for the API. Support only POST") String method, @P(value="The authorization header value for the request") String authHeader, @P(value="The payload for the API, doublequotes must be masked") String payload) {
        try {
            LOGGER.info(method);
            StringBuilder urlBuilder = new StringBuilder(this.apiEndpoint);
            LOGGER.debug("URL {}", (Object)urlBuilder);
            LOGGER.debug("input {}", (Object)input);
            LOGGER.debug("Method {}", (Object)method);
            LOGGER.info("payload {}", (Object)payload);
            if (method == null) {
                method = "GET";
            }
            LOGGER.info("apiEndpoint-{}", (Object)this.apiEndpoint);
            URL url = new URL(urlBuilder.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method.toUpperCase());
            conn.setRequestProperty("Authorization", authHeader);
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("Accept", "application/json");
            if ("POST".equalsIgnoreCase(method) && payload != null && !payload.isEmpty()) {
                LOGGER.info("POST");
                conn.setDoOutput(true);
                byte[] inputBytes = payload.getBytes(StandardCharsets.UTF_8);
                try (OutputStream os = conn.getOutputStream();){
                    os.write(inputBytes, 0, inputBytes.length);
                }
            }
            int responseCode = conn.getResponseCode();
            LOGGER.info("Response code: {}", (Object)responseCode);
            if (responseCode == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                String value = sb.toString();
                LOGGER.info("Response received: {}", (Object)value);
                return value;
            }
            LOGGER.info("Response code received: {}", (Object)responseCode);
            return "Error: Received response code " + responseCode;
        }
        catch (IOException e) {
            LOGGER.warn("Error while executing POST requests for tool: ", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    @Tool(value={"Execute GET requests for API endpoints."})
    public String execute(@P(value="Input contains the URL for this request") String input, @P(value="The authorization header value for the request") String authHeader) {
        return this.execute(input, "GET", authHeader, null);
    }

    public Class<? extends Annotation> annotationType() {
        return null;
    }

    public String name() {
        return null;
    }

    public String[] value() {
        return new String[0];
    }
}

