/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.tools;

import dev.langchain4j.agent.tool.Tool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.mule.extension.mulechain.internal.util.ExcludeFromGeneratedCoverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExcludeFromGeneratedCoverage
public class RestApiTool
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiTool.class);
    private final String apiEndpoint;
    private final String name;
    private final String description;

    public RestApiTool(String apiEndpoint, String name, String description) {
        this.apiEndpoint = apiEndpoint;
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Tool(value={"Check inventory for MULETEST0"})
    public String execute(String input) {
        try {
            StringBuilder urlBuilder = new StringBuilder(this.apiEndpoint);
            URL url = new URL(urlBuilder.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("Accept", "application/json");
            String payload = "{\n \"materialNo\": \"MULETEST0\"}";
            LOGGER.info("Using tools");
            LOGGER.info(payload);
            LOGGER.info("URL: {}", (Object)url);
            conn.setDoOutput(true);
            byte[] inputBytes = payload.getBytes(StandardCharsets.UTF_8);
            try (OutputStream os = conn.getOutputStream();){
                os.write(inputBytes, 0, inputBytes.length);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                LOGGER.info("200");
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                return sb.toString();
            }
            LOGGER.info("Response Code: {}", (Object)responseCode);
            return "Error: Received response code " + responseCode;
        }
        catch (IOException e) {
            LOGGER.warn("Error while executing requests for tool: ", (Throwable)e);
            return "Error: " + e.getMessage();
        }
    }

    public Class<? extends Annotation> annotationType() {
        return null;
    }

    public String name() {
        return null;
    }

    public String[] value() {
        return new String[0];
    }
}

