/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class AwsbedrockChatMemory {
    private DB db;
    private Map<Long, String> chatMap;

    public AwsbedrockChatMemory(String dbFile, String memoryName) {
        this.db = DBMaker.fileDB((File)new File(dbFile)).transactionEnable().fileLockDisable().make();
        this.chatMap = this.db.hashMap(memoryName).keySerializer((Serializer)Serializer.LONG).valueSerializer((Serializer)Serializer.STRING).createOrOpen();
    }

    public void addMessage(long messageId, String messageContent) {
        this.chatMap.put(messageId, messageContent);
        this.db.commit();
    }

    public void deleteMessage(long messageId) {
        this.chatMap.remove(messageId);
        this.db.commit();
    }

    public void deleteAllMessages() {
        this.chatMap.clear();
        this.db.commit();
    }

    public String getMessage(long messageId) {
        return this.chatMap.get(messageId);
    }

    public int getMessageCount() {
        return this.chatMap.size();
    }

    public List<String> getAllMessages() {
        return new ArrayList<String>(this.chatMap.values());
    }

    public List<String> getAllMessagesByMessageIdDesc() {
        ArrayList<Long> messageIds = new ArrayList<Long>(this.chatMap.keySet());
        messageIds.sort(Comparator.reverseOrder());
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iterator = messageIds.iterator();
        while (iterator.hasNext()) {
            long messageId = (Long)iterator.next();
            messages.add(this.chatMap.get(messageId));
        }
        return messages;
    }

    public List<String> getAllMessagesByMessageIdAsc() {
        ArrayList<Long> messageIds = new ArrayList<Long>(this.chatMap.keySet());
        messageIds.sort(Comparator.naturalOrder());
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iterator = messageIds.iterator();
        while (iterator.hasNext()) {
            long messageId = (Long)iterator.next();
            messages.add(this.chatMap.get(messageId));
        }
        return messages;
    }

    public void close() {
        this.db.close();
    }
}

