/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.helpers.AwsbedrockChatMemory;
import org.mule.extension.mulechain.helpers.AwsbedrockPayloadHelper;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.AwsbedrockParameters;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AwsbedrockChatMemoryHelper {
    private static BedrockRuntimeClient createClient(AwsBasicCredentials awsCreds, Region region) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).region(region)).build();
    }

    private static BedrockRuntimeClient createClientSession(AwsSessionCredentials awsCreds, Region region) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).region(region)).build();
    }

    private static InvokeModelRequest createInvokeRequest(String modelId, String nativeRequest) {
        return (InvokeModelRequest)InvokeModelRequest.builder().body(SdkBytes.fromUtf8String((String)nativeRequest)).modelId(modelId).build();
    }

    private static String getAmazonTitanText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("inputText", (Object)prompt);
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        textGenerationConfig.put("topP", (Object)awsBedrockParameters.getTopP());
        textGenerationConfig.put("maxTokenCount", (Object)awsBedrockParameters.getMaxTokenCount());
        jsonRequest.put("textGenerationConfig", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAmazonNovaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject textObject = new JSONObject();
        textObject.put("text", (Object)prompt);
        JSONArray contentArray = new JSONArray();
        contentArray.put((Object)textObject);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)contentArray);
        JSONArray messagesArray = new JSONArray();
        messagesArray.put((Object)userMessage);
        JSONObject inferenceConfig = new JSONObject();
        inferenceConfig.put("max_new_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        inferenceConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        inferenceConfig.put("top_p", (Object)awsBedrockParameters.getTopP());
        inferenceConfig.put("top_k", (Object)awsBedrockParameters.getTopK());
        JSONObject rootObject = new JSONObject();
        rootObject.put("messages", (Object)messagesArray);
        rootObject.put("inferenceConfig", (Object)inferenceConfig);
        return rootObject.toString();
    }

    private static String getStabilityTitanText(String prompt) {
        JSONObject jsonRequest = new JSONObject();
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("text", (Object)prompt);
        jsonRequest.put("text_prompts", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAnthropicClaudeText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("top_k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens_to_sample", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getMistralAIText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("top_k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getAI21Text(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("topP", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("maxTokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getCohereText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getLlamaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("max_gen_len", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String identifyPayload(String prompt, AwsbedrockParameters awsBedrockParameters) {
        if (awsBedrockParameters.getModelName().contains("amazon.titan-text")) {
            return AwsbedrockChatMemoryHelper.getAmazonTitanText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("amazon.nova")) {
            return AwsbedrockChatMemoryHelper.getAmazonNovaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("anthropic.claude")) {
            return AwsbedrockChatMemoryHelper.getAnthropicClaudeText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("ai21.j2")) {
            return AwsbedrockChatMemoryHelper.getAI21Text(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.mistral")) {
            return AwsbedrockChatMemoryHelper.getMistralAIText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("cohere.command")) {
            return AwsbedrockChatMemoryHelper.getCohereText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("meta.llama")) {
            return AwsbedrockChatMemoryHelper.getLlamaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.")) {
            return AwsbedrockChatMemoryHelper.getLlamaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.")) {
            return AwsbedrockChatMemoryHelper.getStabilityTitanText(prompt);
        }
        return "Unsupported model";
    }

    private static BedrockRuntimeClient InitiateClient(AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        if (configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty()) {
            AwsBasicCredentials awsCredsBasic = AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey());
            return AwsbedrockChatMemoryHelper.createClient(awsCredsBasic, AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()));
        }
        AwsSessionCredentials awsCredsSession = AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
        return AwsbedrockChatMemoryHelper.createClientSession(awsCredsSession, AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()));
    }

    private static AwsbedrockChatMemory intializeChatMemory(String memoryPath, String memoryName) {
        return new AwsbedrockChatMemory(memoryPath, memoryName);
    }

    private static List<String> getKeepLastMessage(AwsbedrockChatMemory chatMemory, Integer keepLastMessages) {
        List<String> messagesAsc = chatMemory.getAllMessagesByMessageIdAsc();
        if (messagesAsc.size() > keepLastMessages) {
            messagesAsc = messagesAsc.subList(messagesAsc.size() - keepLastMessages, messagesAsc.size());
        }
        return messagesAsc;
    }

    private static void addMessageToMemory(AwsbedrockChatMemory chatMemory, String prompt) {
        if (!AwsbedrockChatMemoryHelper.isQuestion(prompt)) {
            chatMemory.addMessage(chatMemory.getMessageCount() + 1, prompt);
        }
    }

    private static boolean isQuestion(String message) {
        if (message.trim().endsWith("?")) {
            return true;
        }
        String[] questionWords = new String[]{"who", "what", "when", "where", "why", "how", "tell", "tell me", "do you"};
        String lowerCaseMessage = message.trim().toLowerCase();
        for (String questionWord : questionWords) {
            if (!lowerCaseMessage.startsWith(questionWord + " ")) continue;
            return true;
        }
        return false;
    }

    private static String formatMemoryPrompt(List<String> messages) {
        StringBuilder formattedPrompt = new StringBuilder();
        for (String message : messages) {
            formattedPrompt.append(message).append("\n");
        }
        return formattedPrompt.toString().trim();
    }

    public static String invokeModel(String prompt, String memoryPath, String memoryName, Integer keepLastMessages, AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        BedrockRuntimeClient client = AwsbedrockChatMemoryHelper.InitiateClient(configuration, awsBedrockParameters);
        AwsbedrockChatMemory chatMemory = AwsbedrockChatMemoryHelper.intializeChatMemory(memoryPath, memoryName);
        List<String> keepLastMessagesList = AwsbedrockChatMemoryHelper.getKeepLastMessage(chatMemory, keepLastMessages);
        keepLastMessagesList.add(prompt);
        String memoryPrompt = AwsbedrockChatMemoryHelper.formatMemoryPrompt(keepLastMessagesList);
        String nativeRequest = AwsbedrockChatMemoryHelper.identifyPayload(memoryPrompt, awsBedrockParameters);
        AwsbedrockChatMemoryHelper.addMessageToMemory(chatMemory, prompt);
        try {
            InvokeModelRequest request = AwsbedrockChatMemoryHelper.createInvokeRequest(awsBedrockParameters.getModelName(), nativeRequest);
            InvokeModelResponse response = client.invokeModel(request);
            JSONObject responseBody = new JSONObject(response.body().asUtf8String());
            return responseBody.toString();
        }
        catch (SdkClientException e) {
            System.err.printf("ERROR: Can't invoke '%s'. Reason: %s", awsBedrockParameters.getModelName(), e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

