/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.AwsbedrockParameters;
import org.mule.extension.mulechain.internal.AwsbedrockParams;
import org.mule.extension.mulechain.internal.AwsbedrockParamsModelDetails;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.BedrockClientBuilder;
import software.amazon.awssdk.services.bedrock.model.CustomModelSummary;
import software.amazon.awssdk.services.bedrock.model.FoundationModelDetails;
import software.amazon.awssdk.services.bedrock.model.FoundationModelSummary;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ValidationException;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AwsbedrockPayloadHelper {
    private static BedrockRuntimeClient createClient(AwsBasicCredentials awsCreds, Region region) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).region(region)).build();
    }

    private static BedrockRuntimeClient createClientSession(AwsSessionCredentials awsCreds, Region region) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).region(region)).build();
    }

    private static InvokeModelRequest createInvokeRequest(String modelId, String nativeRequest) {
        return (InvokeModelRequest)InvokeModelRequest.builder().body(SdkBytes.fromUtf8String((String)nativeRequest)).modelId(modelId).build();
    }

    public static Region getRegion(String region) {
        switch (region) {
            case "us-east-1": {
                return Region.US_EAST_1;
            }
            case "us-east-2": {
                return Region.US_EAST_2;
            }
            case "us-west-1": {
                return Region.US_WEST_1;
            }
            case "us-west-2": {
                return Region.US_WEST_2;
            }
            case "af-south-1": {
                return Region.AF_SOUTH_1;
            }
            case "ap-east-1": {
                return Region.AP_EAST_1;
            }
            case "ap-south-1": {
                return Region.AP_SOUTH_1;
            }
            case "ap-south-2": {
                return Region.AP_SOUTH_2;
            }
            case "ap-southeast-1": {
                return Region.AP_SOUTHEAST_1;
            }
            case "ap-southeast-2": {
                return Region.AP_SOUTHEAST_2;
            }
            case "ap-southeast-3": {
                return Region.AP_SOUTHEAST_3;
            }
            case "ap-southeast-4": {
                return Region.AP_SOUTHEAST_4;
            }
            case "ap-northeast-1": {
                return Region.AP_NORTHEAST_1;
            }
            case "ap-northeast-2": {
                return Region.AP_NORTHEAST_2;
            }
            case "ap-northeast-3": {
                return Region.AP_NORTHEAST_3;
            }
            case "ca-central-1": {
                return Region.CA_CENTRAL_1;
            }
            case "eu-central-1": {
                return Region.EU_CENTRAL_1;
            }
            case "eu-central-2": {
                return Region.EU_CENTRAL_2;
            }
            case "eu-west-1": {
                return Region.EU_WEST_1;
            }
            case "eu-west-2": {
                return Region.EU_WEST_2;
            }
            case "eu-west-3": {
                return Region.EU_WEST_3;
            }
            case "eu-north-1": {
                return Region.EU_NORTH_1;
            }
            case "eu-south-1": {
                return Region.EU_SOUTH_1;
            }
            case "eu-south-2": {
                return Region.EU_SOUTH_2;
            }
            case "me-south-1": {
                return Region.ME_SOUTH_1;
            }
            case "me-central-1": {
                return Region.ME_CENTRAL_1;
            }
            case "sa-east-1": {
                return Region.SA_EAST_1;
            }
            case "us-gov-east-1": {
                return Region.US_GOV_EAST_1;
            }
            case "us-gov-west-1": {
                return Region.US_GOV_WEST_1;
            }
        }
        throw new IllegalArgumentException("Unknown region: " + region);
    }

    private static String getAmazonTitanText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("inputText", (Object)prompt);
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        textGenerationConfig.put("topP", (Object)awsBedrockParameters.getTopP());
        textGenerationConfig.put("maxTokenCount", (Object)awsBedrockParameters.getMaxTokenCount());
        jsonRequest.put("textGenerationConfig", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAmazonNovaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject textObject = new JSONObject();
        textObject.put("text", (Object)prompt);
        JSONArray contentArray = new JSONArray();
        contentArray.put((Object)textObject);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)contentArray);
        JSONArray messagesArray = new JSONArray();
        messagesArray.put((Object)userMessage);
        JSONObject inferenceConfig = new JSONObject();
        inferenceConfig.put("max_new_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        inferenceConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        inferenceConfig.put("top_p", (Object)awsBedrockParameters.getTopP());
        inferenceConfig.put("top_k", (Object)awsBedrockParameters.getTopK());
        JSONObject rootObject = new JSONObject();
        rootObject.put("messages", (Object)messagesArray);
        rootObject.put("inferenceConfig", (Object)inferenceConfig);
        return rootObject.toString();
    }

    private static String getStabilityTitanText(String prompt) {
        JSONObject jsonRequest = new JSONObject();
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("text", (Object)prompt);
        jsonRequest.put("text_prompts", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAnthropicClaudeText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("top_k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens_to_sample", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getMistralAIText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getAI21Text(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("topP", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("maxTokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getCohereText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getLlamaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("max_gen_len", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String identifyPayload(String prompt, AwsbedrockParameters awsBedrockParameters) {
        if (awsBedrockParameters.getModelName().contains("amazon.titan-text")) {
            return AwsbedrockPayloadHelper.getAmazonTitanText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("amazon.nova")) {
            System.out.println("Generating payload for nova");
            return AwsbedrockPayloadHelper.getAmazonNovaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("anthropic.claude")) {
            return AwsbedrockPayloadHelper.getAnthropicClaudeText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("ai21.j2")) {
            return AwsbedrockPayloadHelper.getAI21Text(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.mistral")) {
            return AwsbedrockPayloadHelper.getMistralAIText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("cohere.command")) {
            return AwsbedrockPayloadHelper.getCohereText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("meta.llama")) {
            return AwsbedrockPayloadHelper.getLlamaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("stability.stable")) {
            return AwsbedrockPayloadHelper.getStabilityTitanText(prompt);
        }
        return "Unsupported model";
    }

    private static BedrockRuntimeClient InitiateClient(AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        if (configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty()) {
            AwsBasicCredentials awsCredsBasic = AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey());
            return AwsbedrockPayloadHelper.createClient(awsCredsBasic, AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()));
        }
        AwsSessionCredentials awsCredsSession = AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
        return AwsbedrockPayloadHelper.createClientSession(awsCredsSession, AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()));
    }

    public static String invokeModel(String prompt, AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        BedrockRuntimeClient client = AwsbedrockPayloadHelper.InitiateClient(configuration, awsBedrockParameters);
        String nativeRequest = AwsbedrockPayloadHelper.identifyPayload(prompt, awsBedrockParameters);
        try {
            InvokeModelRequest request = AwsbedrockPayloadHelper.createInvokeRequest(awsBedrockParameters.getModelName(), nativeRequest);
            System.out.println("Native request: " + nativeRequest);
            InvokeModelResponse response = client.invokeModel(request);
            JSONObject responseBody = new JSONObject(response.body().asUtf8String());
            return responseBody.toString();
        }
        catch (SdkClientException e) {
            System.err.printf("ERROR: Can't invoke '%s'. Reason: %s", awsBedrockParameters.getModelName(), e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static BedrockClient createBedrockClient(AwsbedrockConfiguration configuration, AwsbedrockParams awsBedrockParameters) {
        Object awsCredentials = configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty() ? AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey()) : AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
        BedrockClient bedrockClient = (BedrockClient)((BedrockClientBuilder)((BedrockClientBuilder)BedrockClient.builder().region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).build();
        return bedrockClient;
    }

    private static BedrockClient createBedrockClientDetails(AwsbedrockConfiguration configuration, AwsbedrockParamsModelDetails awsBedrockParameters) {
        Object awsCredentials = configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty() ? AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey()) : AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
        BedrockClient bedrockClient = (BedrockClient)((BedrockClientBuilder)((BedrockClientBuilder)BedrockClient.builder().region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).build();
        return bedrockClient;
    }

    public static String getFoundationModel(AwsbedrockConfiguration configuration, AwsbedrockParamsModelDetails awsBedrockParameters) {
        BedrockClient bedrockClient = AwsbedrockPayloadHelper.createBedrockClientDetails(configuration, awsBedrockParameters);
        try {
            GetFoundationModelResponse response = bedrockClient.getFoundationModel((GetFoundationModelRequest)GetFoundationModelRequest.builder().modelIdentifier(awsBedrockParameters.getModelName()).build());
            FoundationModelDetails model = response.modelDetails();
            JSONObject jsonModel = new JSONObject();
            jsonModel.put("modelId", (Object)model.modelId());
            jsonModel.put("modelArn", (Object)model.modelArn());
            jsonModel.put("modelName", (Object)model.modelName());
            jsonModel.put("providerName", (Object)model.providerName());
            jsonModel.put("modelLifecycleStatus", (Object)model.modelLifecycle().statusAsString());
            jsonModel.put("inputModalities", (Collection)model.inputModalities());
            jsonModel.put("outputModalities", (Collection)model.outputModalities());
            jsonModel.put("customizationsSupported", (Collection)model.customizationsSupported());
            jsonModel.put("inferenceTypesSupported", (Collection)model.inferenceTypesSupported());
            jsonModel.put("responseStreamingSupported", (Object)model.responseStreamingSupported());
            return jsonModel.toString();
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SdkException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String listFoundationModels(AwsbedrockConfiguration configuration, AwsbedrockParams awsBedrockParameters) {
        BedrockClient bedrockClient = AwsbedrockPayloadHelper.createBedrockClient(configuration, awsBedrockParameters);
        try {
            ListFoundationModelsResponse response = bedrockClient.listFoundationModels(r -> {});
            List models = response.modelSummaries();
            System.out.println(response.toString());
            System.out.println(models.toString());
            JSONArray modelsArray = new JSONArray();
            if (models.isEmpty()) {
                System.out.println("No available foundation models");
            } else {
                for (FoundationModelSummary model : models) {
                    JSONObject modelJson = new JSONObject();
                    modelJson.put("modelId", (Object)model.modelId());
                    modelJson.put("modelName", (Object)model.providerName());
                    modelJson.put("provider", (Object)model.modelName());
                    modelJson.put("modelArn", (Object)model.modelArn());
                    modelJson.put("modelLifecycleStatus", (Object)model.modelLifecycle().statusAsString());
                    modelJson.put("inputModalities", (Collection)model.inputModalities());
                    modelJson.put("outputModalities", (Collection)model.outputModalities());
                    modelJson.put("customizationsSupported", (Collection)model.customizationsSupported());
                    modelJson.put("inferenceTypesSupported", (Collection)model.inferenceTypesSupported());
                    modelJson.put("responseStreamingSupported", (Object)model.responseStreamingSupported());
                    modelsArray.put((Object)modelJson);
                }
            }
            return modelsArray.toString();
        }
        catch (SdkClientException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String listCustomModels(AwsbedrockConfiguration configuration, AwsbedrockParams awsBedrockParameters) {
        BedrockClient bedrockClient = AwsbedrockPayloadHelper.createBedrockClient(configuration, awsBedrockParameters);
        try {
            ListCustomModelsResponse response = bedrockClient.listCustomModels(r -> {});
            List models = response.modelSummaries();
            System.out.println(response.toString());
            System.out.println(models.toString());
            JSONArray modelsArray = new JSONArray();
            if (models.isEmpty()) {
                System.out.println("No available foundation models.");
            } else {
                for (CustomModelSummary model : models) {
                    JSONObject modelJson = new JSONObject();
                    modelJson.put("provider", (Object)model.modelName());
                    modelJson.put("modelArn", (Object)model.modelArn());
                    modelJson.put("baseModelArn", (Object)model.baseModelArn());
                    modelJson.put("baseModelName", (Object)model.baseModelName());
                    modelJson.put("customizationType", (Object)model.customizationTypeAsString());
                    modelsArray.put((Object)modelJson);
                }
            }
            return modelsArray.toString();
        }
        catch (SdkClientException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String getCustomModel(AwsbedrockConfiguration configuration, AwsbedrockParamsModelDetails awsBedrockParameters) {
        BedrockClient bedrockClient = AwsbedrockPayloadHelper.createBedrockClientDetails(configuration, awsBedrockParameters);
        try {
            GetCustomModelResponse response = bedrockClient.getCustomModel((GetCustomModelRequest)GetCustomModelRequest.builder().modelIdentifier(awsBedrockParameters.getModelName()).build());
            JSONObject jsonModel = new JSONObject();
            jsonModel.put("modelArn", (Object)response.modelArn());
            jsonModel.put("modelName", (Object)response.modelName());
            jsonModel.put("jobName", (Object)response.jobName());
            jsonModel.put("jobArn", (Object)response.jobArn());
            jsonModel.put("customizationTypeAsString", (Object)response.customizationTypeAsString());
            jsonModel.put("baseModelArn", (Object)response.baseModelArn());
            jsonModel.put("hyperParameters", response.hyperParameters());
            jsonModel.put("hasHyperParameters", response.hasHyperParameters());
            jsonModel.put("hasValidationMetrics", response.hasValidationMetrics());
            return jsonModel.toString();
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SdkException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

