/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class AwsbedrockChatMemory {
    private MVStore store;
    private MVMap<Long, String> chatMap;

    public AwsbedrockChatMemory(String dbFile, String memoryName) {
        this.store = MVStore.open((String)dbFile);
        this.chatMap = this.store.openMap(memoryName);
    }

    public void addMessage(long messageId, String messageContent) {
        this.chatMap.put((Object)messageId, (Object)messageContent);
        this.store.commit();
    }

    public void deleteMessage(long messageId) {
        this.chatMap.remove((Object)messageId);
        this.store.commit();
    }

    public void deleteAllMessages() {
        this.chatMap.clear();
        this.store.commit();
    }

    public String getMessage(long messageId) {
        return (String)this.chatMap.get((Object)messageId);
    }

    public int getMessageCount() {
        return this.chatMap.size();
    }

    public List<String> getAllMessages() {
        return new ArrayList<String>(this.chatMap.values());
    }

    public List<String> getAllMessagesByMessageIdDesc() {
        ArrayList messageIds = new ArrayList(this.chatMap.keySet());
        messageIds.sort(Comparator.reverseOrder());
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iterator = messageIds.iterator();
        while (iterator.hasNext()) {
            long messageId = (Long)iterator.next();
            messages.add((String)this.chatMap.get((Object)messageId));
        }
        return messages;
    }

    public List<String> getAllMessagesByMessageIdAsc() {
        ArrayList messageIds = new ArrayList(this.chatMap.keySet());
        messageIds.sort(Comparator.naturalOrder());
        ArrayList<String> messages = new ArrayList<String>();
        Iterator iterator = messageIds.iterator();
        while (iterator.hasNext()) {
            long messageId = (Long)iterator.next();
            messages.add((String)this.chatMap.get((Object)messageId));
        }
        return messages;
    }

    public void close() {
        this.store.close();
    }
}

