/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.helpers.AwsbedrockPayloadHelper;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.AwsbedrockParameters;
import org.mule.extension.mulechain.internal.agents.AwsbedrockAgentsParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.BedrockClientBuilder;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClientBuilder;
import software.amazon.awssdk.services.bedrockagent.model.Agent;
import software.amazon.awssdk.services.bedrockagent.model.AgentAlias;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary;
import software.amazon.awssdk.services.bedrockagent.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagent.model.AgentSummary;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse;
import software.amazon.awssdk.services.bedrockagent.model.PrepareAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.PrepareAgentResponse;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.IamException;
import software.amazon.awssdk.services.iam.model.NoSuchEntityException;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.Role;

public class AwsbedrockAgentsPayloadHelper {
    private static final Logger logger = LoggerFactory.getLogger(AwsbedrockAgentsPayloadHelper.class);

    private static BedrockRuntimeClient createClient(AwsBasicCredentials awsCreds, Region region) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).region(region)).build();
    }

    private static BedrockRuntimeClient createClientSession(AwsSessionCredentials awsCreds, Region region) {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds))).region(region)).build();
    }

    private static InvokeModelRequest createInvokeRequest(String modelId, String nativeRequest) {
        return (InvokeModelRequest)InvokeModelRequest.builder().body(SdkBytes.fromUtf8String((String)nativeRequest)).modelId(modelId).build();
    }

    private static String getAmazonTitanText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("inputText", (Object)prompt);
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        textGenerationConfig.put("topP", (Object)awsBedrockParameters.getTopP());
        textGenerationConfig.put("maxTokenCount", (Object)awsBedrockParameters.getMaxTokenCount());
        jsonRequest.put("textGenerationConfig", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAmazonNovaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject textObject = new JSONObject();
        textObject.put("text", (Object)prompt);
        JSONArray contentArray = new JSONArray();
        contentArray.put((Object)textObject);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)contentArray);
        JSONArray messagesArray = new JSONArray();
        messagesArray.put((Object)userMessage);
        JSONObject inferenceConfig = new JSONObject();
        inferenceConfig.put("max_new_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        inferenceConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        inferenceConfig.put("top_p", (Object)awsBedrockParameters.getTopP());
        inferenceConfig.put("top_k", (Object)awsBedrockParameters.getTopK());
        JSONObject rootObject = new JSONObject();
        rootObject.put("messages", (Object)messagesArray);
        rootObject.put("inferenceConfig", (Object)inferenceConfig);
        return rootObject.toString();
    }

    private static String getStabilityTitanText(String prompt) {
        JSONObject jsonRequest = new JSONObject();
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("text", (Object)prompt);
        jsonRequest.put("text_prompts", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAnthropicClaudeText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("top_k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens_to_sample", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getMistralAIText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("top_k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getAI21Text(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("topP", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("maxTokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getCohereText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getLlamaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("max_gen_len", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String identifyPayload(String prompt, AwsbedrockParameters awsBedrockParameters) {
        if (awsBedrockParameters.getModelName().contains("amazon.titan-text")) {
            return AwsbedrockAgentsPayloadHelper.getAmazonTitanText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("amazon.nova")) {
            return AwsbedrockAgentsPayloadHelper.getAmazonNovaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("anthropic.claude")) {
            return AwsbedrockAgentsPayloadHelper.getAnthropicClaudeText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("ai21.j2")) {
            return AwsbedrockAgentsPayloadHelper.getAI21Text(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.mistral")) {
            return AwsbedrockAgentsPayloadHelper.getMistralAIText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("cohere.command")) {
            return AwsbedrockAgentsPayloadHelper.getCohereText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("meta.llama")) {
            return AwsbedrockAgentsPayloadHelper.getLlamaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.")) {
            return AwsbedrockAgentsPayloadHelper.getLlamaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral.")) {
            return AwsbedrockAgentsPayloadHelper.getStabilityTitanText(prompt);
        }
        return "Unsupported model";
    }

    private static BedrockRuntimeClient InitiateClient(AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        if (configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty()) {
            AwsBasicCredentials awsCredsBasic = AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey());
            return AwsbedrockAgentsPayloadHelper.createClient(awsCredsBasic, AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()));
        }
        AwsSessionCredentials awsCredsSession = AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
        return AwsbedrockAgentsPayloadHelper.createClientSession(awsCredsSession, AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()));
    }

    private static String invokeModel(String prompt, AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        BedrockRuntimeClient client = AwsbedrockAgentsPayloadHelper.InitiateClient(configuration, awsBedrockParameters);
        String nativeRequest = AwsbedrockAgentsPayloadHelper.identifyPayload(prompt, awsBedrockParameters);
        try {
            InvokeModelRequest request = AwsbedrockAgentsPayloadHelper.createInvokeRequest(awsBedrockParameters.getModelName(), nativeRequest);
            InvokeModelResponse response = client.invokeModel(request);
            JSONObject responseBody = new JSONObject(response.body().asUtf8String());
            return responseBody.toString();
        }
        catch (SdkClientException e) {
            System.err.printf("ERROR: Can't invoke '%s'. Reason: %s", awsBedrockParameters.getModelName(), e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static BedrockClient createBedrockClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockClient bedrockClient = (BedrockClient)((BedrockClientBuilder)((BedrockClientBuilder)BedrockClient.builder().region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsbedrockAgentsPayloadHelper.createAwsBasicCredentials(configuration)))).build();
        return bedrockClient;
    }

    private static BedrockAgentClient createBedrockAgentClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentClientBuilder bedrockAgentClientBuilder = (BedrockAgentClientBuilder)((BedrockAgentClientBuilder)BedrockAgentClient.builder().region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsbedrockAgentsPayloadHelper.createAwsBasicCredentials(configuration)));
        if (configuration.getProxyConfig() != null) {
            ProxyConfiguration proxyConfig = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(String.format("%s://%s:%d", configuration.getProxyConfig().getScheme(), configuration.getProxyConfig().getHost(), configuration.getProxyConfig().getPort()))).username(configuration.getProxyConfig().getUsername()).password(configuration.getProxyConfig().getPassword()).nonProxyHosts(configuration.getProxyConfig().getNonProxyHosts()).build();
            SdkHttpClient httpClient = ApacheHttpClient.builder().proxyConfiguration(proxyConfig).build();
            bedrockAgentClientBuilder.httpClient(httpClient);
        }
        return (BedrockAgentClient)bedrockAgentClientBuilder.build();
    }

    private static BedrockAgentRuntimeClient createBedrockAgentRuntimeClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentRuntimeClient bedrockAgentRuntimeClient = (BedrockAgentRuntimeClient)((BedrockAgentRuntimeClientBuilder)((BedrockAgentRuntimeClientBuilder)BedrockAgentRuntimeClient.builder().region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsbedrockAgentsPayloadHelper.createAwsBasicCredentials(configuration)))).build();
        return bedrockAgentRuntimeClient;
    }

    private static BedrockAgentRuntimeAsyncClient createBedrockAgentRuntimeAsyncClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentRuntimeAsyncClientBuilder clientBuilder = (BedrockAgentRuntimeAsyncClientBuilder)((BedrockAgentRuntimeAsyncClientBuilder)BedrockAgentRuntimeAsyncClient.builder().region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsbedrockAgentsPayloadHelper.createAwsBasicCredentials(configuration)));
        if (configuration.getProxyConfig() != null) {
            software.amazon.awssdk.http.nio.netty.ProxyConfiguration proxyConfig = (software.amazon.awssdk.http.nio.netty.ProxyConfiguration)software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().host(configuration.getProxyConfig().getHost()).port(configuration.getProxyConfig().getPort()).username(configuration.getProxyConfig().getUsername()).password(configuration.getProxyConfig().getPassword()).nonProxyHosts(configuration.getProxyConfig().getNonProxyHosts()).build();
            SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().proxyConfiguration(proxyConfig).build();
            clientBuilder.httpClient(httpClient);
        }
        return (BedrockAgentRuntimeAsyncClient)clientBuilder.build();
    }

    private static AwsCredentials createAwsBasicCredentials(AwsbedrockConfiguration configuration) {
        if (configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty()) {
            return AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey());
        }
        return AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
    }

    private static IamClient createIamClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return (IamClient)((IamClientBuilder)((IamClientBuilder)IamClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsbedrockAgentsPayloadHelper.createAwsBasicCredentials(configuration)))).region(AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion()))).build();
    }

    public static String ListAgents(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameters);
        String listOfAgents = AwsbedrockAgentsPayloadHelper.getAgentNames(bedrockAgent);
        return listOfAgents;
    }

    private static String getAgentNames(BedrockAgentClient bedrockagent) {
        ListAgentsRequest listAgentsRequest = (ListAgentsRequest)ListAgentsRequest.builder().build();
        ListAgentsResponse listAgentsResponse = bedrockagent.listAgents(listAgentsRequest);
        List agentSummaries = listAgentsResponse.agentSummaries();
        List agentNames = agentSummaries.stream().map(AgentSummary::agentName).collect(Collectors.toList());
        JSONArray jsonArray = new JSONArray(agentNames);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agentNames", (Object)jsonArray);
        String jsonString = jsonObject.toString();
        return jsonString;
    }

    private static Agent getAgentById(String agentId, BedrockAgentClient bedrockAgentClient) {
        GetAgentRequest getAgentRequest = (GetAgentRequest)GetAgentRequest.builder().agentId(agentId).build();
        GetAgentResponse getAgentResponse = bedrockAgentClient.getAgent(getAgentRequest);
        Agent agent = getAgentResponse.agent();
        return agent;
    }

    public static String getAgentbyAgentId(String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameters);
        Agent agent = AwsbedrockAgentsPayloadHelper.getAgentById(agentId, bedrockAgent);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agentId", (Object)agent.agentId());
        jsonObject.put("agentName", (Object)agent.agentName());
        jsonObject.put("agentArn", (Object)agent.agentArn());
        jsonObject.put("agentStatus", (Object)agent.agentStatusAsString());
        jsonObject.put("agentResourceRoleArn", (Object)agent.agentResourceRoleArn());
        jsonObject.put("clientToken", (Object)agent.clientToken());
        jsonObject.put("createdAt", (Object)agent.createdAt().toString());
        jsonObject.put("description", (Object)agent.description());
        jsonObject.put("foundationModel", (Object)agent.foundationModel());
        jsonObject.put("idleSessionTTLInSeconds", (Object)agent.idleSessionTTLInSeconds());
        jsonObject.put("instruction", (Object)agent.instruction());
        jsonObject.put("promptOverrideConfiguration", (Object)agent.promptOverrideConfiguration());
        jsonObject.put("updatedAt", (Object)agent.updatedAt().toString());
        return jsonObject.toString();
    }

    private static Optional<Agent> getAgentByName(String agentName, BedrockAgentClient bedrockAgentClient) {
        ListAgentsRequest listAgentsRequest = (ListAgentsRequest)ListAgentsRequest.builder().build();
        ListAgentsResponse listAgentsResponse = bedrockAgentClient.listAgents(listAgentsRequest);
        List agentSummaries = listAgentsResponse.agentSummaries();
        for (AgentSummary agentSummary : agentSummaries) {
            if (!agentSummary.agentName().equals(agentName)) continue;
            String agentId = agentSummary.agentId();
            GetAgentRequest getAgentRequest = (GetAgentRequest)GetAgentRequest.builder().agentId(agentId).build();
            GetAgentResponse getAgentResponse = bedrockAgentClient.getAgent(getAgentRequest);
            Agent agent = getAgentResponse.agent();
            return Optional.of(agent);
        }
        return Optional.empty();
    }

    public static String getAgentbyAgentName(String agentName, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        String agentInfo = "";
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameters);
        Optional<Agent> optionalAgent = AwsbedrockAgentsPayloadHelper.getAgentByName(agentName, bedrockAgent);
        if (optionalAgent.isPresent()) {
            Agent agent = optionalAgent.get();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("agentId", (Object)agent.agentId());
            jsonObject.put("agentName", (Object)agent.agentName());
            jsonObject.put("agentArn", (Object)agent.agentArn());
            jsonObject.put("agentStatus", (Object)agent.agentStatusAsString());
            jsonObject.put("agentResourceRoleArn", (Object)agent.agentResourceRoleArn());
            jsonObject.put("clientToken", (Object)agent.clientToken());
            jsonObject.put("createdAt", (Object)agent.createdAt().toString());
            jsonObject.put("description", (Object)agent.description());
            jsonObject.put("foundationModel", (Object)agent.foundationModel());
            jsonObject.put("idleSessionTTLInSeconds", (Object)agent.idleSessionTTLInSeconds());
            jsonObject.put("instruction", (Object)agent.instruction());
            jsonObject.put("promptOverrideConfiguration", (Object)agent.promptOverrideConfiguration());
            jsonObject.put("updatedAt", (Object)agent.updatedAt().toString());
            return jsonObject.toString();
        }
        agentInfo = "No Agent found!";
        return agentInfo;
    }

    public static String createAgentOperation(String name, String instruction, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameter) {
        String postfix = "muc";
        String RolePolicyName = "agent_permissions";
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameter);
        Role agentRole = AwsbedrockAgentsPayloadHelper.createAgentRole(postfix, RolePolicyName, configuration, awsBedrockParameter);
        Agent agent = AwsbedrockAgentsPayloadHelper.createAgent(name, instruction, awsBedrockParameter.getModelName(), agentRole, bedrockAgent);
        PrepareAgentResponse agentDetails = AwsbedrockAgentsPayloadHelper.prepareAgent(agent.agentId(), bedrockAgent);
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("agentId", (Object)agentDetails.agentId());
        jsonRequest.put("agentVersion", (Object)agentDetails.agentVersion());
        jsonRequest.put("agentStatus", (Object)agentDetails.agentStatusAsString());
        jsonRequest.put("preparedAt", (Object)agentDetails.preparedAt().toString());
        jsonRequest.put("agentArn", (Object)agent.agentArn());
        jsonRequest.put("agentName", (Object)agent.agentName());
        jsonRequest.put("agentResourceRoleArn", (Object)agent.agentResourceRoleArn());
        jsonRequest.put("clientToken", (Object)agent.clientToken());
        jsonRequest.put("createdAt", (Object)agent.createdAt().toString());
        jsonRequest.put("description", (Object)agent.description());
        jsonRequest.put("foundationModel", (Object)agent.foundationModel());
        jsonRequest.put("idleSessionTTLInSeconds", (Object)agent.idleSessionTTLInSeconds());
        jsonRequest.put("instruction", (Object)agent.instruction());
        jsonRequest.put("promptOverrideConfiguration", (Object)agent.promptOverrideConfiguration());
        jsonRequest.put("updatedAt", (Object)agent.updatedAt().toString());
        return jsonRequest.toString();
    }

    public static String createAgentAlias(String name, String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameter) {
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameter);
        AgentAlias agentAlias = AwsbedrockAgentsPayloadHelper.createAgentAlias(name, agentId, bedrockAgent);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agentAliasId", (Object)agentAlias.agentAliasId());
        jsonObject.put("agentAliasName", (Object)agentAlias.agentAliasName());
        jsonObject.put("agentAliasArn", (Object)agentAlias.agentAliasArn());
        jsonObject.put("clientToken", (Object)agentAlias.clientToken());
        jsonObject.put("createdAt", (Object)agentAlias.createdAt().toString());
        jsonObject.put("updatedAt", (Object)agentAlias.updatedAt().toString());
        return jsonObject.toString();
    }

    private static Role createAgentRole(String postfix, String RolePolicyName, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        String roleName = "AmazonBedrockExecutionRoleForAgents_" + postfix;
        String modelArn = "arn:aws:bedrock:" + awsBedrockParameters.getRegion() + "::foundation-model/" + awsBedrockParameters.getModelName() + "*";
        String ROLE_POLICY_NAME = RolePolicyName;
        logger.info("Creating an execution role for the agent...");
        IamClient iamClient = AwsbedrockAgentsPayloadHelper.createIamClient(configuration, awsBedrockParameters);
        Role agentRole = null;
        try {
            GetRoleResponse getRoleResponse = iamClient.getRole((GetRoleRequest)GetRoleRequest.builder().roleName(roleName).build());
            agentRole = getRoleResponse.role();
            logger.info("Role already exists: " + agentRole.arn());
        }
        catch (NoSuchEntityException e) {
            try {
                CreateRoleResponse createRoleResponse = iamClient.createRole((CreateRoleRequest)CreateRoleRequest.builder().roleName(roleName).assumeRolePolicyDocument("{\"Version\": \"2012-10-17\",\"Statement\": [{\"Effect\": \"Allow\",\"Principal\": {\"Service\": \"bedrock.amazonaws.com\"},\"Action\": \"sts:AssumeRole\"}]}").build());
                logger.info(modelArn);
                String policyDocument = "{\"Version\": \"2012-10-17\",\"Statement\": [{\"Effect\": \"Allow\",\"Action\": [\"bedrock:ListFoundationModels\",\"bedrock:GetFoundationModel\",\"bedrock:TagResource\",\"bedrock:UntagResource\",\"bedrock:ListTagsForResource\",\"bedrock:CreateAgent\",\"bedrock:UpdateAgent\",\"bedrock:GetAgent\",\"bedrock:ListAgents\",\"bedrock:DeleteAgent\",\"bedrock:CreateAgentActionGroup\",\"bedrock:UpdateAgentActionGroup\",\"bedrock:GetAgentActionGroup\",\"bedrock:ListAgentActionGroups\",\"bedrock:DeleteAgentActionGroup\",\"bedrock:GetAgentVersion\",\"bedrock:ListAgentVersions\",\"bedrock:DeleteAgentVersion\",\"bedrock:CreateAgentAlias\",\"bedrock:UpdateAgentAlias\",\"bedrock:GetAgentAlias\",\"bedrock:ListAgentAliases\",\"bedrock:DeleteAgentAlias\",\"bedrock:AssociateAgentKnowledgeBase\",\"bedrock:DisassociateAgentKnowledgeBase\",\"bedrock:GetKnowledgeBase\",\"bedrock:ListKnowledgeBases\",\"bedrock:PrepareAgent\",\"bedrock:InvokeAgent\",\"bedrock:InvokeModel\"],\"Resource\": \"*\"}]}";
                logger.info(policyDocument);
                iamClient.putRolePolicy((PutRolePolicyRequest)PutRolePolicyRequest.builder().roleName(roleName).policyName(ROLE_POLICY_NAME).policyDocument(policyDocument).build());
                agentRole = (Role)Role.builder().roleName(roleName).arn(createRoleResponse.role().arn()).build();
            }
            catch (IamException ex) {
                logger.info("Couldn't create role " + roleName + ". Here's why: " + ex.getMessage());
                throw ex;
            }
        }
        return agentRole;
    }

    private static Agent createAgent(String name, String instruction, String modelId, Role agentRole, BedrockAgentClient bedrockAgentClient) {
        logger.info("Creating the agent...");
        CreateAgentResponse createAgentResponse = bedrockAgentClient.createAgent((CreateAgentRequest)CreateAgentRequest.builder().agentName(name).foundationModel(modelId).instruction(instruction).agentResourceRoleArn(agentRole.arn()).build());
        AwsbedrockAgentsPayloadHelper.waitForAgentStatus(createAgentResponse.agent().agentId(), AgentStatus.NOT_PREPARED.toString(), bedrockAgentClient);
        return createAgentResponse.agent();
    }

    private static void waitForAgentStatus(String agentId, String status, BedrockAgentClient bedrockAgentClient) {
        GetAgentResponse response;
        while (!(response = bedrockAgentClient.getAgent((GetAgentRequest)GetAgentRequest.builder().agentId(agentId).build())).agent().agentStatus().toString().equals(status)) {
            try {
                logger.info("Waiting for agent get prepared...");
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static PrepareAgentResponse prepareAgent(String agentId, BedrockAgentClient bedrockAgentClient) {
        logger.info("Preparing the agent...");
        PrepareAgentResponse preparedAgentDetails = bedrockAgentClient.prepareAgent((PrepareAgentRequest)PrepareAgentRequest.builder().agentId(agentId).build());
        AwsbedrockAgentsPayloadHelper.waitForAgentStatus(agentId, "PREPARED", bedrockAgentClient);
        return preparedAgentDetails;
    }

    private static AgentAlias createAgentAlias(String alias, String agentId, BedrockAgentClient bedrockAgentClient) {
        logger.info("Creating an agent alias...");
        logger.info("agentId: " + agentId);
        CreateAgentAliasRequest request = (CreateAgentAliasRequest)CreateAgentAliasRequest.builder().agentId(agentId).agentAliasName(alias).build();
        CreateAgentAliasResponse response = bedrockAgentClient.createAgentAlias(request);
        return response.agentAlias();
    }

    public static String listAllAgentAliases(String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameters);
        List<AgentAliasSummary> agentAliasSummaries = AwsbedrockAgentsPayloadHelper.listAgentAliases(agentId, bedrockAgent);
        JSONArray jsonArray = new JSONArray();
        for (AgentAliasSummary agentAliasSummary : agentAliasSummaries) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("agentAliasId", (Object)agentAliasSummary.agentAliasId());
            jsonObject.put("agentAliasName", (Object)agentAliasSummary.agentAliasName());
            jsonObject.put("createdAt", (Object)agentAliasSummary.createdAt().toString());
            jsonObject.put("updatedAt", (Object)agentAliasSummary.updatedAt().toString());
            jsonArray.put((Object)jsonObject);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agentAliasSummaries", (Object)jsonArray);
        return jsonObject.toString();
    }

    private static List<AgentAliasSummary> listAgentAliases(String agentId, BedrockAgentClient bedrockAgentClient) {
        ListAgentAliasesRequest listAgentAliasesRequest = (ListAgentAliasesRequest)ListAgentAliasesRequest.builder().agentId(agentId).build();
        ListAgentAliasesResponse listAgentAliasesResponse = bedrockAgentClient.listAgentAliases(listAgentAliasesRequest);
        List agentAliasSummaries = listAgentAliasesResponse.agentAliasSummaries();
        return agentAliasSummaries;
    }

    public static String deleteAgentAliasesByAgentId(String agentId, String agentAliasName, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameters);
        DeleteAgentAliasResponse response = AwsbedrockAgentsPayloadHelper.deleteAgentAliasByName(agentId, agentAliasName, bedrockAgent);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agentId", (Object)response.agentId());
        jsonObject.put("agentAliasId", (Object)response.agentAliasId());
        jsonObject.put("agentAliasStatus", (Object)response.agentAliasStatus().toString());
        jsonObject.put("agentStatus", (Object)response.agentAliasStatusAsString());
        return jsonObject.toString();
    }

    private static DeleteAgentAliasResponse deleteAgentAliasByName(String agentId, String agentAliasName, BedrockAgentClient bedrockAgentClient) {
        DeleteAgentAliasResponse response = null;
        ListAgentAliasesRequest listAgentAliasesRequest = (ListAgentAliasesRequest)ListAgentAliasesRequest.builder().agentId(agentId).build();
        ListAgentAliasesResponse listAgentAliasesResponse = bedrockAgentClient.listAgentAliases(listAgentAliasesRequest);
        List agentAliasSummaries = listAgentAliasesResponse.agentAliasSummaries();
        Optional<AgentAliasSummary> agentAliasSummary = agentAliasSummaries.stream().filter(alias -> alias.agentAliasName().equals(agentAliasName)).findFirst();
        if (agentAliasSummary.isPresent()) {
            String agentAliasId = agentAliasSummary.get().agentAliasId();
            DeleteAgentAliasRequest deleteAgentAliasRequest = (DeleteAgentAliasRequest)DeleteAgentAliasRequest.builder().agentId(agentId).agentAliasId(agentAliasId).build();
            DeleteAgentAliasResponse deleteAgentAliasResponse = bedrockAgentClient.deleteAgentAlias(deleteAgentAliasRequest);
            logger.info("Agent alias with name " + agentAliasName + " deleted successfully.");
            response = deleteAgentAliasResponse;
        } else {
            logger.info("No agent alias with name " + agentAliasName + " found.");
        }
        return response;
    }

    public static String deleteAgentByAgentId(String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentClient(configuration, awsBedrockParameters);
        DeleteAgentResponse response = AwsbedrockAgentsPayloadHelper.deleteAgentById(agentId, bedrockAgent);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("agentId", (Object)response.agentId());
        jsonObject.put("agentStatus", (Object)response.agentStatusAsString());
        return jsonObject.toString();
    }

    private static DeleteAgentResponse deleteAgentById(String agentId, BedrockAgentClient bedrockAgentClient) {
        DeleteAgentRequest deleteAgentRequest = (DeleteAgentRequest)DeleteAgentRequest.builder().agentId(agentId).build();
        DeleteAgentResponse deleteAgentResponse = bedrockAgentClient.deleteAgent(deleteAgentRequest);
        return deleteAgentResponse;
    }

    public static String chatWithAgent(String agentAlias, String agentId, String sessionId, String prompt, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        BedrockAgentRuntimeAsyncClient bedrockAgent = AwsbedrockAgentsPayloadHelper.createBedrockAgentRuntimeAsyncClient(configuration, awsBedrockParameters);
        if (sessionId != null && !sessionId.isEmpty()) {
            logger.info("Using provided sessionId: " + sessionId);
        } else {
            sessionId = UUID.randomUUID().toString();
            logger.info("Generated new sessionId: " + sessionId);
        }
        String response = "";
        try {
            response = AwsbedrockAgentsPayloadHelper.invokeAgent(agentAlias, agentId, prompt, sessionId, bedrockAgent).get();
            logger.info(response);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            logger.info(e.getMessage());
        }
        return response.substring(4);
    }

    private static CompletableFuture<String> invokeAgent(String agentAlias, String agentId, String prompt, String sessionId, BedrockAgentRuntimeAsyncClient bedrockAgentRuntimeAsyncClient) throws InterruptedException, ExecutionException {
        InvokeAgentRequest request = (InvokeAgentRequest)InvokeAgentRequest.builder().agentId(agentId).agentAliasId(agentAlias).sessionId(sessionId).inputText(prompt).build();
        CompletableFuture<String> completionFuture = new CompletableFuture<String>();
        InvokeAgentResponseHandler.Visitor visitor = InvokeAgentResponseHandler.Visitor.builder().onChunk(chunk -> {
            SdkBytes bytes = chunk.bytes();
            String text = new String(bytes.asByteArray(), StandardCharsets.UTF_8);
            completionFuture.complete((String)completionFuture.getNow(null) + text);
        }).build();
        InvokeAgentResponseHandler handler = InvokeAgentResponseHandler.builder().subscriber(visitor).build();
        bedrockAgentRuntimeAsyncClient.invokeAgent(request, handler).get();
        return completionFuture;
    }
}

