/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class AwsbedrockChatMemory
implements AutoCloseable {
    private final MVStore store;
    private final MVMap<Long, String> chatMap;

    public AwsbedrockChatMemory(String dbFile, String memoryName) {
        this.store = MVStore.open((String)dbFile);
        this.chatMap = this.store.openMap(memoryName);
    }

    public void addMessage(long messageId, String messageContent) {
        this.chatMap.put((Object)messageId, (Object)messageContent);
        this.store.commit();
    }

    public void deleteMessage(long messageId) {
        this.chatMap.remove((Object)messageId);
        this.store.commit();
    }

    public void deleteAllMessages() {
        this.chatMap.clear();
        this.store.commit();
    }

    public String getMessage(long messageId) {
        return (String)this.chatMap.get((Object)messageId);
    }

    public int getMessageCount() {
        return this.chatMap.size();
    }

    public List<String> getAllMessages() {
        return new ArrayList<String>(this.chatMap.values());
    }

    public List<String> getAllMessagesByMessageIdDesc() {
        return this.chatMap.keySet().stream().sorted(Comparator.reverseOrder()).map(arg_0 -> this.chatMap.get(arg_0)).collect(Collectors.toList());
    }

    public List<String> getAllMessagesByMessageIdAsc() {
        return this.chatMap.keySet().stream().sorted(Comparator.naturalOrder()).map(arg_0 -> this.chatMap.get(arg_0)).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.store.close();
    }
}

