/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.helpers.AwsbedrockPayloadHelper;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.CommonUtils;
import org.mule.extension.mulechain.internal.ModelProvider;
import org.mule.extension.mulechain.internal.image.AwsbedrockImageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AwsbedrockImagePayloadHelper {
    private static final Map<ModelProvider, PayloadGenerator> payloadGeneratorMap = new EnumMap<ModelProvider, PayloadGenerator>(ModelProvider.class);
    private static final Map<ModelProvider, ImageBytesExtractor> imageBytesExtractorMap = new EnumMap<ModelProvider, ImageBytesExtractor>(ModelProvider.class);
    private static final Logger logger;

    private static String getAmazonTitanImage(String prompt, String avoidInImage, AwsbedrockImageParameters awsBedrockParameters) {
        return new JSONObject().put("taskType", (Object)"TEXT_IMAGE").put("textToImageParams", (Object)new JSONObject().put("text", (Object)prompt).put("negativeText", (Object)avoidInImage)).put("imageGenerationConfig", (Object)new JSONObject().put("numberOfImages", (Object)awsBedrockParameters.getNumOfImages()).put("height", (Object)awsBedrockParameters.getHeight()).put("width", (Object)awsBedrockParameters.getWidth()).put("cfgScale", (Object)awsBedrockParameters.getCfgScale()).put("seed", (Object)awsBedrockParameters.getSeed())).toString();
    }

    private static String getAmazonNovaImage(String prompt, String avoidInImage, AwsbedrockImageParameters awsBedrockParameters) {
        return AwsbedrockImagePayloadHelper.getAmazonTitanImage(prompt, avoidInImage, awsBedrockParameters);
    }

    private static String getStabilityAiDiffusionImage(String prompt, String avoidInImage, AwsbedrockImageParameters awsBedrockParameters) {
        JSONArray textPromptsArray = new JSONArray().put((Object)new JSONObject().put("text", (Object)prompt).put("weight", 0));
        JSONObject json = new JSONObject().put("text_prompts", (Object)textPromptsArray).put("height", (Object)awsBedrockParameters.getHeight()).put("width", (Object)awsBedrockParameters.getWidth()).put("cfg_scale", (Object)awsBedrockParameters.getCfgScale()).put("seed", (Object)awsBedrockParameters.getSeed());
        return json.toString();
    }

    private static String identifyPayload(String prompt, String avoidInImage, AwsbedrockImageParameters awsBedrockParameters) {
        return ModelProvider.fromModelId(awsBedrockParameters.getModelName()).map(provider -> (String)payloadGeneratorMap.get(provider).apply(prompt, avoidInImage, awsBedrockParameters)).orElse("Unsupported model");
    }

    private static BedrockRuntimeClient createClient(AwsbedrockConfiguration configuration, Region region) {
        Object awsCredentials = configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty() ? AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey()) : AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
        String endpointOverride = configuration.getEndpointOverride();
        SdkHttpClient httpClient = CommonUtils.buildHttpClientWithTimeout(configuration.getTimeout(), configuration.getTimeoutUnit());
        BedrockRuntimeClientBuilder builder = (BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).httpClient(httpClient)).fipsEnabled(configuration.getFipsModeEnabled())).region(region);
        if (endpointOverride != null && !endpointOverride.isBlank()) {
            builder.endpointOverride(URI.create(endpointOverride));
        }
        return (BedrockRuntimeClient)builder.build();
    }

    private static InvokeModelRequest createInvokeRequest(String modelId, String nativeRequest) {
        return (InvokeModelRequest)InvokeModelRequest.builder().body(SdkBytes.fromUtf8String((String)nativeRequest)).modelId(modelId).build();
    }

    public static byte[] generateImage(String modelId, String body, AwsbedrockConfiguration configuration, Region region) throws IOException {
        BedrockRuntimeClient bedrock = AwsbedrockImagePayloadHelper.createClient(configuration, region);
        InvokeModelRequest request = AwsbedrockImagePayloadHelper.createInvokeRequest(modelId, body);
        InvokeModelResponse response = bedrock.invokeModel(request);
        JSONObject responseBody = new JSONObject(response.body().asUtf8String());
        byte[] imageBytes = ModelProvider.fromModelId(modelId).map(provider -> (byte[])imageBytesExtractorMap.get(provider).apply(responseBody)).orElseThrow(() -> new RuntimeException("Unsupported model: " + modelId));
        String finishReason = responseBody.optString("error", null);
        if (finishReason != null) {
            throw new RuntimeException("Image generation error. Error is " + finishReason);
        }
        return imageBytes;
    }

    public static String invokeModel(String prompt, String avoidInImage, String fullPath, AwsbedrockConfiguration configuration, AwsbedrockImageParameters awsBedrockParameters) {
        Region region = AwsbedrockPayloadHelper.getRegion(awsBedrockParameters.getRegion());
        String modelId = awsBedrockParameters.getModelName();
        String body = AwsbedrockImagePayloadHelper.identifyPayload(prompt, avoidInImage, awsBedrockParameters);
        logger.info(body);
        try {
            byte[] imageBytes = AwsbedrockImagePayloadHelper.generateImage(modelId, body, configuration, region);
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            BufferedImage bufferedImage = ImageIO.read(bis);
            bis.close();
            String filePath = fullPath;
            File outputImageFile = new File(filePath);
            ImageIO.write((RenderedImage)bufferedImage, "png", outputImageFile);
            if (bufferedImage != null) {
                logger.info("Successfully generated image.");
            } else {
                logger.warn("Failed to generate image.");
            }
            return filePath;
        }
        catch (Exception e) {
            logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    static {
        payloadGeneratorMap.put(ModelProvider.AMAZON, AwsbedrockImagePayloadHelper::getAmazonTitanImage);
        payloadGeneratorMap.put(ModelProvider.AMAZON_NOVA, AwsbedrockImagePayloadHelper::getAmazonNovaImage);
        payloadGeneratorMap.put(ModelProvider.STABILITY, AwsbedrockImagePayloadHelper::getStabilityAiDiffusionImage);
        imageBytesExtractorMap.put(ModelProvider.AMAZON, responseBody -> {
            String base64Image = responseBody.getJSONArray("images").getString(0);
            return Base64.getDecoder().decode(base64Image);
        });
        imageBytesExtractorMap.put(ModelProvider.AMAZON_NOVA, responseBody -> {
            String base64Image = responseBody.getJSONArray("images").getString(0);
            return Base64.getDecoder().decode(base64Image);
        });
        imageBytesExtractorMap.put(ModelProvider.STABILITY, responseBody -> {
            JSONArray artifactsArray = responseBody.getJSONArray("artifacts");
            String base64Image = artifactsArray.getJSONObject(0).getString("base64");
            return Base64.getDecoder().decode(base64Image);
        });
        logger = LoggerFactory.getLogger(AwsbedrockImagePayloadHelper.class);
    }

    @FunctionalInterface
    private static interface ImageBytesExtractor
    extends Function<JSONObject, byte[]> {
    }

    @FunctionalInterface
    private static interface PayloadGenerator
    extends TriFunction<String, String, AwsbedrockImageParameters, String> {
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

