/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.mule.extension.mulechain.internal.TimeUnitEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static ChronoUnit convertToChronoUnit(TimeUnitEnum unit) {
        switch (unit) {
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
        }
        return ChronoUnit.MILLIS;
    }

    public static Duration toDuration(int timeout, TimeUnitEnum unit) {
        return Duration.of(timeout, CommonUtils.convertToChronoUnit(unit));
    }

    public static SdkHttpClient buildHttpClientWithTimeout(Integer timeout, TimeUnitEnum unit) {
        int effectiveTimeout = timeout != null ? timeout : 10;
        TimeUnitEnum effectiveUnit = unit != null ? unit : TimeUnitEnum.SECONDS;
        Duration timeoutDuration = CommonUtils.toDuration(effectiveTimeout, effectiveUnit);
        logger.debug("HTTP client timeout set to: {} {}", (Object)effectiveTimeout, (Object)effectiveUnit);
        return UrlConnectionHttpClient.builder().socketTimeout(timeoutDuration).build();
    }
}

