/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.agents;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mule.extension.mulechain.helpers.AwsbedrockAgentsPayloadHelper;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.agents.AwsbedrockAgentsParameters;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.param.Optional;

public class AwsbedrockAgentsOperations {
    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-list")
    public InputStream listAgents(@Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.ListAgents(configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-get-by-id")
    public InputStream getAgentById(String agentId, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.getAgentbyAgentId(agentId, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-get-by-name")
    public InputStream getAgentByName(String agentName, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.getAgentbyAgentName(agentName, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-delete-by-id")
    public InputStream deleteAgentById(String agentId, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.deleteAgentByAgentId(agentId, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-create")
    public InputStream createAgentWithAlias(String agentName, String instructions, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.createAgentOperation(agentName, instructions, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-create-alias")
    public InputStream createAgentAlias(String agentAlias, String agentId, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.createAgentAlias(agentAlias, agentId, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-get-alias-by-agent-id")
    public InputStream getAgentAliasById(String agentId, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.listAllAgentAliases(agentId, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-delete-agent-aliases")
    public InputStream deleteAgentAlias(String agentId, String agentAliasName, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.deleteAgentAliasesByAgentId(agentId, agentAliasName, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-chat")
    public InputStream chatWithAgent(String agentId, String agentAliasId, @Optional String sessionId, String prompt, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        String response = AwsbedrockAgentsPayloadHelper.chatWithAgent(agentAliasId, agentId, sessionId, prompt, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="text/event-stream", strict=false)
    @Alias(value="AGENT-chat-streaming-SSE")
    @DisplayName(value="Agent chat streaming (SSE)")
    public InputStream chatWithAgentSSEStream(String agentId, String agentAliasId, @Optional String sessionId, String prompt, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockAgentsParameters awsBedrockParameters) {
        return AwsbedrockAgentsPayloadHelper.chatWithAgentSSEStream(agentAliasId, agentId, sessionId, prompt, configuration, awsBedrockParameters);
    }
}

