/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.util.function.Supplier;
import org.mule.extension.mulechain.internal.BedrockError;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.bedrockagent.model.AccessDeniedException;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentException;
import software.amazon.awssdk.services.bedrockagent.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bedrockagent.model.ThrottlingException;
import software.amazon.awssdk.services.bedrockagent.model.ValidationException;

public class BedrockClientInvoker {
    private static final Logger logger = LoggerFactory.getLogger(BedrockClientInvoker.class);

    public static <T> T executeWithErrorHandling(Supplier<T> operation) {
        try {
            return operation.get();
        }
        catch (ValidationException e) {
            logger.error("Validation error: {}", (Object)e.getMessage());
            throw new ModuleException("Invalid request parameters", (ErrorTypeDefinition)BedrockError.VALIDATION_ERROR, (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            logger.error("Resource not found: {}", (Object)e.getMessage());
            throw new ModuleException("Resource not found", (ErrorTypeDefinition)BedrockError.RESOURCE_NOT_FOUND, (Throwable)e);
        }
        catch (AccessDeniedException e) {
            logger.error("Access denied: {}", (Object)e.getMessage());
            throw new ModuleException("Access denied", (ErrorTypeDefinition)BedrockError.ACCESS_DENIED, (Throwable)e);
        }
        catch (ThrottlingException e) {
            logger.error("Throttled: {}", (Object)e.getMessage());
            throw new ModuleException("Request throttled", (ErrorTypeDefinition)BedrockError.THROTTLING_ERROR, (Throwable)e);
        }
        catch (BedrockAgentException e) {
            logger.error("Bedrock service error: {}", (Object)e.getMessage());
            logger.error("Error code: {}", (Object)e.awsErrorDetails().errorCode());
            logger.error("Status code: {}", (Object)e.statusCode());
            throw new ModuleException("Bedrock service error", (ErrorTypeDefinition)BedrockError.SERVICE_ERROR, (Throwable)e);
        }
        catch (SdkServiceException e) {
            logger.error("Service error: {} - {}", (Object)e.statusCode(), (Object)e.getMessage());
            logger.error("Request ID: {}", (Object)e.requestId());
            throw new ModuleException((ErrorTypeDefinition)BedrockError.SERVICE_ERROR, (Throwable)e);
        }
        catch (SdkClientException e) {
            logger.error("Client error: {}", (Object)e.getMessage());
            throw new ModuleException("Client error", (ErrorTypeDefinition)BedrockError.CLIENT_ERROR, (Throwable)e);
        }
        catch (SdkException e) {
            logger.error("AWS SDK error: {}", (Object)e.getMessage());
            throw new ModuleException("AWS SDK error", (ErrorTypeDefinition)BedrockError.AWS_SDK_ERROR, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error("Unexpected runtime exception in Bedrock operation", (Throwable)e);
            throw e;
        }
    }

    public static void executeWithErrorHandling(Runnable operation) {
        BedrockClientInvoker.executeWithErrorHandling(() -> {
            operation.run();
            return null;
        });
    }
}

