/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.helpers.BedrockClientInvoker;
import org.mule.extension.mulechain.helpers.BedrockClients;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.agents.AwsbedrockAgentsFilteringParameters;
import org.mule.extension.mulechain.internal.agents.AwsbedrockAgentsParameters;
import org.mule.extension.mulechain.internal.agents.AwsbedrockAgentsSessionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.model.Agent;
import software.amazon.awssdk.services.bedrockagent.model.AgentAlias;
import software.amazon.awssdk.services.bedrockagent.model.AgentAliasSummary;
import software.amazon.awssdk.services.bedrockagent.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagent.model.AgentSummary;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.CreateAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentAliasResponse;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.DeleteAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.GetAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentAliasesResponse;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentsResponse;
import software.amazon.awssdk.services.bedrockagent.model.PrepareAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.PrepareAgentResponse;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockModelConfigurations;
import software.amazon.awssdk.services.bedrockagentruntime.model.FilterAttribute;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseVectorSearchConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.PayloadPart;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptCreationConfigurations;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionState;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.IamException;
import software.amazon.awssdk.services.iam.model.NoSuchEntityException;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.Role;

public class AwsbedrockAgentsPayloadHelper {
    private static final Logger logger = LoggerFactory.getLogger(AwsbedrockAgentsPayloadHelper.class);
    private static final String AGENT_NAMES = "agentNames";
    private static final String AGENT_ID = "agentId";
    private static final String AGENT_NAME = "agentName";
    private static final String AGENT_ARN = "agentArn";
    private static final String AGENT_STATUS = "agentStatus";
    private static final String AGENT_RESOURCE_ROLE_ARN = "agentResourceRoleArn";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String CREATED_AT = "createdAt";
    private static final String DESCRIPTION = "description";
    private static final String FOUNDATION_MODEL = "foundationModel";
    private static final String IDLE_SESSION_TTL_IN_SECONDS = "idleSessionTTLInSeconds";
    private static final String INSTRUCTION = "instruction";
    private static final String PROMPT_OVERRIDE_CONFIGURATION = "promptOverrideConfiguration";
    private static final String UPDATED_AT = "updatedAt";
    private static final String AGENT_ALIAS_ID = "agentAliasId";
    private static final String AGENT_ALIAS_NAME = "agentAliasName";
    private static final String AGENT_ALIAS_ARN = "agentAliasArn";
    private static final String AGENT_ALIAS_SUMMARIES = "agentAliasSummaries";
    private static final String AGENT_ALIAS_STATUS = "agentAliasStatus";
    private static final String AGENT_VERSION = "agentVersion";
    private static final String PREPARED_AT = "preparedAt";
    private static final String SESSION_ID = "sessionId";
    private static final String AGENT_ALIAS = "agentAlias";
    private static final String PROMPT = "prompt";
    private static final String PROCESSED_AT = "processedAt";
    private static final String CHUNKS = "chunks";
    private static final String SUMMARY = "summary";
    private static final String TOTAL_CHUNKS = "totalChunks";
    private static final String FULL_RESPONSE = "fullResponse";
    private static final String TYPE = "type";
    private static final String CHUNK = "chunk";
    private static final String TIMESTAMP = "timestamp";
    private static final String TEXT = "text";
    private static final String CITATIONS = "citations";
    private static final String GENERATED_RESPONSE_PART = "generatedResponsePart";
    private static final String RETRIEVED_REFERENCES = "retrievedReferences";
    private static final String CONTENT = "content";
    private static final String LOCATION = "location";
    private static final String METADATA = "metadata";
    private static final String NO_AGENT_FOUND = "No Agent found!";
    private static final String AGENT_EXECUTION_ROLE_PREFIX = "AmazonBedrockExecutionRoleForAgents_";
    private static final String AGENT_ROLE_POLICY_NAME = "agent_permissions";
    private static final String AGENT_POSTFIX = "muc";
    private static final long AGENT_STATUS_CHECK_INTERVAL_MS = 2000L;
    private static final AtomicInteger eventCounter = new AtomicInteger(0);

    public static String ListAgents(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameters);
            String listOfAgents = AwsbedrockAgentsPayloadHelper.getAgentNames(bedrockAgent);
            return listOfAgents;
        });
    }

    private static String getAgentNames(BedrockAgentClient bedrockagent) {
        ListAgentsRequest listAgentsRequest = (ListAgentsRequest)ListAgentsRequest.builder().build();
        ListAgentsResponse listAgentsResponse = bedrockagent.listAgents(listAgentsRequest);
        List agentSummaries = listAgentsResponse.agentSummaries();
        List agentNames = agentSummaries.stream().map(AgentSummary::agentName).collect(Collectors.toList());
        JSONArray jsonArray = new JSONArray(agentNames);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(AGENT_NAMES, (Object)jsonArray);
        String jsonString = jsonObject.toString();
        return jsonString;
    }

    private static Agent getAgentById(String agentId, BedrockAgentClient bedrockAgentClient) {
        GetAgentRequest getAgentRequest = (GetAgentRequest)GetAgentRequest.builder().agentId(agentId).build();
        GetAgentResponse getAgentResponse = bedrockAgentClient.getAgent(getAgentRequest);
        Agent agent = getAgentResponse.agent();
        return agent;
    }

    public static String getAgentbyAgentId(String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameters);
            Agent agent = AwsbedrockAgentsPayloadHelper.getAgentById(agentId, bedrockAgent);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(AGENT_ID, (Object)agent.agentId());
            jsonObject.put(AGENT_NAME, (Object)agent.agentName());
            jsonObject.put(AGENT_ARN, (Object)agent.agentArn());
            jsonObject.put(AGENT_STATUS, (Object)agent.agentStatusAsString());
            jsonObject.put(AGENT_RESOURCE_ROLE_ARN, (Object)agent.agentResourceRoleArn());
            jsonObject.put(CLIENT_TOKEN, (Object)agent.clientToken());
            jsonObject.put(CREATED_AT, (Object)agent.createdAt());
            jsonObject.put(DESCRIPTION, (Object)agent.description());
            jsonObject.put(FOUNDATION_MODEL, (Object)agent.foundationModel());
            jsonObject.put(IDLE_SESSION_TTL_IN_SECONDS, (Object)agent.idleSessionTTLInSeconds());
            jsonObject.put(INSTRUCTION, (Object)agent.instruction());
            jsonObject.put(PROMPT_OVERRIDE_CONFIGURATION, (Object)agent.promptOverrideConfiguration());
            jsonObject.put(UPDATED_AT, (Object)agent.updatedAt());
            return jsonObject.toString();
        });
    }

    private static Optional<Agent> getAgentByName(String agentName, BedrockAgentClient bedrockAgentClient) {
        ListAgentsRequest listAgentsRequest = (ListAgentsRequest)ListAgentsRequest.builder().build();
        ListAgentsResponse listAgentsResponse = bedrockAgentClient.listAgents(listAgentsRequest);
        List agentSummaries = listAgentsResponse.agentSummaries();
        for (AgentSummary agentSummary : agentSummaries) {
            if (!agentSummary.agentName().equals(agentName)) continue;
            String agentId = agentSummary.agentId();
            GetAgentRequest getAgentRequest = (GetAgentRequest)GetAgentRequest.builder().agentId(agentId).build();
            GetAgentResponse getAgentResponse = bedrockAgentClient.getAgent(getAgentRequest);
            Agent agent = getAgentResponse.agent();
            return Optional.of(agent);
        }
        return Optional.empty();
    }

    public static String getAgentbyAgentName(String agentName, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameters);
            Optional<Agent> optionalAgent = AwsbedrockAgentsPayloadHelper.getAgentByName(agentName, bedrockAgent);
            if (optionalAgent.isPresent()) {
                Agent agent = optionalAgent.get();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(AGENT_ID, (Object)agent.agentId());
                jsonObject.put(AGENT_NAME, (Object)agent.agentName());
                jsonObject.put(AGENT_ARN, (Object)agent.agentArn());
                jsonObject.put(AGENT_STATUS, (Object)agent.agentStatusAsString());
                jsonObject.put(AGENT_RESOURCE_ROLE_ARN, (Object)agent.agentResourceRoleArn());
                jsonObject.put(CLIENT_TOKEN, (Object)agent.clientToken());
                jsonObject.put(CREATED_AT, (Object)agent.createdAt());
                jsonObject.put(DESCRIPTION, (Object)agent.description());
                jsonObject.put(FOUNDATION_MODEL, (Object)agent.foundationModel());
                jsonObject.put(IDLE_SESSION_TTL_IN_SECONDS, (Object)agent.idleSessionTTLInSeconds());
                jsonObject.put(INSTRUCTION, (Object)agent.instruction());
                jsonObject.put(PROMPT_OVERRIDE_CONFIGURATION, (Object)agent.promptOverrideConfiguration());
                jsonObject.put(UPDATED_AT, (Object)agent.updatedAt());
                return jsonObject.toString();
            }
            return NO_AGENT_FOUND;
        });
    }

    public static String createAgentOperation(String name, String instruction, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameter) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameter);
            Role agentRole = AwsbedrockAgentsPayloadHelper.createAgentRole(AGENT_POSTFIX, AGENT_ROLE_POLICY_NAME, configuration, awsBedrockParameter);
            Agent agent = AwsbedrockAgentsPayloadHelper.createAgent(name, instruction, awsBedrockParameter.getModelName(), agentRole, bedrockAgent);
            PrepareAgentResponse agentDetails = AwsbedrockAgentsPayloadHelper.prepareAgent(agent.agentId(), bedrockAgent);
            JSONObject jsonRequest = new JSONObject();
            jsonRequest.put(AGENT_ID, (Object)agentDetails.agentId());
            jsonRequest.put(AGENT_VERSION, (Object)agentDetails.agentVersion());
            jsonRequest.put(AGENT_STATUS, (Object)agentDetails.agentStatusAsString());
            jsonRequest.put(PREPARED_AT, (Object)agentDetails.preparedAt());
            jsonRequest.put(AGENT_ARN, (Object)agent.agentArn());
            jsonRequest.put(AGENT_NAME, (Object)agent.agentName());
            jsonRequest.put(AGENT_RESOURCE_ROLE_ARN, (Object)agent.agentResourceRoleArn());
            jsonRequest.put(CLIENT_TOKEN, (Object)agent.clientToken());
            jsonRequest.put(CREATED_AT, (Object)agent.createdAt());
            jsonRequest.put(DESCRIPTION, (Object)agent.description());
            jsonRequest.put(FOUNDATION_MODEL, (Object)agent.foundationModel());
            jsonRequest.put(IDLE_SESSION_TTL_IN_SECONDS, (Object)agent.idleSessionTTLInSeconds());
            jsonRequest.put(INSTRUCTION, (Object)agent.instruction());
            jsonRequest.put(PROMPT_OVERRIDE_CONFIGURATION, (Object)agent.promptOverrideConfiguration());
            jsonRequest.put(UPDATED_AT, (Object)agent.updatedAt());
            return jsonRequest.toString();
        });
    }

    public static String createAgentAlias(String name, String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameter) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameter);
            AgentAlias agentAlias = AwsbedrockAgentsPayloadHelper.createAgentAlias(name, agentId, bedrockAgent);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(AGENT_ALIAS_ID, (Object)agentAlias.agentAliasId());
            jsonObject.put(AGENT_ALIAS_NAME, (Object)agentAlias.agentAliasName());
            jsonObject.put(AGENT_ALIAS_ARN, (Object)agentAlias.agentAliasArn());
            jsonObject.put(CLIENT_TOKEN, (Object)agentAlias.clientToken());
            jsonObject.put(CREATED_AT, (Object)agentAlias.createdAt());
            jsonObject.put(UPDATED_AT, (Object)agentAlias.updatedAt());
            return jsonObject.toString();
        });
    }

    private static Role createAgentRole(String postfix, String RolePolicyName, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        String roleName = AGENT_EXECUTION_ROLE_PREFIX + postfix;
        String modelArn = "arn:aws:bedrock:" + awsBedrockParameters.getRegion() + "::foundation-model/" + awsBedrockParameters.getModelName() + "*";
        String ROLE_POLICY_NAME = RolePolicyName;
        logger.info("Creating an execution role for the agent...");
        IamClient iamClient = BedrockClients.getIamClient(configuration, awsBedrockParameters);
        Role agentRole = null;
        try {
            GetRoleResponse getRoleResponse = iamClient.getRole((GetRoleRequest)GetRoleRequest.builder().roleName(roleName).build());
            agentRole = getRoleResponse.role();
            logger.info("Role already exists: {}", (Object)agentRole.arn());
        }
        catch (NoSuchEntityException e) {
            try {
                CreateRoleResponse createRoleResponse = iamClient.createRole((CreateRoleRequest)CreateRoleRequest.builder().roleName(roleName).assumeRolePolicyDocument("{\"Version\": \"2012-10-17\",\"Statement\": [{\"Effect\": \"Allow\",\"Principal\": {\"Service\": \"bedrock.amazonaws.com\"},\"Action\": \"sts:AssumeRole\"}]}").build());
                logger.info("Model ARN: {}", (Object)modelArn);
                String policyDocument = "{\n    \"Version\": \"2012-10-17\",\n    \"Statement\": [\n        {\n            \"Effect\": \"Allow\",\n            \"Action\": [\n                \"bedrock:ListFoundationModels\",\n                \"bedrock:GetFoundationModel\",\n                \"bedrock:TagResource\",\n                \"bedrock:UntagResource\",\n                \"bedrock:ListTagsForResource\",\n                \"bedrock:CreateAgent\",\n                \"bedrock:UpdateAgent\",\n                \"bedrock:GetAgent\",\n                \"bedrock:ListAgents\",\n                \"bedrock:DeleteAgent\",\n                \"bedrock:CreateAgentActionGroup\",\n                \"bedrock:UpdateAgentActionGroup\",\n                \"bedrock:GetAgentActionGroup\",\n                \"bedrock:ListAgentActionGroups\",\n                \"bedrock:DeleteAgentActionGroup\",\n                \"bedrock:GetAgentVersion\",\n                \"bedrock:ListAgentVersions\",\n                \"bedrock:DeleteAgentVersion\",\n                \"bedrock:CreateAgentAlias\",\n                \"bedrock:UpdateAgentAlias\",\n                \"bedrock:GetAgentAlias\",\n                \"bedrock:ListAgentAliases\",\n                \"bedrock:DeleteAgentAlias\",\n                \"bedrock:AssociateAgentKnowledgeBase\",\n                \"bedrock:DisassociateAgentKnowledgeBase\",\n                \"bedrock:GetKnowledgeBase\",\n                \"bedrock:ListKnowledgeBases\",\n                \"bedrock:PrepareAgent\",\n                \"bedrock:InvokeAgent\",\n                \"bedrock:InvokeModel\"\n            ],\n            \"Resource\": \"*\"\n        }\n    ]\n}";
                logger.info("Policy Document: {}", (Object)policyDocument);
                iamClient.putRolePolicy((PutRolePolicyRequest)PutRolePolicyRequest.builder().roleName(roleName).policyName(ROLE_POLICY_NAME).policyDocument(policyDocument).build());
                agentRole = (Role)Role.builder().roleName(roleName).arn(createRoleResponse.role().arn()).build();
            }
            catch (IamException ex) {
                logger.error("Couldn't create role {}. Here's why: {}", new Object[]{roleName, ex.getMessage(), ex});
                throw ex;
            }
        }
        catch (IamException ex) {
            logger.error("Couldn't get role {}. Here's why: {}", new Object[]{roleName, ex.getMessage(), ex});
            throw ex;
        }
        return agentRole;
    }

    private static Agent createAgent(String name, String instruction, String modelId, Role agentRole, BedrockAgentClient bedrockAgentClient) {
        logger.info("Creating the agent...");
        CreateAgentResponse createAgentResponse = bedrockAgentClient.createAgent((CreateAgentRequest)CreateAgentRequest.builder().agentName(name).foundationModel(modelId).instruction(instruction).agentResourceRoleArn(agentRole.arn()).build());
        AwsbedrockAgentsPayloadHelper.waitForAgentStatus(createAgentResponse.agent().agentId(), AgentStatus.NOT_PREPARED.toString(), bedrockAgentClient);
        return createAgentResponse.agent();
    }

    private static void waitForAgentStatus(String agentId, String status, BedrockAgentClient bedrockAgentClient) {
        GetAgentResponse response;
        while (!(response = bedrockAgentClient.getAgent((GetAgentRequest)GetAgentRequest.builder().agentId(agentId).build())).agent().agentStatus().toString().equals(status)) {
            try {
                logger.info("Waiting for agent get prepared...");
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static PrepareAgentResponse prepareAgent(String agentId, BedrockAgentClient bedrockAgentClient) {
        logger.info("Preparing the agent...");
        PrepareAgentResponse preparedAgentDetails = bedrockAgentClient.prepareAgent((PrepareAgentRequest)PrepareAgentRequest.builder().agentId(agentId).build());
        AwsbedrockAgentsPayloadHelper.waitForAgentStatus(agentId, "PREPARED", bedrockAgentClient);
        return preparedAgentDetails;
    }

    private static AgentAlias createAgentAlias(String alias, String agentId, BedrockAgentClient bedrockAgentClient) {
        logger.info("Creating an agent alias for agentId: {}", (Object)agentId);
        CreateAgentAliasRequest request = (CreateAgentAliasRequest)CreateAgentAliasRequest.builder().agentId(agentId).agentAliasName(alias).build();
        CreateAgentAliasResponse response = bedrockAgentClient.createAgentAlias(request);
        return response.agentAlias();
    }

    public static String listAllAgentAliases(String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameters);
            List<AgentAliasSummary> agentAliasSummaries = AwsbedrockAgentsPayloadHelper.listAgentAliases(agentId, bedrockAgent);
            JSONArray jsonArray = new JSONArray();
            for (AgentAliasSummary agentAliasSummary : agentAliasSummaries) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(AGENT_ALIAS_ID, (Object)agentAliasSummary.agentAliasId());
                jsonObject.put(AGENT_ALIAS_NAME, (Object)agentAliasSummary.agentAliasName());
                jsonObject.put(CREATED_AT, (Object)agentAliasSummary.createdAt());
                jsonObject.put(UPDATED_AT, (Object)agentAliasSummary.updatedAt());
                jsonArray.put((Object)jsonObject);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(AGENT_ALIAS_SUMMARIES, (Object)jsonArray);
            return jsonObject.toString();
        });
    }

    private static List<AgentAliasSummary> listAgentAliases(String agentId, BedrockAgentClient bedrockAgentClient) {
        ListAgentAliasesRequest listAgentAliasesRequest = (ListAgentAliasesRequest)ListAgentAliasesRequest.builder().agentId(agentId).build();
        ListAgentAliasesResponse listAgentAliasesResponse = bedrockAgentClient.listAgentAliases(listAgentAliasesRequest);
        List agentAliasSummaries = listAgentAliasesResponse.agentAliasSummaries();
        return agentAliasSummaries;
    }

    public static String deleteAgentAliasesByAgentId(String agentId, String agentAliasName, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameters);
            DeleteAgentAliasResponse response = AwsbedrockAgentsPayloadHelper.deleteAgentAliasByName(agentId, agentAliasName, bedrockAgent);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(AGENT_ID, (Object)response.agentId());
            jsonObject.put(AGENT_ALIAS_ID, (Object)response.agentAliasId());
            jsonObject.put(AGENT_ALIAS_STATUS, (Object)response.agentAliasStatus());
            jsonObject.put(AGENT_STATUS, (Object)response.agentAliasStatusAsString());
            return jsonObject.toString();
        });
    }

    private static DeleteAgentAliasResponse deleteAgentAliasByName(String agentId, String agentAliasName, BedrockAgentClient bedrockAgentClient) {
        DeleteAgentAliasResponse response = null;
        ListAgentAliasesRequest listAgentAliasesRequest = (ListAgentAliasesRequest)ListAgentAliasesRequest.builder().agentId(agentId).build();
        ListAgentAliasesResponse listAgentAliasesResponse = bedrockAgentClient.listAgentAliases(listAgentAliasesRequest);
        List agentAliasSummaries = listAgentAliasesResponse.agentAliasSummaries();
        Optional<AgentAliasSummary> agentAliasSummary = agentAliasSummaries.stream().filter(alias -> alias.agentAliasName().equals(agentAliasName)).findFirst();
        if (agentAliasSummary.isPresent()) {
            String agentAliasId = agentAliasSummary.get().agentAliasId();
            DeleteAgentAliasRequest deleteAgentAliasRequest = (DeleteAgentAliasRequest)DeleteAgentAliasRequest.builder().agentId(agentId).agentAliasId(agentAliasId).build();
            DeleteAgentAliasResponse deleteAgentAliasResponse = bedrockAgentClient.deleteAgentAlias(deleteAgentAliasRequest);
            logger.info("Agent alias with name " + agentAliasName + " deleted successfully.");
            response = deleteAgentAliasResponse;
        } else {
            logger.info("No agent alias with name " + agentAliasName + " found.");
        }
        return response;
    }

    public static String deleteAgentByAgentId(String agentId, AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentClient bedrockAgent = BedrockClients.getAgentClient(configuration, awsBedrockParameters);
            DeleteAgentResponse response = AwsbedrockAgentsPayloadHelper.deleteAgentById(agentId, bedrockAgent);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(AGENT_ID, (Object)response.agentId());
            jsonObject.put(AGENT_STATUS, (Object)response.agentStatusAsString());
            return jsonObject.toString();
        });
    }

    private static DeleteAgentResponse deleteAgentById(String agentId, BedrockAgentClient bedrockAgentClient) {
        DeleteAgentRequest deleteAgentRequest = (DeleteAgentRequest)DeleteAgentRequest.builder().agentId(agentId).build();
        DeleteAgentResponse deleteAgentResponse = bedrockAgentClient.deleteAgent(deleteAgentRequest);
        return deleteAgentResponse;
    }

    public static String chatWithAgent(String agentAlias, String agentId, String prompt, Boolean enableTrace, Boolean latencyOptimized, AwsbedrockConfiguration configuration, AwsbedrockAgentsSessionParameters awsbedrockAgentsSessionParameters, AwsbedrockAgentsFilteringParameters awsBedrockAgentsFilteringParameters, AwsbedrockAgentsParameters awsbedrockAgentsParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentRuntimeAsyncClient bedrockAgentRuntimeAsyncClient = BedrockClients.getAgentRuntimeAsyncClient(configuration, awsbedrockAgentsParameters);
            String sessionId = awsbedrockAgentsSessionParameters.getSessionId();
            String effectiveSessionId = sessionId != null && !sessionId.isEmpty() ? sessionId : UUID.randomUUID().toString();
            logger.info("Using sessionId: {}", (Object)effectiveSessionId);
            return (String)((CompletableFuture)AwsbedrockAgentsPayloadHelper.invokeAgent(agentAlias, agentId, prompt, enableTrace, latencyOptimized, effectiveSessionId, awsbedrockAgentsSessionParameters.getExcludePreviousThinkingSteps(), awsbedrockAgentsSessionParameters.getPreviousConversationTurnsToInclude(), awsBedrockAgentsFilteringParameters.getKnowledgeBaseId(), awsBedrockAgentsFilteringParameters.getNumberOfResults(), awsBedrockAgentsFilteringParameters.getRetrievalMetadataFilterType(), awsBedrockAgentsFilteringParameters.getMetadataFilters(), bedrockAgentRuntimeAsyncClient).thenApply(response -> {
                logger.debug(response);
                return response;
            })).join();
        });
    }

    private static CompletableFuture<String> invokeAgent(String agentAlias, String agentId, String prompt, Boolean enableTrace, Boolean latencyOptimized, String sessionId, Boolean excludePreviousThinkingSteps, Integer previousConversationTurnsToInclude, String knowledgeBaseId, Integer numberOfResults, AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType filterType, Map<String, String> metadataFilters, BedrockAgentRuntimeAsyncClient bedrockAgentRuntimeAsyncClient) {
        long startTime = System.currentTimeMillis();
        InvokeAgentRequest request = (InvokeAgentRequest)InvokeAgentRequest.builder().agentId(agentId).agentAliasId(agentAlias).sessionId(sessionId).inputText(prompt).enableTrace(enableTrace).sessionState(AwsbedrockAgentsPayloadHelper.buildSessionState(knowledgeBaseId, numberOfResults, filterType, metadataFilters)).bedrockModelConfigurations(AwsbedrockAgentsPayloadHelper.buildModelConfigurations(latencyOptimized)).promptCreationConfigurations(AwsbedrockAgentsPayloadHelper.buildPromptConfigurations(excludePreviousThinkingSteps, previousConversationTurnsToInclude)).build();
        CompletableFuture<String> completionFuture = new CompletableFuture<String>();
        List chunks = Collections.synchronizedList(new ArrayList());
        InvokeAgentResponseHandler.Visitor visitor = InvokeAgentResponseHandler.Visitor.builder().onChunk(chunk -> {
            JSONObject chunkData = new JSONObject();
            chunkData.put(TYPE, (Object)CHUNK);
            chunkData.put(TIMESTAMP, (Object)Instant.now().toString());
            if (chunk.bytes() != null) {
                String text = new String(chunk.bytes().asByteArray(), StandardCharsets.UTF_8);
                chunkData.put(TEXT, (Object)text);
            }
            if (chunk.attribution() != null && chunk.attribution().citations() != null) {
                JSONArray citationsArray = new JSONArray();
                chunk.attribution().citations().forEach(citation -> {
                    JSONObject citationData = new JSONObject();
                    if (citation.generatedResponsePart() != null && citation.generatedResponsePart().textResponsePart() != null) {
                        citationData.put(GENERATED_RESPONSE_PART, (Object)citation.generatedResponsePart().textResponsePart().text());
                    }
                    if (citation.retrievedReferences() != null) {
                        JSONArray referencesArray = new JSONArray();
                        citation.retrievedReferences().forEach(ref -> {
                            JSONObject refData = new JSONObject();
                            if (ref.content() != null && ref.content().text() != null) {
                                refData.put(CONTENT, (Object)ref.content().text());
                            }
                            if (ref.location() != null) {
                                refData.put(LOCATION, (Object)ref.location().toString());
                            }
                            if (ref.metadata() != null) {
                                JSONObject metadataObject = new JSONObject(ref.metadata());
                                refData.put(METADATA, (Object)metadataObject);
                            }
                            referencesArray.put((Object)refData);
                        });
                        citationData.put(RETRIEVED_REFERENCES, (Object)referencesArray);
                    }
                    citationsArray.put((Object)citationData);
                });
                chunkData.put(CITATIONS, (Object)citationsArray);
            }
            chunks.add(chunkData);
        }).build();
        InvokeAgentResponseHandler handler = InvokeAgentResponseHandler.builder().subscriber(visitor).build();
        CompletableFuture invocationFuture = bedrockAgentRuntimeAsyncClient.invokeAgent(request, handler);
        invocationFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                completionFuture.completeExceptionally((Throwable)throwable);
            } else {
                JSONObject finalResult = new JSONObject();
                finalResult.put(SESSION_ID, (Object)sessionId);
                finalResult.put(AGENT_ID, (Object)agentId);
                finalResult.put(AGENT_ALIAS, (Object)agentAlias);
                finalResult.put(PROMPT, (Object)prompt);
                finalResult.put(PROCESSED_AT, (Object)Instant.now().toString());
                finalResult.put(CHUNKS, (Object)new JSONArray((Collection)chunks));
                JSONObject summary = new JSONObject();
                summary.put(TOTAL_CHUNKS, chunks.size());
                StringBuilder fullText = new StringBuilder();
                chunks.forEach(chunk -> {
                    if (chunk.has(TEXT)) {
                        fullText.append(chunk.getString(TEXT));
                    }
                });
                summary.put(FULL_RESPONSE, (Object)fullText.toString());
                long endTime = System.currentTimeMillis();
                summary.put("total_duration_ms", endTime - startTime);
                finalResult.put(SUMMARY, (Object)summary);
                String finalJson = finalResult.toString();
                completionFuture.complete(finalJson);
            }
        });
        return completionFuture;
    }

    public static InputStream chatWithAgentSSEStream(String agentAlias, String agentId, String prompt, Boolean enableTrace, Boolean latencyOptimized, AwsbedrockConfiguration configuration, AwsbedrockAgentsSessionParameters awsBedrockSessionParameters, AwsbedrockAgentsFilteringParameters awsBedrockAgentsFilteringParameters, AwsbedrockAgentsParameters awsBedrockParameters) {
        return BedrockClientInvoker.executeWithErrorHandling(() -> {
            BedrockAgentRuntimeAsyncClient bedrockAgentRuntimeAsyncClient = BedrockClients.getAgentRuntimeAsyncClient(configuration, awsBedrockParameters);
            String sessionId = awsBedrockSessionParameters.getSessionId();
            String effectiveSessionId = sessionId != null && !sessionId.isEmpty() ? sessionId : UUID.randomUUID().toString();
            logger.info("Using sessionId: {}", (Object)effectiveSessionId);
            return AwsbedrockAgentsPayloadHelper.invokeAgentSSEStream(agentAlias, agentId, prompt, enableTrace, latencyOptimized, effectiveSessionId, awsBedrockSessionParameters.getExcludePreviousThinkingSteps(), awsBedrockSessionParameters.getPreviousConversationTurnsToInclude(), awsBedrockAgentsFilteringParameters.getKnowledgeBaseId(), awsBedrockAgentsFilteringParameters.getNumberOfResults(), awsBedrockAgentsFilteringParameters.getRetrievalMetadataFilterType(), awsBedrockAgentsFilteringParameters.getMetadataFilters(), bedrockAgentRuntimeAsyncClient);
        });
    }

    public static InputStream invokeAgentSSEStream(String agentAlias, String agentId, String prompt, Boolean enableTrace, Boolean latencyOptimized, String sessionId, Boolean excludePreviousThinkingSteps, Integer previousConversationTurnsToInclude, String knowledgeBaseId, Integer numberOfResults, AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType filterType, Map<String, String> metadataFilters, BedrockAgentRuntimeAsyncClient bedrockAgentRuntimeAsyncClient) {
        try {
            PipedOutputStream outputStream = new PipedOutputStream();
            PipedInputStream inputStream = new PipedInputStream(outputStream);
            CompletableFuture.runAsync(() -> {
                try {
                    AwsbedrockAgentsPayloadHelper.streamBedrockResponse(agentAlias, agentId, prompt, enableTrace, latencyOptimized, sessionId, excludePreviousThinkingSteps, previousConversationTurnsToInclude, knowledgeBaseId, numberOfResults, filterType, metadataFilters, bedrockAgentRuntimeAsyncClient, outputStream);
                }
                catch (Exception e) {
                    try {
                        String errorEvent = AwsbedrockAgentsPayloadHelper.formatSSEEvent("error", AwsbedrockAgentsPayloadHelper.createErrorJson(e).toString());
                        outputStream.write(errorEvent.getBytes(StandardCharsets.UTF_8));
                        outputStream.flush();
                        outputStream.close();
                        logger.error(errorEvent);
                    }
                    catch (IOException ioException) {
                        logger.error("Error writing error event: {}", (Object)ioException.getMessage());
                    }
                }
            });
            return inputStream;
        }
        catch (IOException e) {
            String errorEvent = AwsbedrockAgentsPayloadHelper.formatSSEEvent("error", AwsbedrockAgentsPayloadHelper.createErrorJson(e).toString());
            logger.error(errorEvent);
            return new ByteArrayInputStream(errorEvent.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void streamBedrockResponse(String agentAlias, String agentId, String prompt, Boolean enableTrace, Boolean latencyOptimized, String sessionId, Boolean excludePreviousThinkingSteps, Integer previousConversationTurnsToInclude, String knowledgeBaseId, Integer numberOfResults, AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType filterType, Map<String, String> metadataFilters, BedrockAgentRuntimeAsyncClient client, PipedOutputStream outputStream) throws ExecutionException, InterruptedException, IOException {
        long startTime = System.currentTimeMillis();
        JSONObject startEvent = AwsbedrockAgentsPayloadHelper.createSessionStartJson(agentAlias, agentId, prompt, sessionId, Instant.now().toString());
        String sseStart = AwsbedrockAgentsPayloadHelper.formatSSEEvent("session-start", startEvent.toString());
        outputStream.write(sseStart.getBytes(StandardCharsets.UTF_8));
        outputStream.flush();
        logger.info(sseStart);
        InvokeAgentRequest request = (InvokeAgentRequest)InvokeAgentRequest.builder().agentId(agentId).agentAliasId(agentAlias).sessionId(sessionId).inputText(prompt).streamingConfigurations(builder -> builder.streamFinalResponse(Boolean.valueOf(true))).enableTrace(enableTrace).sessionState(AwsbedrockAgentsPayloadHelper.buildSessionState(knowledgeBaseId, numberOfResults, filterType, metadataFilters)).bedrockModelConfigurations(AwsbedrockAgentsPayloadHelper.buildModelConfigurations(latencyOptimized)).promptCreationConfigurations(AwsbedrockAgentsPayloadHelper.buildPromptConfigurations(excludePreviousThinkingSteps, previousConversationTurnsToInclude)).build();
        InvokeAgentResponseHandler.Visitor visitor = InvokeAgentResponseHandler.Visitor.builder().onChunk(chunk -> {
            try {
                JSONObject chunkData = AwsbedrockAgentsPayloadHelper.createChunkJson(chunk);
                String sseEvent = AwsbedrockAgentsPayloadHelper.formatSSEEvent(CHUNK, chunkData.toString());
                outputStream.write(sseEvent.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                logger.debug(sseEvent);
            }
            catch (IOException e) {
                try {
                    String errorEvent = AwsbedrockAgentsPayloadHelper.formatSSEEvent("chunk-error", AwsbedrockAgentsPayloadHelper.createErrorJson(e).toString());
                    outputStream.write(errorEvent.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                    logger.error(errorEvent);
                }
                catch (IOException ioException) {
                    logger.error("Error writing error event: {}", (Object)ioException.getMessage());
                }
            }
        }).build();
        InvokeAgentResponseHandler handler = ((InvokeAgentResponseHandler.Builder)InvokeAgentResponseHandler.builder().subscriber(visitor).onComplete(() -> {
            try {
                long endTime = System.currentTimeMillis();
                JSONObject completionData = AwsbedrockAgentsPayloadHelper.createCompletionJson(sessionId, agentId, agentAlias, endTime - startTime);
                String completionEvent = AwsbedrockAgentsPayloadHelper.formatSSEEvent("session-complete", completionData.toString());
                outputStream.write(completionEvent.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                logger.info(completionEvent);
            }
            catch (IOException e) {
                try {
                    String errorEvent = AwsbedrockAgentsPayloadHelper.formatSSEEvent("completion-error", AwsbedrockAgentsPayloadHelper.createErrorJson(e).toString());
                    outputStream.write(errorEvent.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                    logger.error(errorEvent);
                }
                catch (IOException ioException) {
                    logger.error("Error writing error event: {}", (Object)ioException.getMessage());
                }
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException ioException) {
                    logger.error("Error writing error event: {}", (Object)ioException.getMessage());
                }
            }
        })).build();
        CompletableFuture invocationFuture = client.invokeAgent(request, handler);
        invocationFuture.get();
    }

    private static JSONObject createChunkJson(PayloadPart chunk) {
        JSONObject chunkData = new JSONObject();
        chunkData.put(TYPE, (Object)CHUNK);
        chunkData.put(TIMESTAMP, (Object)Instant.now().toString());
        try {
            if (chunk.bytes() != null) {
                String text = new String(chunk.bytes().asByteArray(), StandardCharsets.UTF_8);
                chunkData.put(TEXT, (Object)text);
            }
        }
        catch (Exception e) {
            chunkData.put("error", (Object)("Error processing chunk: " + e.getMessage()));
        }
        return chunkData;
    }

    private static JSONObject createSessionStartJson(String agentAlias, String agentId, String prompt, String sessionId, String timestamp) {
        JSONObject startData = new JSONObject();
        startData.put(SESSION_ID, (Object)sessionId);
        startData.put(AGENT_ID, (Object)agentId);
        startData.put(AGENT_ALIAS, (Object)agentAlias);
        startData.put(PROMPT, (Object)prompt);
        startData.put(PROCESSED_AT, (Object)timestamp);
        startData.put("status", (Object)"started");
        return startData;
    }

    private static JSONObject createCompletionJson(String sessionId, String agentId, String agentAlias, long duration) {
        JSONObject completionData = new JSONObject();
        completionData.put(SESSION_ID, (Object)sessionId);
        completionData.put(AGENT_ID, (Object)agentId);
        completionData.put(AGENT_ALIAS, (Object)agentAlias);
        completionData.put("status", (Object)"completed");
        completionData.put("total_duration_ms", duration);
        completionData.put(TIMESTAMP, (Object)Instant.now().toString());
        return completionData;
    }

    private static JSONObject createErrorJson(Throwable error) {
        JSONObject errorData = new JSONObject();
        errorData.put("error", (Object)error.getMessage());
        errorData.put(TYPE, (Object)error.getClass().getSimpleName());
        errorData.put(TIMESTAMP, (Object)Instant.now().toString());
        return errorData;
    }

    private static String formatSSEEvent(String eventType, String data) {
        int eventId = eventCounter.incrementAndGet();
        return String.format("id: %d%nevent: %s%ndata: %s%n%n", eventId, eventType, data);
    }

    private static Consumer<SessionState.Builder> buildSessionState(String knowledgeBaseId, Integer numberOfResults, AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType filterType, Map<String, String> metadataFilters) {
        return sessionStateBuilder -> {
            KnowledgeBaseVectorSearchConfiguration vectorSearchConfig = AwsbedrockAgentsPayloadHelper.buildVectorSearchConfiguration(numberOfResults, filterType, metadataFilters);
            if (vectorSearchConfig != null && knowledgeBaseId != null) {
                sessionStateBuilder.knowledgeBaseConfigurations(new Consumer[]{kbConfigBuilder -> kbConfigBuilder.knowledgeBaseId(knowledgeBaseId).retrievalConfiguration(retrievalConfigBuilder -> retrievalConfigBuilder.vectorSearchConfiguration(vectorSearchConfig))});
            }
        };
    }

    private static KnowledgeBaseVectorSearchConfiguration buildVectorSearchConfiguration(Integer numberOfResults, AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType filterType, Map<String, String> metadataFilters) {
        if (metadataFilters == null || metadataFilters.isEmpty()) {
            return null;
        }
        Map<String, String> nonEmptyFilters = metadataFilters.entrySet().stream().filter(entry -> entry.getValue() != null && !((String)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (nonEmptyFilters.isEmpty()) {
            return null;
        }
        Consumer<KnowledgeBaseVectorSearchConfiguration.Builder> applyOptionalNumberOfResults = b -> {
            if (numberOfResults != null && numberOfResults > 0) {
                b.numberOfResults(numberOfResults);
            }
        };
        if (nonEmptyFilters.size() > 1) {
            List retrievalFilters = nonEmptyFilters.entrySet().stream().map(entry -> (RetrievalFilter)RetrievalFilter.builder().equalsValue((FilterAttribute)FilterAttribute.builder().key((String)entry.getKey()).value(Document.fromString((String)((String)entry.getValue()))).build()).build()).collect(Collectors.toList());
            RetrievalFilter compositeFilter = (RetrievalFilter)((RetrievalFilter.Builder)RetrievalFilter.builder().applyMutation(builder -> {
                if (filterType == AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType.AND_ALL) {
                    builder.andAll((Collection)retrievalFilters);
                } else if (filterType == AwsbedrockAgentsFilteringParameters.RetrievalMetadataFilterType.OR_ALL) {
                    builder.orAll((Collection)retrievalFilters);
                }
            })).build();
            return (KnowledgeBaseVectorSearchConfiguration)((KnowledgeBaseVectorSearchConfiguration.Builder)KnowledgeBaseVectorSearchConfiguration.builder().filter(compositeFilter).applyMutation(applyOptionalNumberOfResults)).build();
        }
        String key = nonEmptyFilters.entrySet().iterator().next().getKey();
        return (KnowledgeBaseVectorSearchConfiguration)((KnowledgeBaseVectorSearchConfiguration.Builder)KnowledgeBaseVectorSearchConfiguration.builder().filter(retrievalFilter -> retrievalFilter.equalsValue((FilterAttribute)FilterAttribute.builder().key(key).value(Document.fromString((String)((String)nonEmptyFilters.get(key)))).build()).build()).applyMutation(applyOptionalNumberOfResults)).build();
    }

    private static Consumer<BedrockModelConfigurations.Builder> buildModelConfigurations(Boolean isLatencyOptimized) {
        return builder -> builder.performanceConfig(performanceConfig -> performanceConfig.latency(isLatencyOptimized != false ? "optimized" : "standard"));
    }

    private static Consumer<PromptCreationConfigurations.Builder> buildPromptConfigurations(Boolean excludePreviousThinkingSteps, Integer previousConversationTurnsToInclude) {
        return builder -> builder.excludePreviousThinkingSteps(excludePreviousThinkingSteps).previousConversationTurnsToInclude(previousConversationTurnsToInclude);
    }
}

