/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.extension.mulechain.helpers.BedrockClients;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.AwsbedrockParameters;
import org.mule.extension.mulechain.internal.AwsbedrockParams;
import org.mule.extension.mulechain.internal.AwsbedrockParamsModelDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.model.CustomModelSummary;
import software.amazon.awssdk.services.bedrock.model.FoundationModelDetails;
import software.amazon.awssdk.services.bedrock.model.FoundationModelSummary;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest;
import software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ListFoundationModelsResponse;
import software.amazon.awssdk.services.bedrock.model.ValidationException;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class AwsbedrockPayloadHelper {
    private static final Logger logger = LoggerFactory.getLogger(AwsbedrockPayloadHelper.class);

    private static InvokeModelRequest createInvokeRequest(AwsbedrockParameters awsBedrockParameters, String nativeRequest) {
        Object modelId = awsBedrockParameters.getModelName();
        logger.debug("modelId: {}", modelId);
        String accountId = awsBedrockParameters.getAwsAccountId() != null && !awsBedrockParameters.getAwsAccountId().isBlank() ? awsBedrockParameters.getAwsAccountId() : "076261412953";
        logger.debug("accountId: {}", (Object)accountId);
        String region = awsBedrockParameters.getRegion();
        if (((String)modelId).contains("amazon.nova-premier") || ((String)modelId).contains("anthropic.claude-3") || ((String)modelId).contains("mistral.pixtral") || ((String)modelId).contains("meta.llama4") || ((String)modelId).contains("meta.llama3-3") || ((String)modelId).contains("meta.llama3-2") || ((String)modelId).contains("meta.llama3-1")) {
            modelId = "arn:aws:bedrock:" + region + ":" + accountId + ":inference-profile/us." + (String)modelId;
        }
        String guardrailIdentifier = awsBedrockParameters.getGuardrailIdentifier();
        String guardrailVersion = awsBedrockParameters.getGuardrailVersion();
        InvokeModelRequest request = guardrailIdentifier != null && !guardrailIdentifier.isEmpty() && guardrailVersion != null && !guardrailVersion.isEmpty() ? (InvokeModelRequest)InvokeModelRequest.builder().modelId((String)modelId).body(SdkBytes.fromUtf8String((String)nativeRequest)).contentType("application/json").guardrailIdentifier(guardrailIdentifier).guardrailVersion(guardrailVersion).build() : (InvokeModelRequest)InvokeModelRequest.builder().body(SdkBytes.fromUtf8String((String)nativeRequest)).modelId((String)modelId).build();
        return request;
    }

    private static String getAmazonTitanText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("inputText", (Object)prompt);
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        textGenerationConfig.put("topP", (Object)awsBedrockParameters.getTopP());
        textGenerationConfig.put("maxTokenCount", (Object)awsBedrockParameters.getMaxTokenCount());
        jsonRequest.put("textGenerationConfig", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAmazonNovaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject textObject = new JSONObject();
        textObject.put("text", (Object)prompt);
        JSONArray contentArray = new JSONArray();
        contentArray.put((Object)textObject);
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)contentArray);
        JSONArray messagesArray = new JSONArray();
        messagesArray.put((Object)userMessage);
        JSONObject inferenceConfig = new JSONObject();
        inferenceConfig.put("max_new_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        inferenceConfig.put("temperature", (Object)awsBedrockParameters.getTemperature());
        inferenceConfig.put("top_p", (Object)awsBedrockParameters.getTopP());
        inferenceConfig.put("top_k", (Object)awsBedrockParameters.getTopK());
        JSONObject rootObject = new JSONObject();
        rootObject.put("messages", (Object)messagesArray);
        rootObject.put("inferenceConfig", (Object)inferenceConfig);
        return rootObject.toString();
    }

    private static String getStabilityTitanText(String prompt) {
        JSONObject jsonRequest = new JSONObject();
        JSONObject textGenerationConfig = new JSONObject();
        textGenerationConfig.put("text", (Object)prompt);
        jsonRequest.put("text_prompts", (Object)textGenerationConfig);
        return jsonRequest.toString();
    }

    private static String getAnthropicClaudeText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject userMessage = new JSONObject();
        userMessage.put("role", (Object)"user");
        userMessage.put("content", (Object)prompt);
        JSONArray messages = new JSONArray();
        messages.put((Object)userMessage);
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("messages", (Object)messages);
        jsonRequest.put("anthropic_version", (Object)"bedrock-2023-05-31");
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getMistralAIText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        if (awsBedrockParameters.getModelName().contains("mistral.pixtral")) {
            JSONObject userMessage = new JSONObject();
            userMessage.put("role", (Object)"user");
            userMessage.put("content", (Object)prompt);
            JSONArray messages = new JSONArray();
            messages.put((Object)userMessage);
            jsonRequest.put("messages", (Object)messages);
        } else {
            jsonRequest.put("prompt", (Object)("\n\nHuman:" + prompt + "\n\nAssistant:"));
        }
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getAI21Text(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject message = new JSONObject();
        message.put("role", (Object)"user");
        message.put("content", (Object)prompt);
        JSONArray messages = new JSONArray();
        messages.put((Object)message);
        JSONObject body = new JSONObject();
        body.put("messages", (Object)messages);
        body.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        body.put("top_p", (Object)awsBedrockParameters.getTopP());
        body.put("temperature", (Object)awsBedrockParameters.getTemperature());
        return body.toString();
    }

    private static String getCohereText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("k", (Object)awsBedrockParameters.getTopK());
        jsonRequest.put("max_tokens", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String getLlamaText(String prompt, AwsbedrockParameters awsBedrockParameters) {
        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("prompt", (Object)prompt);
        jsonRequest.put("temperature", (Object)awsBedrockParameters.getTemperature());
        jsonRequest.put("top_p", (Object)awsBedrockParameters.getTopP());
        jsonRequest.put("max_gen_len", (Object)awsBedrockParameters.getMaxTokenCount());
        return jsonRequest.toString();
    }

    private static String identifyPayload(String prompt, AwsbedrockParameters awsBedrockParameters) {
        if (awsBedrockParameters.getModelName().contains("amazon.titan-text")) {
            return AwsbedrockPayloadHelper.getAmazonTitanText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("amazon.nova")) {
            logger.info("Generating payload for nova");
            return AwsbedrockPayloadHelper.getAmazonNovaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("anthropic.claude")) {
            return AwsbedrockPayloadHelper.getAnthropicClaudeText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("ai21.jamba")) {
            return AwsbedrockPayloadHelper.getAI21Text(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("mistral")) {
            return AwsbedrockPayloadHelper.getMistralAIText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("cohere.command")) {
            return AwsbedrockPayloadHelper.getCohereText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("meta.llama")) {
            return AwsbedrockPayloadHelper.getLlamaText(prompt, awsBedrockParameters);
        }
        if (awsBedrockParameters.getModelName().contains("stability.stable")) {
            return AwsbedrockPayloadHelper.getStabilityTitanText(prompt);
        }
        return "Unsupported model";
    }

    public static String invokeModel(String prompt, AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        BedrockRuntimeClient client = BedrockClients.getRuntimeClient(configuration, awsBedrockParameters);
        String nativeRequest = AwsbedrockPayloadHelper.identifyPayload(prompt, awsBedrockParameters);
        try {
            InvokeModelRequest request = AwsbedrockPayloadHelper.createInvokeRequest(awsBedrockParameters, nativeRequest);
            logger.info("Native request: {}", (Object)nativeRequest);
            InvokeModelResponse response = client.invokeModel(request);
            return AwsbedrockPayloadHelper.formatBedrockResponse(awsBedrockParameters, response);
        }
        catch (SdkClientException e) {
            System.err.printf("ERROR: Can't invoke '%s'. Reason: %s", awsBedrockParameters.getModelName(), e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static String formatBedrockResponse(AwsbedrockParameters awsBedrockParameters, InvokeModelResponse response) {
        String modelId = awsBedrockParameters.getModelName();
        String modelGroup = modelId.contains("claude") ? "claude" : (modelId.contains("mistral.pixtral") ? "mistral.pixtral" : (modelId.contains("mistral.mistral") ? "mistral.mistral" : (modelId.contains("jamba") ? "jamba" : (modelId.contains("llama") ? "llama" : (modelId.contains("titan") ? "titan" : "default")))));
        switch (modelGroup) {
            case "claude": {
                return AwsbedrockPayloadHelper.formatClaudeResponse(response);
            }
            case "mistral.pixtral": {
                return AwsbedrockPayloadHelper.formatMistralPixtralResponse(response);
            }
            case "mistral.mistral": {
                return AwsbedrockPayloadHelper.formatMistralMistralResponse(response);
            }
            case "jamba": {
                return AwsbedrockPayloadHelper.formatJambaResponse(response);
            }
            case "llama": {
                return AwsbedrockPayloadHelper.formatLlamaResponse(response);
            }
            case "titan": {
                return AwsbedrockPayloadHelper.formatTitanResponse(response);
            }
        }
        JSONObject responseBody = new JSONObject(response.body().asUtf8String());
        String responseStr = responseBody.toString();
        return responseStr;
    }

    private static String formatTitanResponse(InvokeModelResponse response) {
        String rawJson = response.body().asUtf8String();
        JSONObject original = new JSONObject(rawJson);
        JSONArray results = original.getJSONArray("results");
        JSONObject result0 = results.getJSONObject(0);
        String text = result0.getString("outputText").trim();
        String stopReason = result0.optString("completionReason", "").equalsIgnoreCase("FINISH") ? "end_turn" : "unknown";
        String guardrail = original.optString("amazon-bedrock-guardrailAction", "NONE");
        int inputTokens = original.optInt("inputTextTokenCount", 0);
        int outputTokens = result0.optInt("tokenCount", 0);
        int totalTokens = inputTokens + outputTokens;
        JSONObject textObj = new JSONObject();
        textObj.put("text", (Object)text);
        JSONArray contentArray = new JSONArray().put((Object)textObj);
        JSONObject message = new JSONObject();
        message.put("role", (Object)"assistant");
        message.put("content", (Object)contentArray);
        JSONObject output = new JSONObject();
        output.put("message", (Object)message);
        JSONObject usage = new JSONObject();
        usage.put("inputTokens", inputTokens);
        usage.put("outputTokens", outputTokens);
        usage.put("totalTokens", totalTokens);
        JSONObject finalResult = new JSONObject();
        finalResult.put("output", (Object)output);
        finalResult.put("stopReason", (Object)stopReason);
        finalResult.put("usage", (Object)usage);
        finalResult.put("amazon-bedrock-guardrailAction", (Object)guardrail);
        logger.info(finalResult.toString(2));
        return finalResult.toString();
    }

    private static String formatJambaResponse(InvokeModelResponse response) {
        String rawJson = response.body().asUtf8String();
        JSONObject original = new JSONObject(rawJson);
        JSONObject choice = original.getJSONArray("choices").getJSONObject(0);
        JSONObject message = choice.getJSONObject("message");
        String role = message.getString("role");
        String text = message.getString("content").trim();
        String stopReason = choice.optString("finish_reason", "stop");
        int inputTokens = original.getJSONObject("usage").getInt("prompt_tokens");
        int outputTokens = original.getJSONObject("usage").getInt("completion_tokens");
        int totalTokens = original.getJSONObject("usage").getInt("total_tokens");
        String guardrail = original.optString("amazon-bedrock-guardrailAction", "NONE");
        JSONObject textObj = new JSONObject();
        textObj.put("text", (Object)text);
        JSONArray contentArray = new JSONArray().put((Object)textObj);
        JSONObject newMessage = new JSONObject();
        newMessage.put("role", (Object)role);
        newMessage.put("content", (Object)contentArray);
        JSONObject output = new JSONObject();
        output.put("message", (Object)newMessage);
        JSONObject usage = new JSONObject();
        usage.put("inputTokens", inputTokens);
        usage.put("outputTokens", outputTokens);
        usage.put("totalTokens", totalTokens);
        JSONObject finalResult = new JSONObject();
        finalResult.put("output", (Object)output);
        finalResult.put("stopReason", (Object)(stopReason.equals("stop") ? "end_turn" : stopReason));
        finalResult.put("usage", (Object)usage);
        finalResult.put("amazon-bedrock-guardrailAction", (Object)guardrail);
        logger.info(finalResult.toString(2));
        return finalResult.toString();
    }

    private static String formatClaudeResponse(InvokeModelResponse response) {
        String rawJson = response.body().asUtf8String();
        JSONObject original = new JSONObject(rawJson);
        JSONArray contentArray = original.getJSONArray("content");
        JSONObject firstContentObj = contentArray.getJSONObject(0);
        String originalText = firstContentObj.getString("text");
        JSONObject usageOriginal = original.getJSONObject("usage");
        int inputTokens = usageOriginal.getInt("input_tokens");
        int outputTokens = usageOriginal.getInt("output_tokens");
        int totalTokens = inputTokens + outputTokens;
        JSONObject usage = new JSONObject();
        usage.put("inputTokens", inputTokens);
        usage.put("outputTokens", outputTokens);
        usage.put("totalTokens", totalTokens);
        JSONArray newContentArray = new JSONArray();
        JSONObject textObject = new JSONObject();
        textObject.put("text", (Object)originalText);
        newContentArray.put((Object)textObject);
        JSONObject message = new JSONObject();
        message.put("role", (Object)original.getString("role"));
        message.put("content", (Object)newContentArray);
        JSONObject output = new JSONObject();
        output.put("message", (Object)message);
        JSONObject finalPayload = new JSONObject();
        finalPayload.put("output", (Object)output);
        finalPayload.put("stopReason", (Object)original.optString("stop_reason", "end_turn"));
        finalPayload.put("usage", (Object)usage);
        finalPayload.put("amazon-bedrock-guardrailAction", (Object)original.optString("amazon-bedrock-guardrailAction", "NONE"));
        logger.info(finalPayload.toString(2));
        return finalPayload.toString();
    }

    private static String formatLlamaResponse(InvokeModelResponse response) {
        String rawJson = response.body().asUtf8String();
        JSONObject original = new JSONObject(rawJson);
        String generationText = original.getString("generation");
        int inputTokens = original.getInt("prompt_token_count");
        int outputTokens = original.getInt("generation_token_count");
        String stopReason = original.optString("stop_reason", "stop");
        JSONObject textObj = new JSONObject();
        textObj.put("text", (Object)generationText.trim());
        JSONArray contentArray = new JSONArray().put((Object)textObj);
        JSONObject message = new JSONObject();
        message.put("role", (Object)"assistant");
        message.put("content", (Object)contentArray);
        JSONObject output = new JSONObject();
        output.put("message", (Object)message);
        JSONObject usage = new JSONObject();
        usage.put("inputTokens", inputTokens);
        usage.put("outputTokens", outputTokens);
        usage.put("totalTokens", inputTokens + outputTokens);
        JSONObject finalPayload = new JSONObject();
        finalPayload.put("output", (Object)output);
        finalPayload.put("stopReason", (Object)(stopReason.equals("stop") ? "end_turn" : stopReason));
        finalPayload.put("usage", (Object)usage);
        finalPayload.put("amazon-bedrock-guardrailAction", (Object)original.optString("amazon-bedrock-guardrailAction", "NONE"));
        logger.info(finalPayload.toString(2));
        return finalPayload.toString();
    }

    private static String formatMistralMistralResponse(InvokeModelResponse response) {
        String rawJson = response.body().asUtf8String();
        JSONObject original = new JSONObject(rawJson);
        JSONArray outputs = original.getJSONArray("outputs");
        JSONObject output0 = outputs.getJSONObject(0);
        String text = output0.getString("text").trim();
        String stopReason = output0.optString("stop_reason", "stop");
        String guardrail = original.optString("amazon-bedrock-guardrailAction", "NONE");
        JSONObject textObj = new JSONObject();
        textObj.put("text", (Object)text);
        JSONArray contentArray = new JSONArray().put((Object)textObj);
        JSONObject message = new JSONObject();
        message.put("role", (Object)"assistant");
        message.put("content", (Object)contentArray);
        JSONObject output = new JSONObject();
        output.put("message", (Object)message);
        JSONObject usage = new JSONObject();
        usage.put("inputTokens", JSONObject.NULL);
        usage.put("outputTokens", JSONObject.NULL);
        usage.put("totalTokens", JSONObject.NULL);
        JSONObject finalPayload = new JSONObject();
        finalPayload.put("output", (Object)output);
        finalPayload.put("stopReason", (Object)(stopReason.equals("stop") ? "end_turn" : stopReason));
        finalPayload.put("usage", (Object)usage);
        finalPayload.put("amazon-bedrock-guardrailAction", (Object)guardrail);
        logger.info(finalPayload.toString(2));
        return finalPayload.toString();
    }

    private static String formatMistralPixtralResponse(InvokeModelResponse response) {
        String rawJson = response.body().asUtf8String();
        JSONObject original = new JSONObject(rawJson);
        JSONObject choice = original.getJSONArray("choices").getJSONObject(0);
        JSONObject messageObj = choice.getJSONObject("message");
        String content = messageObj.getString("content").trim();
        String role = messageObj.optString("role", "assistant");
        String stopReason = choice.optString("finish_reason", "stop");
        String guardrail = original.optString("amazon-bedrock-guardrailAction", "NONE");
        JSONObject usageObj = original.optJSONObject("usage");
        Object inputTokens = usageObj != null && usageObj.has("prompt_tokens") ? usageObj.get("prompt_tokens") : JSONObject.NULL;
        Object outputTokens = usageObj != null && usageObj.has("completion_tokens") ? usageObj.get("completion_tokens") : JSONObject.NULL;
        Object totalTokens = usageObj != null && usageObj.has("total_tokens") ? usageObj.get("total_tokens") : JSONObject.NULL;
        JSONObject textObj = new JSONObject();
        textObj.put("text", (Object)content);
        JSONArray contentArray = new JSONArray().put((Object)textObj);
        JSONObject message = new JSONObject();
        message.put("role", (Object)role);
        message.put("content", (Object)contentArray);
        JSONObject output = new JSONObject();
        output.put("message", (Object)message);
        JSONObject usage = new JSONObject();
        usage.put("inputTokens", inputTokens);
        usage.put("outputTokens", outputTokens);
        usage.put("totalTokens", totalTokens);
        JSONObject finalPayload = new JSONObject();
        finalPayload.put("output", (Object)output);
        finalPayload.put("stopReason", (Object)(stopReason.equals("stop") ? "end_turn" : stopReason));
        finalPayload.put("usage", (Object)usage);
        finalPayload.put("amazon-bedrock-guardrailAction", (Object)guardrail);
        logger.info(finalPayload.toString(2));
        return finalPayload.toString();
    }

    public static String getFoundationModel(AwsbedrockConfiguration configuration, AwsbedrockParamsModelDetails awsBedrockParameters) {
        BedrockClient bedrockClient = BedrockClients.getBedrockClient(configuration, awsBedrockParameters);
        try {
            GetFoundationModelResponse response = bedrockClient.getFoundationModel((GetFoundationModelRequest)GetFoundationModelRequest.builder().modelIdentifier(awsBedrockParameters.getModelName()).build());
            FoundationModelDetails model = response.modelDetails();
            JSONObject jsonModel = new JSONObject();
            jsonModel.put("modelId", (Object)model.modelId());
            jsonModel.put("modelArn", (Object)model.modelArn());
            jsonModel.put("modelName", (Object)model.modelName());
            jsonModel.put("providerName", (Object)model.providerName());
            jsonModel.put("modelLifecycleStatus", (Object)model.modelLifecycle().statusAsString());
            jsonModel.put("inputModalities", (Collection)model.inputModalities());
            jsonModel.put("outputModalities", (Collection)model.outputModalities());
            jsonModel.put("customizationsSupported", (Collection)model.customizationsSupported());
            jsonModel.put("inferenceTypesSupported", (Collection)model.inferenceTypesSupported());
            jsonModel.put("responseStreamingSupported", (Object)model.responseStreamingSupported());
            return jsonModel.toString();
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SdkException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String listFoundationModels(AwsbedrockConfiguration configuration, AwsbedrockParams awsBedrockParameters) {
        BedrockClient bedrockClient = BedrockClients.getBedrockClient(configuration, awsBedrockParameters);
        try {
            ListFoundationModelsResponse response = bedrockClient.listFoundationModels(r -> {});
            List models = response.modelSummaries();
            logger.info(response.toString());
            logger.info(models.toString());
            JSONArray modelsArray = new JSONArray();
            if (models.isEmpty()) {
                logger.info("No available foundation models");
            } else {
                for (FoundationModelSummary model : models) {
                    JSONObject modelJson = new JSONObject();
                    modelJson.put("modelId", (Object)model.modelId());
                    modelJson.put("modelName", (Object)model.providerName());
                    modelJson.put("provider", (Object)model.modelName());
                    modelJson.put("modelArn", (Object)model.modelArn());
                    modelJson.put("modelLifecycleStatus", (Object)model.modelLifecycle().statusAsString());
                    modelJson.put("inputModalities", (Collection)model.inputModalities());
                    modelJson.put("outputModalities", (Collection)model.outputModalities());
                    modelJson.put("customizationsSupported", (Collection)model.customizationsSupported());
                    modelJson.put("inferenceTypesSupported", (Collection)model.inferenceTypesSupported());
                    modelJson.put("responseStreamingSupported", (Object)model.responseStreamingSupported());
                    modelsArray.put((Object)modelJson);
                }
            }
            return modelsArray.toString();
        }
        catch (SdkClientException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String listCustomModels(AwsbedrockConfiguration configuration, AwsbedrockParams awsBedrockParameters) {
        BedrockClient bedrockClient = BedrockClients.getBedrockClient(configuration, awsBedrockParameters);
        try {
            ListCustomModelsResponse response = bedrockClient.listCustomModels(r -> {});
            List models = response.modelSummaries();
            logger.info(response.toString());
            logger.info(models.toString());
            JSONArray modelsArray = new JSONArray();
            if (models.isEmpty()) {
                logger.info("No available foundation models.");
            } else {
                for (CustomModelSummary model : models) {
                    JSONObject modelJson = new JSONObject();
                    modelJson.put("provider", (Object)model.modelName());
                    modelJson.put("modelArn", (Object)model.modelArn());
                    modelJson.put("baseModelArn", (Object)model.baseModelArn());
                    modelJson.put("baseModelName", (Object)model.baseModelName());
                    modelJson.put("customizationType", (Object)model.customizationTypeAsString());
                    modelsArray.put((Object)modelJson);
                }
            }
            return modelsArray.toString();
        }
        catch (SdkClientException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String getCustomModel(AwsbedrockConfiguration configuration, AwsbedrockParamsModelDetails awsBedrockParameters) {
        BedrockClient bedrockClient = BedrockClients.getBedrockClient(configuration, awsBedrockParameters);
        try {
            GetCustomModelResponse response = bedrockClient.getCustomModel((GetCustomModelRequest)GetCustomModelRequest.builder().modelIdentifier(awsBedrockParameters.getModelName()).build());
            JSONObject jsonModel = new JSONObject();
            jsonModel.put("modelArn", (Object)response.modelArn());
            jsonModel.put("modelName", (Object)response.modelName());
            jsonModel.put("jobName", (Object)response.jobName());
            jsonModel.put("jobArn", (Object)response.jobArn());
            jsonModel.put("customizationTypeAsString", (Object)response.customizationTypeAsString());
            jsonModel.put("baseModelArn", (Object)response.baseModelArn());
            jsonModel.put("hyperParameters", response.hyperParameters());
            jsonModel.put("hasHyperParameters", response.hasHyperParameters());
            jsonModel.put("hasValidationMetrics", response.hasValidationMetrics());
            return jsonModel.toString();
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SdkException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

