/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.helpers;

import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.net.ssl.TrustManagerFactory;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.AwsbedrockParameters;
import org.mule.extension.mulechain.internal.AwsbedrockParams;
import org.mule.extension.mulechain.internal.AwsbedrockParamsModelDetails;
import org.mule.extension.mulechain.internal.CommonUtils;
import org.mule.extension.mulechain.internal.agents.AwsbedrockAgentsParameters;
import org.mule.extension.mulechain.internal.embeddings.AwsbedrockParametersEmbedding;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.BedrockClientBuilder;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClientBuilder;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;

public class BedrockClients {
    private static final ConcurrentHashMap<String, Object> clients = new ConcurrentHashMap();

    private static <T> T getOrCreateClient(String clientType, Supplier<T> clientSupplier) {
        return (T)clients.computeIfAbsent(clientType, k -> clientSupplier.get());
    }

    public static BedrockAgentClient getAgentClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsbedrockAgentsParameters) {
        return BedrockClients.getOrCreateClient("agent", () -> {
            BedrockAgentClientBuilder bedrockAgentClientBuilder = (BedrockAgentClientBuilder)((BedrockAgentClientBuilder)((BedrockAgentClientBuilder)BedrockAgentClient.builder().region(Region.of((String)awsbedrockAgentsParameters.getRegion()))).fipsEnabled(configuration.getFipsModeEnabled())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)BedrockClients.createAwsBasicCredentials(configuration)));
            if (configuration.getEndpointOverride() != null && !configuration.getEndpointOverride().isBlank()) {
                bedrockAgentClientBuilder.endpointOverride(URI.create(configuration.getEndpointOverride()));
            }
            bedrockAgentClientBuilder.httpClient(BedrockClients.getConfiguredHttpClient(configuration));
            return (BedrockAgentClient)bedrockAgentClientBuilder.build();
        });
    }

    public static BedrockAgentRuntimeAsyncClient getAgentRuntimeAsyncClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsbedrockAgentsParameters) {
        return BedrockClients.getOrCreateClient("agentRuntimeAsync", () -> {
            BedrockAgentRuntimeAsyncClientBuilder bedrockAgentRuntimeAsyncClientBuilder = (BedrockAgentRuntimeAsyncClientBuilder)((BedrockAgentRuntimeAsyncClientBuilder)((BedrockAgentRuntimeAsyncClientBuilder)BedrockAgentRuntimeAsyncClient.builder().region(Region.of((String)awsbedrockAgentsParameters.getRegion()))).fipsEnabled(configuration.getFipsModeEnabled())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)BedrockClients.createAwsBasicCredentials(configuration)));
            if (configuration.getEndpointOverride() != null && !configuration.getEndpointOverride().isBlank()) {
                bedrockAgentRuntimeAsyncClientBuilder.endpointOverride(URI.create(configuration.getEndpointOverride()));
            }
            bedrockAgentRuntimeAsyncClientBuilder.httpClient(BedrockClients.getConfiguredAsyncHttpClient(configuration));
            return (BedrockAgentRuntimeAsyncClient)bedrockAgentRuntimeAsyncClientBuilder.build();
        });
    }

    public static BedrockRuntimeClient getRuntimeClient(AwsbedrockConfiguration configuration, String region) {
        return BedrockClients.getOrCreateClient("runtime", () -> {
            AwsCredentials awsCredentials = BedrockClients.createAwsBasicCredentials(configuration);
            BedrockRuntimeClientBuilder bedrockRuntimeClientBuilder = (BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials))).fipsEnabled(configuration.getFipsModeEnabled())).region(Region.of((String)region));
            if (configuration.getEndpointOverride() != null && !configuration.getEndpointOverride().isBlank()) {
                bedrockRuntimeClientBuilder.endpointOverride(URI.create(configuration.getEndpointOverride()));
            }
            bedrockRuntimeClientBuilder.httpClient(BedrockClients.getConfiguredHttpClient(configuration));
            return (BedrockRuntimeClient)bedrockRuntimeClientBuilder.build();
        });
    }

    public static BedrockRuntimeClient getRuntimeClient(AwsbedrockConfiguration configuration, AwsbedrockParametersEmbedding awsbedrockParametersEmbedding) {
        return BedrockClients.getRuntimeClient(configuration, awsbedrockParametersEmbedding.getRegion());
    }

    public static BedrockRuntimeClient getRuntimeClient(AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        return BedrockClients.getRuntimeClient(configuration, awsBedrockParameters.getRegion());
    }

    public static BedrockClient getBedrockClient(AwsbedrockConfiguration configuration, String region) {
        return BedrockClients.getOrCreateClient("bedrock", () -> {
            AwsCredentials awsCredentials = BedrockClients.createAwsBasicCredentials(configuration);
            BedrockClientBuilder bedrockClient = (BedrockClientBuilder)((BedrockClientBuilder)((BedrockClientBuilder)BedrockClient.builder().region(Region.of((String)region))).fipsEnabled(configuration.getFipsModeEnabled())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCredentials));
            if (configuration.getEndpointOverride() != null && !configuration.getEndpointOverride().isBlank()) {
                bedrockClient.endpointOverride(URI.create(configuration.getEndpointOverride()));
            }
            bedrockClient.httpClient(BedrockClients.getConfiguredHttpClient(configuration));
            return (BedrockClient)bedrockClient.build();
        });
    }

    public static BedrockClient getBedrockClient(AwsbedrockConfiguration configuration, AwsbedrockParams awsBedrockParameters) {
        return BedrockClients.getBedrockClient(configuration, awsBedrockParameters.getRegion());
    }

    public static BedrockClient getBedrockClient(AwsbedrockConfiguration configuration, AwsbedrockParamsModelDetails awsbedrockParamsModelDetails) {
        return BedrockClients.getBedrockClient(configuration, awsbedrockParamsModelDetails.getRegion());
    }

    public static IamClient getIamClient(AwsbedrockConfiguration configuration, AwsbedrockAgentsParameters awsbedrockAgentsParameters) {
        return BedrockClients.getOrCreateClient("iam", () -> (IamClient)((IamClientBuilder)((IamClientBuilder)IamClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)BedrockClients.createAwsBasicCredentials(configuration)))).region(Region.of((String)awsbedrockAgentsParameters.getRegion()))).build());
    }

    public static BedrockAgentRuntimeClient getAgentRuntimeClient(AwsbedrockConfiguration configuration, AwsbedrockParameters awsBedrockParameters) {
        return BedrockClients.getOrCreateClient("agentRuntime", () -> (BedrockAgentRuntimeClient)((BedrockAgentRuntimeClientBuilder)BedrockAgentRuntimeClient.builder().region(Region.of((String)awsBedrockParameters.getRegion()))).build());
    }

    private static SdkHttpClient getConfiguredHttpClient(AwsbedrockConfiguration configuration) {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (configuration.getProxyConfig() != null) {
            ProxyConfiguration proxyConfig = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(String.format("%s://%s:%d", configuration.getProxyConfig().getScheme(), configuration.getProxyConfig().getHost(), configuration.getProxyConfig().getPort()))).username(configuration.getProxyConfig().getUsername()).password(configuration.getProxyConfig().getPassword()).nonProxyHosts(configuration.getProxyConfig().getNonProxyHosts()).build();
            httpClientBuilder.proxyConfiguration(proxyConfig);
            if (configuration.getProxyConfig().getTrustStorePath() != null) {
                TlsTrustManagersProvider tlsTrustManagersProvider = BedrockClients.createTlsKeyManagersProvider(configuration.getProxyConfig().getTrustStorePath(), configuration.getProxyConfig().getTrustStorePassword(), configuration.getProxyConfig().getTrustStoreType().name());
                httpClientBuilder.tlsTrustManagersProvider(tlsTrustManagersProvider);
            }
        }
        httpClientBuilder.socketTimeout(CommonUtils.toDuration(configuration.getTimeout(), configuration.getTimeoutUnit()));
        return httpClientBuilder.build();
    }

    private static SdkAsyncHttpClient getConfiguredAsyncHttpClient(AwsbedrockConfiguration configuration) {
        NettyNioAsyncHttpClient.Builder httpClientBuilder = NettyNioAsyncHttpClient.builder();
        if (configuration.getProxyConfig() != null) {
            software.amazon.awssdk.http.nio.netty.ProxyConfiguration proxyConfig = (software.amazon.awssdk.http.nio.netty.ProxyConfiguration)software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().host(configuration.getProxyConfig().getHost()).port(configuration.getProxyConfig().getPort()).username(configuration.getProxyConfig().getUsername()).password(configuration.getProxyConfig().getPassword()).nonProxyHosts(configuration.getProxyConfig().getNonProxyHosts()).build();
            httpClientBuilder.proxyConfiguration(proxyConfig);
            if (configuration.getProxyConfig().getTrustStorePath() != null) {
                TlsTrustManagersProvider tlsTrustManagersProvider = BedrockClients.createTlsKeyManagersProvider(configuration.getProxyConfig().getTrustStorePath(), configuration.getProxyConfig().getTrustStorePassword(), configuration.getProxyConfig().getTrustStoreType().name());
                httpClientBuilder.tlsTrustManagersProvider(tlsTrustManagersProvider);
            }
        }
        httpClientBuilder.readTimeout(CommonUtils.toDuration(configuration.getTimeout(), configuration.getTimeoutUnit()));
        return httpClientBuilder.build();
    }

    private static TlsTrustManagersProvider createTlsKeyManagersProvider(String trustStorePath, String trustStorePassword, String trustStoreType) {
        try {
            KeyStore trustStore = KeyStore.getInstance(trustStoreType);
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                trustStore.load(fis, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return () -> trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to configure JKS truststore", e);
        }
    }

    private static AwsCredentials createAwsBasicCredentials(AwsbedrockConfiguration configuration) {
        if (configuration.getAwsSessionToken() == null || configuration.getAwsSessionToken().isEmpty()) {
            return AwsBasicCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey());
        }
        return AwsSessionCredentials.create((String)configuration.getAwsAccessKeyId(), (String)configuration.getAwsSecretAccessKey(), (String)configuration.getAwsSessionToken());
    }

    public static void closeAll() {
        clients.values().forEach(client -> {
            if (client instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)client).close();
                }
                catch (Exception e) {
                    System.err.println("Error closing client: " + e.getMessage());
                }
            }
        });
        clients.clear();
    }
}

