/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.mule.extension.mulechain.helpers.AwsbedrockPayloadHelper;
import org.mule.extension.mulechain.helpers.AwsbedrockPromptTemplateHelper;
import org.mule.extension.mulechain.internal.AwsbedrockConfiguration;
import org.mule.extension.mulechain.internal.AwsbedrockParameters;
import org.mule.extension.mulechain.internal.AwsbedrockParams;
import org.mule.extension.mulechain.internal.AwsbedrockParamsModelDetails;
import org.mule.extension.mulechain.internal.BedrockErrorsProvider;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsbedrockOperations {
    private static final Logger logger = LoggerFactory.getLogger(AwsbedrockOperations.class);

    @MediaType(value="application/json", strict=false)
    @Throws(value={BedrockErrorsProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="CHAT-answer-prompt")
    public InputStream answerPrompt(String prompt, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParameters awsBedrockParameters) {
        String response = AwsbedrockPayloadHelper.invokeModel(prompt, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Throws(value={BedrockErrorsProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="AGENT-define-prompt-template")
    public InputStream definePromptTemplate(String template, String instructions, String dataset, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParameters awsBedrockParameters) {
        String finalPromptTemplate = AwsbedrockPromptTemplateHelper.definePromptTemplate(template, instructions, dataset);
        logger.info(finalPromptTemplate);
        String response = AwsbedrockPayloadHelper.invokeModel(finalPromptTemplate, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Throws(value={BedrockErrorsProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="SENTIMENT-analyze")
    public InputStream extractSentiments(String TextToAnalyze, @Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParameters awsBedrockParameters) {
        String SentimentTemplate = "Analyze sentiment of: " + TextToAnalyze + ". Does it have a positive sentiment? Respond in JSON with Sentiment (value of POSITIVE, NEGATIVE, NEUTRAL) and IsPositive (true or false)";
        String response = AwsbedrockPayloadHelper.invokeModel(SentimentTemplate, configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Throws(value={BedrockErrorsProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="FOUNDATIONAL-model-details")
    public InputStream getFoundationalModelByModelId(@Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParamsModelDetails awsBedrockParameters) {
        String response = AwsbedrockPayloadHelper.getFoundationModel(configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Throws(value={BedrockErrorsProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="FOUNDATIONAL-models-list")
    public InputStream getFoundationalModelList(@Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParams awsBedrockParameters) {
        String response = AwsbedrockPayloadHelper.listFoundationModels(configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Throws(value={BedrockErrorsProvider.class})
    @Execution(value=ExecutionType.BLOCKING)
    @Alias(value="CUSTOM-model-details")
    public InputStream getCustomModelByModelId(@Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParamsModelDetails awsBedrockParameters) {
        String response = AwsbedrockPayloadHelper.getCustomModel(configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="CUSTOM-models-list")
    @Execution(value=ExecutionType.BLOCKING)
    @Throws(value={BedrockErrorsProvider.class})
    public InputStream getCustomModelList(@Config AwsbedrockConfiguration configuration, @ParameterGroup(name="Additional properties") AwsbedrockParams awsBedrockParameters) {
        String response = AwsbedrockPayloadHelper.listCustomModels(configuration, awsBedrockParameters);
        return IOUtils.toInputStream((String)response, (Charset)StandardCharsets.UTF_8);
    }
}

