/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.einsteinai.internal.operation;

import com.mulesoft.connector.einsteinai.api.metadata.EinsteinResponseAttributes;
import com.mulesoft.connector.einsteinai.api.metadata.ResponseParameters;
import com.mulesoft.connector.einsteinai.internal.connection.EinsteinConnection;
import com.mulesoft.connector.einsteinai.internal.error.EinsteinErrorType;
import com.mulesoft.connector.einsteinai.internal.error.provider.EmbeddingErrorTypeProvider;
import com.mulesoft.connector.einsteinai.internal.modelsapi.helpers.ResponseHelper;
import com.mulesoft.connector.einsteinai.internal.modelsapi.models.ParamsEmbeddingDocumentDetails;
import com.mulesoft.connector.einsteinai.internal.modelsapi.models.ParamsEmbeddingModelDetails;
import com.mulesoft.connector.einsteinai.internal.modelsapi.models.ParamsModelDetails;
import com.mulesoft.connector.einsteinai.internal.modelsapi.models.RAGParamsModelDetails;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EinsteinEmbeddingOperations {
    private static final Logger log = LoggerFactory.getLogger(EinsteinEmbeddingOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-generate-from-text")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinEmbeddingResponse.json")
    public void generateEmbeddingFromText(@Connection EinsteinConnection connection, @Content String text, @ParameterGroup(name="Additional properties") ParamsEmbeddingModelDetails paramDetails, CompletionCallback<InputStream, ResponseParameters> callback) {
        log.info("Executing generate embedding from text operation.");
        try {
            connection.getRequestHelper().generateEmbeddingFromText(text, paramDetails, callback);
        }
        catch (Exception e) {
            callback.error((Throwable)new ModuleException("Error while executing embedding generate from text operation", (ErrorTypeDefinition)EinsteinErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e));
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-generate-from-file")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinFileEmbeddingResponse.json")
    public Result<InputStream, Void> generateEmbeddingFromFile(@Connection EinsteinConnection connection, @Content InputStream inputStream, @ParameterGroup(name="Additional properties") ParamsEmbeddingDocumentDetails paramDetails) {
        log.info("Executing generate embedding from file operation.");
        try {
            JSONArray response = connection.getRequestHelper().generateEmbeddingFromFileInputStream(inputStream, paramDetails);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("result", (Object)response);
            return ResponseHelper.createEinsteinDefaultResponse(jsonObject.toString());
        }
        catch (Exception e) {
            throw new ModuleException("Error while executing embedding generate from file operation", (ErrorTypeDefinition)EinsteinErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="EMBEDDING-adhoc-file-query")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinFileEmbeddingResponse.json")
    public Result<InputStream, Void> queryEmbeddingOnFiles(@Connection EinsteinConnection connection, @Content String prompt, @Content InputStream inputStream, @ParameterGroup(name="Additional properties") ParamsEmbeddingDocumentDetails paramDetails) {
        log.info("Executing embedding adhoc file query operation.");
        try {
            JSONArray response = connection.getRequestHelper().embeddingFileQuery(prompt, inputStream, paramDetails.getModelApiName(), paramDetails.getFileType(), paramDetails.getOptionType());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("result", (Object)response);
            return ResponseHelper.createEinsteinDefaultResponse(jsonObject.toString());
        }
        catch (Exception e) {
            throw new ModuleException("Error while generating the chat, for prompt " + prompt, (ErrorTypeDefinition)EinsteinErrorType.EMBEDDING_OPERATIONS_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="RAG-adhoc-load-document")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinOperationResponse.json")
    public Result<InputStream, EinsteinResponseAttributes> ragOnFiles(@Connection EinsteinConnection connection, @Content String prompt, @Content InputStream inputStream, @ParameterGroup(name="Additional properties") RAGParamsModelDetails paramDetails) {
        log.info("Executing rag adhoc load document.");
        try {
            String content = connection.getRequestHelper().embeddingFileQuery(prompt, inputStream, paramDetails.getEmbeddingName(), paramDetails.getFileType(), paramDetails.getOptionType()).toString();
            InputStream responseStream = connection.getRequestHelper().executeRAG("data: " + content + ", question: " + prompt, paramDetails);
            return ResponseHelper.createEinsteinFormattedResponse(responseStream);
        }
        catch (Exception e) {
            throw new ModuleException("Error while doing rag adhoc load document for prompt " + prompt, (ErrorTypeDefinition)EinsteinErrorType.RAG_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="Tools-use-ai-service")
    @Throws(value={EmbeddingErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/EinsteinOperationResponse.json")
    public Result<InputStream, EinsteinResponseAttributes> executeTools(@Connection EinsteinConnection connection, @Content String prompt, @Content InputStream inputStream, @ParameterGroup(name="Additional properties") ParamsModelDetails paramDetails) {
        log.info("Executing AI service tools operation.");
        try {
            String content = connection.getRequestHelper().embeddingFileQuery(prompt, inputStream, "sfdc_ai__DefaultOpenAITextEmbeddingAda_002", "text", "FULL").toString();
            inputStream.reset();
            InputStream responseStream = connection.getRequestHelper().executeTools(prompt, "data: " + content + ", question: " + prompt, inputStream, paramDetails);
            return ResponseHelper.createEinsteinFormattedResponse(responseStream);
        }
        catch (Exception e) {
            throw new ModuleException("Error while executing AI service tools, for prompt " + prompt, (ErrorTypeDefinition)EinsteinErrorType.TOOLS_OPERATION_FAILURE, (Throwable)e);
        }
    }
}

